/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtcp;

import java.time.Instant;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtcp.RtcpListener;
import org.jitsi.nlj.rtp.bandwidthestimation.BandwidthEstimator;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbRembPacket;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tJ\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/nlj/rtcp/RembHandler;", "Lorg/jitsi/nlj/rtcp/RtcpListener;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;)V", "bweUpdateListeners", "", "Lorg/jitsi/nlj/rtp/bandwidthestimation/BandwidthEstimator$Listener;", "logger", "sawSpuriousRemb", "", "getStreamInformationStore", "()Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "addListener", "", "bweUpdateListener", "onRembPacket", "rembPacket", "Lorg/jitsi/rtp/rtcp/rtcpfb/payload_specific_fb/RtcpFbRembPacket;", "rtcpPacketReceived", "packet", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "receivedTime", "Ljava/time/Instant;", "Companion", "jitsi-media-transform"})
public final class RembHandler
implements RtcpListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformationStore;
    @NotNull
    private final Logger logger;
    private boolean sawSpuriousRemb;
    @NotNull
    private final List<BandwidthEstimator.Listener> bweUpdateListeners;
    @NotNull
    private static final AtomicInteger endpointsWithSpuriousRemb = new AtomicInteger();

    public RembHandler(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.streamInformationStore = streamInformationStore;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.bweUpdateListeners = new CopyOnWriteArrayList();
    }

    @NotNull
    public final ReadOnlyStreamInformationStore getStreamInformationStore() {
        return this.streamInformationStore;
    }

    @Override
    public void rtcpPacketReceived(@Nullable RtcpPacket packet, @Nullable Instant receivedTime) {
        if (packet instanceof RtcpFbRembPacket) {
            this.logger.debug(RembHandler::rtcpPacketReceived$lambda-0);
            this.onRembPacket((RtcpFbRembPacket)packet);
        }
    }

    public final void addListener(@NotNull BandwidthEstimator.Listener bweUpdateListener) {
        Intrinsics.checkNotNullParameter(bweUpdateListener, "bweUpdateListener");
        this.bweUpdateListeners.add(bweUpdateListener);
    }

    private final void onRembPacket(RtcpFbRembPacket rembPacket) {
        if (this.streamInformationStore.getSupportsTcc()) {
            if (!this.sawSpuriousRemb) {
                this.logger.warn(() -> RembHandler.onRembPacket$lambda-1(rembPacket));
                endpointsWithSpuriousRemb.incrementAndGet();
                this.sawSpuriousRemb = true;
            }
            return;
        }
        this.logger.debug(() -> RembHandler.onRembPacket$lambda-2(rembPacket));
        Iterable $this$forEach$iv = this.bweUpdateListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BandwidthEstimator.Listener it = (BandwidthEstimator.Listener)element$iv;
            boolean bl = false;
            it.bandwidthEstimationChanged-_2icLw0(BandwidthKt.getBps(rembPacket.getBitrate()));
        }
    }

    private static final String rtcpPacketReceived$lambda-0() {
        return "Received REMB packet";
    }

    private static final String onRembPacket$lambda-1(RtcpFbRembPacket $rembPacket) {
        Intrinsics.checkNotNullParameter($rembPacket, "$rembPacket");
        return "Ignoring unexpected REMB, when using TCC (for " + Bandwidth.toString-impl(BandwidthKt.getBps($rembPacket.getBitrate())) + " bps). Will suppress future logs for this endpoint.";
    }

    private static final String onRembPacket$lambda-2(RtcpFbRembPacket $rembPacket) {
        Intrinsics.checkNotNullParameter($rembPacket, "$rembPacket");
        return "Updating bandwidth to " + Bandwidth.toString-impl(BandwidthKt.getBps($rembPacket.getBitrate()));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0005R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/nlj/rtcp/RembHandler$Companion;", "", "()V", "endpointsWithSpuriousRemb", "Ljava/util/concurrent/atomic/AtomicInteger;", "", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public final int endpointsWithSpuriousRemb() {
            return endpointsWithSpuriousRemb.get();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

