/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import java.io.File;
import java.util.function.Function;
import javax.inject.Inject;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.cache.DefaultCacheCleanupStrategy;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.HasCleanupAction;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.UnscopedCacheBuilderFactory;
import org.gradle.cache.internal.CleanupActionDecorator;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.caching.local.internal.H2BuildCacheService;
import org.gradle.caching.local.internal.LockOnDemandCrossProcessBuildCacheService;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.time.Time;

public class H2BuildCacheServiceFactory
implements BuildCacheServiceFactory<DirectoryBuildCache> {
    private static final String BUILD_CACHE_VERSION = "2";
    private static final String BUILD_CACHE_KEY = "build-cache-2";
    private static final String H2_BUILD_CACHE_TYPE = "h2";
    private final FileLockManager lockManager;
    private final UnscopedCacheBuilderFactory unscopedCacheBuilderFactory;
    private final GlobalScopedCacheBuilderFactory cacheBuilderFactory;
    private final ParallelismConfiguration parallelismConfiguration;
    private final PathToFileResolver resolver;
    private final CleanupActionDecorator cleanupActionDecorator;

    @Inject
    public H2BuildCacheServiceFactory(FileLockManager lockManager, CleanupActionDecorator cleanupActionDecorator, UnscopedCacheBuilderFactory unscopedCacheBuilderFactory, GlobalScopedCacheBuilderFactory cacheBuilderFactory, ParallelismConfiguration parallelismConfiguration, PathToFileResolver resolver) {
        this.lockManager = lockManager;
        this.cleanupActionDecorator = cleanupActionDecorator;
        this.unscopedCacheBuilderFactory = unscopedCacheBuilderFactory;
        this.cacheBuilderFactory = cacheBuilderFactory;
        this.parallelismConfiguration = parallelismConfiguration;
        this.resolver = resolver;
    }

    public BuildCacheService createBuildCacheService(DirectoryBuildCache configuration, BuildCacheServiceFactory.Describer describer) {
        Object cacheDirectory = configuration.getDirectory();
        File target = cacheDirectory != null ? this.resolver.resolve(cacheDirectory) : this.cacheBuilderFactory.baseDirForCrossVersionCache(BUILD_CACHE_KEY);
        H2BuildCacheServiceFactory.checkDirectory(target);
        int removeUnusedEntriesAfterDays = configuration.getRemoveUnusedEntriesAfterDays();
        describer.type(H2_BUILD_CACHE_TYPE).config("location", target.getAbsolutePath()).config("removeUnusedEntriesAfter", removeUnusedEntriesAfterDays + " days");
        Function<HasCleanupAction, PersistentCache> persistentCacheFactory = buildCacheService -> this.unscopedCacheBuilderFactory.cache(target).withCleanupStrategy(this.createCacheCleanupStrategy((cleanableStore, progressMonitor) -> buildCacheService.cleanup())).withDisplayName("Build cache NG").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).open();
        H2BuildCacheService h2Service = new H2BuildCacheService(target.toPath(), this.parallelismConfiguration.getMaxWorkerCount(), removeUnusedEntriesAfterDays, Time.clock());
        return new LockOnDemandCrossProcessBuildCacheService(BUILD_CACHE_KEY, target, this.lockManager, h2Service, persistentCacheFactory);
    }

    private CacheCleanupStrategy createCacheCleanupStrategy(CleanupAction cleanupAction) {
        return DefaultCacheCleanupStrategy.from((CleanupAction)this.cleanupActionDecorator.decorate(cleanupAction));
    }

    private static void checkDirectory(File directory) {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be a directory", directory));
            }
            if (!directory.canRead()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be readable", directory));
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be writable", directory));
            }
        } else if (!directory.mkdirs()) {
            throw new UncheckedIOException(String.format("Could not create cache directory: %s", directory));
        }
    }
}

