/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildQueue;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerColonyTile;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.server.model.TurnTaker;

public class ServerColony
extends Colony
implements TurnTaker {
    private static final Logger logger = Logger.getLogger(ServerColony.class.getName());

    public ServerColony(Game game, String id) {
        super(game, id);
    }

    public ServerColony(Game game, Player owner, String name, Tile tile) {
        super(game, owner, name, tile);
        Specification spec = this.getSpecification();
        this.setGoodsContainer(new GoodsContainer(game, this));
        this.sonsOfLiberty = 0;
        this.oldSonsOfLiberty = 0;
        this.established = game.getTurn();
        ServerColonyTile colonyTile = new ServerColonyTile(game, this, tile);
        this.colonyTiles.add(colonyTile);
        for (Tile t : tile.getSurroundingTiles(this.getRadius())) {
            this.colonyTiles.add(new ServerColonyTile(game, this, t));
        }
        List<BuildingType> buildingTypes = spec.getBuildingTypeList();
        for (BuildingType buildingType : CollectionUtils.transform(buildingTypes, bt -> bt.isAutomaticBuild() || this.isAutomaticBuild((BuildingType)bt))) {
            this.addBuilding(new ServerBuilding(this.getGame(), this, buildingType));
        }
        if (this.isLandLocked()) {
            this.buildQueue.add(spec.getBuildingType("model.building.warehouse"));
        } else {
            this.buildQueue.add(spec.getBuildingType("model.building.docks"));
            this.addPortAbility();
        }
        for (UnitType unitType : CollectionUtils.transform(spec.getUnitTypesWithAbility("model.ability.bornInColony"), BuildableType::needsGoodsToBuild)) {
            this.populationQueue.add(unitType);
        }
    }

    private boolean neededForBuildableType(GoodsType goodsType) {
        Specification spec = this.getSpecification();
        ArrayList<BuildableType> buildables = new ArrayList<BuildableType>();
        buildables.addAll(spec.getBuildingTypeList());
        buildables.addAll(spec.getUnitTypesWithoutAbility("model.ability.person"));
        return CollectionUtils.any(buildables, bt -> this.canBuild((BuildableType)bt) && CollectionUtils.any(bt.getRequiredGoods(), AbstractGoods.matches(goodsType)));
    }

    private Unit csBuildUnit(BuildQueue<? extends BuildableType> buildQueue, Random random, ChangeSet cs) {
        UnitType type = (UnitType)buildQueue.getCurrentlyBuilding();
        ServerUnit unit = new ServerUnit(this.getGame(), this.getTile(), this.owner, type);
        unit.setName(this.owner.getNameForUnit(type, random));
        if (unit.hasAbility("model.ability.bornInColony")) {
            cs.addMessage(this.owner, (ModelMessage)new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.colony.newColonist", this, unit).addName("%colony%", this.getName()));
        } else {
            unit.setName(this.owner.getNameForUnit(type, random));
            cs.addMessage(this.owner, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.colony.unitReady", this, unit).addName("%colony%", this.getName())).addStringTemplate("%unit%", unit.getLabel()));
        }
        logger.info("New unit in " + this.getName() + ": " + type.getSuffix());
        return unit;
    }

    public boolean ejectUnits(WorkLocation workLocation, List<Unit> units) {
        if (units == null || units.isEmpty()) {
            return false;
        }
        for (Unit u : units) {
            Iterator<WorkLocation> iterator = CollectionUtils.transform(this.getAvailableWorkLocations(), w -> w != workLocation && w.canAdd(u)).iterator();
            if (iterator.hasNext()) {
                WorkLocation wl = iterator.next();
                u.setLocation(wl);
                continue;
            }
            u.setLocation(this.getTile());
        }
        if (this.getOwner().isAI()) {
            this.firePropertyChange("rearrangeColony", true, false);
        }
        return true;
    }

    private boolean csBuildBuilding(BuildQueue<? extends BuildableType> buildQueue, ChangeSet cs) {
        boolean success;
        BuildingType type = (BuildingType)buildQueue.getCurrentlyBuilding();
        Tile copied = this.getTile().getTileToCache();
        BuildingType from = type.getUpgradesFrom();
        if (from == null) {
            success = this.buildBuilding(new ServerBuilding(this.getGame(), this, type));
        } else {
            Building building = this.getBuilding(from);
            List<Unit> eject = building.upgrade();
            boolean bl = success = eject != null;
            if (success) {
                this.ejectUnits(building, eject);
                if (!eject.isEmpty()) {
                    this.getTile().cacheUnseen(copied);
                }
            } else {
                cs.addMessage(this.owner, this.getUnbuildableMessage(type));
            }
        }
        if (success) {
            cs.addMessage(this.owner, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.BUILDING_COMPLETED, "model.colony.buildingReady", this).addName("%colony%", this.getName())).addNamed("%building%", type));
            if (this.owner.isAI()) {
                this.firePropertyChange("rearrangeColony", true, false);
            }
            logger.info("New building in " + this.getName() + ": " + type.getSuffix());
        }
        return success;
    }

    private BuildableType csNextBuildable(BuildQueue<? extends BuildableType> queue, ChangeSet cs) {
        BuildableType buildable;
        Specification spec = this.getSpecification();
        Player owner = this.getOwner();
        boolean invalidate = false;
        Predicate<GoodsType> notBuildingPred = gt -> gt.isBuildingMaterial() && !gt.isStorable() && this.getTotalProductionOf((GoodsType)gt) > 0;
        while ((buildable = queue.getCurrentlyBuilding()) != null) {
            switch (this.getNoBuildReason(buildable, null)) {
                case LIMIT_EXCEEDED: {
                    break;
                }
                case NONE: {
                    return buildable;
                }
                case NOT_BUILDING: {
                    if (CollectionUtils.any(spec.getGoodsTypeList(), notBuildingPred)) {
                        cs.addMessage(owner, (ModelMessage)new ModelMessage(ModelMessage.MessageType.WARNING, "model.colony.cannotBuild", this).addName("%colony%", this.getName()));
                    }
                    return null;
                }
                case POPULATION_TOO_SMALL: {
                    cs.addMessage(owner, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.WARNING, "model.colony.buildNeedPop", this).addName("%colony%", this.getName())).addNamed("%building%", buildable));
                    break;
                }
                default: {
                    logger.warning("Unexpected build failure at " + this.getName() + " for " + buildable + ": " + this.getNoBuildReason(buildable, null));
                    cs.addMessage(owner, this.getUnbuildableMessage(buildable));
                }
            }
            queue.remove(0);
            invalidate = true;
        }
        if (invalidate) {
            this.invalidateCache();
        }
        return null;
    }

    public void csEvictUsers(Unit enemyUnit, ChangeSet cs) {
        Player player = this.getOwner();
        Tile tile = enemyUnit.getTile();
        ServerColonyTile ct = (ServerColonyTile)this.getColonyTile(tile);
        if (ct == null) {
            return;
        }
        Tile colonyTile = ct.getColony().getTile();
        Tile copied = colonyTile.getTileToCache();
        if (!this.ejectUnits(ct, ct.getUnitList())) {
            return;
        }
        colonyTile.cacheUnseen(copied);
        cs.addMessage(player, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.WARNING, "model.colony.workersEvicted", this, this).addName("%colony%", this.getName())).addStringTemplate("%location%", tile.getLocationLabel())).addStringTemplate("%enemyUnit%", enemyUnit.getLabel()));
        cs.add(ChangeSet.See.only(player), ct);
        cs.add(ChangeSet.See.perhaps(), this.getTile());
    }

    public void csChangeOwner(Player newOwner, boolean reassign, String change, ChangeSet cs) {
        Player oldOwner = this.getOwner();
        Tile tile = this.getTile();
        Set<Tile> owned = this.getOwnedTiles();
        Set<Tile> unseen = ((ServerPlayer)newOwner).collectNewTiles(this.getVisibleTileSet());
        for (Tile t : owned) {
            t.cacheUnseen(newOwner);
        }
        this.changeOwner(newOwner);
        List<Unit> units = this.getAllUnitsList();
        for (Unit u : units) {
            ((ServerPlayer)oldOwner).csChangeOwner(u, newOwner, change, null, cs);
        }
        cs.addRemoves(ChangeSet.See.only(oldOwner), this, units);
        for (ExportData exportDatum : this.exportData.values()) {
            exportDatum.setExported(false);
        }
        this.buildQueue.clear();
        this.updateSoL();
        this.updateProductionBonus();
        if (reassign) {
            owned.remove(tile);
            ((ServerPlayer)oldOwner).reassignTiles(owned, this);
            owned.add(tile);
            for (Tile t : CollectionUtils.transform(owned, t2 -> t2.getOwningSettlement() != this)) {
                ColonyTile ct = this.getColonyTile(t);
                this.ejectUnits(ct, ct.getUnitList());
            }
        }
        unseen.addAll(owned);
        cs.add(ChangeSet.See.only(newOwner), unseen);
        cs.add(ChangeSet.See.perhaps().always(oldOwner).except(newOwner), owned);
    }

    public void csFreeBuilding(BuildingType type, ChangeSet cs) {
        if (!this.canBuild(type)) {
            return;
        }
        Building found = this.getBuilding(type);
        List<Object> present = found == null ? Collections.emptyList() : found.getUnitList();
        Player owner = this.getOwner();
        ServerBuilding build = new ServerBuilding(this.getGame(), this, type);
        this.buildBuilding(build);
        this.checkBuildQueueIntegrity(true, null);
        cs.add(ChangeSet.See.only(owner), this);
        if (owner.isAI()) {
            this.firePropertyChange("rearrangeColony", true, false);
        }
        for (Unit unit : present) {
            unit.setLocation(build);
        }
    }

    private boolean buildBuilding(Building building) {
        Tile copied;
        Tile tile = copied = building.getType().isDefenceType() ? this.getTile().getTileToCache() : null;
        if (!this.addBuilding(building)) {
            return false;
        }
        this.getTile().cacheUnseen(copied);
        this.invalidateCache();
        return true;
    }

    public boolean csEquipForRole(Unit unit, Role role, int roleCount, Random random, ChangeSet cs) {
        boolean ret = this.equipForRole(unit, role, roleCount);
        if (ret) {
            if (unit.isOnCarrier()) {
                unit.setMovesLeft(0);
            }
            Tile tile = this.getTile();
            tile.cacheUnseen();
            unit.setLocation(tile);
            cs.add(ChangeSet.See.perhaps(), tile);
        }
        return ret;
    }

    public void csAddConvert(Unit brave, ChangeSet cs) {
        if (brave == null) {
            return;
        }
        Player newOwner = this.getOwner();
        ServerPlayer oldOwner = (ServerPlayer)brave.getOwner();
        if (oldOwner.csChangeOwner(brave, newOwner, "model.unitChange.conversion", this.getTile(), cs)) {
            brave.changeRole(this.getSpecification().getDefaultRole(), 0);
            for (Goods g : brave.getCompactGoodsList()) {
                brave.removeGoods(g);
            }
            brave.setMovesLeft(0);
            brave.setState(Unit.UnitState.ACTIVE);
            cs.addDisappear(newOwner, this.tile, brave);
            cs.add(ChangeSet.See.only(newOwner), this.getTile());
            StringTemplate nation = oldOwner.getNationLabel();
            cs.addMessage(newOwner, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.UNIT_ADDED, "model.colony.newConvert", brave).addStringTemplate("%nation%", nation)).addName("%colony%", this.getName()));
            newOwner.invalidateCanSeeTiles();
            logger.fine("Convert at " + this.getName() + " for " + this.getName());
        }
    }

    public boolean destroyBuilding(Building building) {
        Tile copied;
        Tile tile = copied = building.getType().isDefenceType() ? this.getTile().getTileToCache() : null;
        if (!this.removeBuilding(building)) {
            return false;
        }
        this.getTile().cacheUnseen(copied);
        this.invalidateCache();
        this.checkBuildQueueIntegrity(true, null);
        return true;
    }

    public void csNewTurnWarnings(Random random, LogBuilder lb, ChangeSet cs) {
        Specification spec = this.getSpecification();
        BuildQueue[] queues = new BuildQueue[]{this.buildQueue, this.populationQueue};
        GoodsContainer container = this.getGoodsContainer();
        for (WorkLocation wl : this.getCurrentWorkLocationsList()) {
            if (!(wl instanceof ServerBuilding)) continue;
            ((ServerBuilding)wl).csCheckMissingInput(this.getProductionInfo(wl), cs);
        }
        for (BuildQueue queue : queues) {
            AbstractGoods needed;
            int complete;
            Object build;
            ProductionInfo info = this.getProductionInfo(queue);
            if (info == null || !info.getConsumption().isEmpty() || (build = queue.getCurrentlyBuilding()) == null || (complete = this.getTurnsToComplete((BuildableType)build, needed = new AbstractGoods())) != -2 && complete != -1) continue;
            cs.addMessage(this.owner, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.MISSING_GOODS, "model.colony.buildableNeedsGoods", this, (FreeColObject)build).addName("%colony%", this.getName())).addNamed("%buildable%", (Named)build)).addAmount("%amount%", needed.getAmount())).addNamed("%goodsType%", needed.getType()));
        }
        int limit = this.getWarehouseCapacity();
        int adjustment = limit / 100;
        for (Goods goods : CollectionUtils.transform(this.getCompactGoodsList(), AbstractGoods::isStorable)) {
            int loss;
            GoodsType type = goods.getType();
            ExportData exportData = this.getExportData(type);
            int low = exportData.getLowLevel() * adjustment;
            int high = exportData.getHighLevel() * adjustment;
            int amount = goods.getAmount();
            int oldAmount = container.getOldGoodsCount(type);
            if (amount < low && oldAmount >= low && type != spec.getPrimaryFoodType()) {
                cs.addMessage(this.owner, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.WAREHOUSE_CAPACITY, "model.colony.warehouseEmpty", this, type).addNamed("%goods%", type)).addAmount("%level%", low)).addName("%colony%", this.getName()));
                continue;
            }
            if (type.limitIgnored()) continue;
            String messageId = null;
            int waste = 0;
            if (amount > limit) {
                waste = amount - limit;
                container.removeGoods(type, waste);
                messageId = "model.colony.warehouseWaste";
            } else if (amount == limit && oldAmount < limit) {
                messageId = "model.colony.warehouseOverfull";
            } else if (amount > high && oldAmount <= high) {
                messageId = "model.colony.warehouseFull";
            }
            if (messageId != null) {
                cs.addMessage(this.owner, (ModelMessage)((StringTemplate)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.WAREHOUSE_CAPACITY, messageId, this, type).addNamed("%goods%", type)).addAmount("%waste%", waste)).addAmount("%level%", high)).addName("%colony%", this.getName()));
            }
            if (exportData.getExported() && this.hasAbility("model.ability.export") && this.owner.canTrade(type, Market.Access.CUSTOM_HOUSE) || amount > limit || (loss = amount + this.getNetProductionOf(type) - limit) <= 0) continue;
            cs.addMessage(this.owner, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.WAREHOUSE_CAPACITY, "model.colony.warehouseSoonFull", this, type).addNamed("%goods%", goods)).addName("%colony%", this.getName())).addAmount("%amount%", loss));
        }
        if (CollectionUtils.any(queues, BuildQueue::isEmpty) && CollectionUtils.any(spec.getGoodsTypeList(), g -> g.isBuildingMaterial() && !g.isRawMaterial() && !g.isBreedable() && this.getAdjustedNetProductionOf((GoodsType)g) > 0 && this.neededForBuildableType((GoodsType)g))) {
            cs.addMessage(this.owner, (ModelMessage)new ModelMessage(ModelMessage.MessageType.BUILDING_COMPLETED, "model.colony.notBuildingAnything", this).addName("%colony%", this.getName()));
        }
    }

    @Override
    public void csNewTurn(Random random, LogBuilder lb, ChangeSet cs) {
        lb.add("COLONY ", this);
        Specification spec = this.getSpecification();
        ServerPlayer owner = (ServerPlayer)this.getOwner();
        BuildQueue[] queues = new BuildQueue[]{this.buildQueue, this.populationQueue};
        Tile tile = this.getTile();
        if (this.getUnitCount() <= 0) {
            lb.add(" 0-unit DISPOSING, ");
            owner.csDisposeSettlement(this, cs);
            return;
        }
        boolean tileDirty = false;
        boolean newUnitBorn = false;
        GoodsContainer container = this.getGoodsContainer();
        container.saveState();
        for (WorkLocation wl : this.getCurrentWorkLocationsList()) {
            Object productionInfo;
            if (wl instanceof TurnTaker) {
                ((TurnTaker)((Object)wl)).csNewTurn(random, lb, cs);
            }
            if ((productionInfo = this.getProductionInfo(wl)) == null || wl.isEmpty()) continue;
            for (AbstractGoods goods : ((ProductionInfo)productionInfo).getProduction()) {
                UnitType expert = spec.getExpertForProducing(goods.getType());
                int experience = goods.getAmount() / wl.getUnitCount();
                for (Unit unit : CollectionUtils.transform(wl.getUnits(), u -> u.getUnitChange("model.unitChange.experience", expert) != null)) {
                    unit.changeExperienceType(goods.getType());
                    unit.setExperience(unit.getExperience() + experience);
                    cs.addPartial(ChangeSet.See.only(owner), unit, "experience", String.valueOf(unit.getExperience()));
                }
            }
        }
        TypeCountMap<GoodsType> productionMap = this.getProductionMap();
        ArrayList<Object> built = new ArrayList<Object>();
        for (BuildQueue queue : queues) {
            BuildableType buildable;
            ProductionInfo info = this.getProductionInfo(queue);
            if (info == null || info.getConsumption().isEmpty() || (buildable = this.csNextBuildable(queue, cs)) == null) continue;
            if (buildable instanceof UnitType) {
                Unit newUnit = this.csBuildUnit(queue, random, cs);
                if (newUnit.hasAbility("model.ability.bornInColony")) {
                    newUnitBorn = true;
                }
                built.add(queue);
                continue;
            }
            if (buildable instanceof BuildingType) {
                int unitCount = this.getUnitCount();
                if (!this.csBuildBuilding(queue, cs)) continue;
                built.add(queue);
                tileDirty = ((BuildingType)buildable).isDefenceType() || unitCount != this.getUnitCount();
                continue;
            }
            throw new IllegalStateException("Bogus buildable: " + buildable);
        }
        for (GoodsType goodsType : productionMap.keySet()) {
            int turns;
            int stored;
            int net = productionMap.getCount(goodsType);
            if (net + (stored = this.getGoodsCount(goodsType)) <= 0) {
                this.removeGoods(goodsType, stored);
            } else {
                this.addGoods(goodsType, net);
            }
            if (goodsType != spec.getPrimaryFoodType()) continue;
            if (net + stored < 0) {
                if (this.getUnitCount() > 1) {
                    Unit victim = RandomUtils.getRandomMember(logger, "Starver", this.getUnits(), random);
                    ((ServerUnit)victim).csRemove(ChangeSet.See.only(owner), null, cs);
                    cs.addMessage(owner, (ModelMessage)new ModelMessage(ModelMessage.MessageType.UNIT_LOST, "model.colony.colonistStarved", this).addName("%colony%", this.getName()));
                    continue;
                }
                cs.addMessage(owner, (ModelMessage)new ModelMessage(ModelMessage.MessageType.UNIT_LOST, "model.colony.colonyStarved", this).addName("%colony%", this.getName()));
                owner.csDisposeSettlement(this, cs);
                return;
            }
            if (net >= 0 || (turns = stored / -net) > 3 || newUnitBorn) continue;
            cs.addMessage(owner, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.WARNING, "model.colony.famineFeared", this).addName("%colony%", this.getName())).addAmount("%number%", turns));
            lb.add(" famine in ", turns, " food=", stored, " production=", net);
        }
        this.invalidateCache();
        if (!built.isEmpty()) {
            for (BuildQueue buildQueue : built) {
                switch (buildQueue.getCompletionAction()) {
                    case SHUFFLE: {
                        if (buildQueue.size() <= 1) break;
                        RandomUtils.randomShuffle(logger, "Build queue", buildQueue.getValues(), random);
                        break;
                    }
                    case REMOVE_EXCEPT_LAST: {
                        if (buildQueue.size() == 1 && buildQueue.getCurrentlyBuilding() instanceof UnitType) break;
                    }
                    default: {
                        buildQueue.remove(0);
                    }
                }
                this.csNextBuildable(buildQueue, cs);
            }
            tileDirty = true;
        }
        if (this.hasAbility("model.ability.export")) {
            LogBuilder lb2 = new LogBuilder(64);
            lb2.add(" ");
            lb2.mark();
            for (Goods goods : this.getCompactGoodsList()) {
                int amount;
                GoodsType type = goods.getType();
                ExportData data = this.getExportData(type);
                if (!data.getExported() || !owner.canTrade(goods.getType(), Market.Access.CUSTOM_HOUSE) || (amount = goods.getAmount() - data.getExportLevel()) <= 0) continue;
                int oldGold = owner.getGold();
                int marketAmount = owner.sellInEurope(random, container, type, amount);
                if (marketAmount > 0) {
                    owner.addExtraTrade(new AbstractGoods(type, marketAmount));
                }
                Object st = ((StringTemplate)((StringTemplate)StringTemplate.template("model.colony.customs.saleData").addAmount("%amount%", amount)).addNamed("%goods%", type)).addAmount("%gold%", owner.getGold() - oldGold);
                lb2.add(Messages.message(st), ", ");
            }
            if (lb2.grew(new Object[0])) {
                lb2.shrink(", ");
                cs.addMessage(owner, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.GOODS_MOVEMENT, "model.colony.customs.sale", this).addName("%colony%", this.getName())).addName("%data%", lb2.toString()));
                cs.addPartial(ChangeSet.See.only(owner), owner, "gold", String.valueOf(owner.getGold()));
                lb.add(lb2.toString());
            }
        }
        for (BuildingType buildingType : CollectionUtils.transform(spec.getBuildingTypeList(), bt -> this.isAutomaticBuild((BuildingType)bt))) {
            this.buildBuilding(new ServerBuilding(this.getGame(), this, buildingType));
        }
        this.checkBuildQueueIntegrity(true, null);
        this.updateSoL();
        if (this.sonsOfLiberty / 10 != this.oldSonsOfLiberty / 10) {
            cs.addMessage(owner, (ModelMessage)((StringTemplate)((StringTemplate)new ModelMessage(ModelMessage.MessageType.SONS_OF_LIBERTY, this.sonsOfLiberty > this.oldSonsOfLiberty ? "model.colony.soLIncrease" : "model.colony.soLDecrease", this, spec.getGoodsType("model.goods.bells")).addAmount("%oldSoL%", this.oldSonsOfLiberty)).addAmount("%newSoL%", this.sonsOfLiberty)).addName("%colony%", this.getName()));
            ModelMessage govMgtMessage = this.checkForGovMgtChangeMessage();
            if (govMgtMessage != null) {
                cs.addMessage(owner, govMgtMessage);
            }
        }
        this.updateProductionBonus();
        for (WorkLocation workLocation : CollectionUtils.transform(this.getCurrentWorkLocations(), WorkLocation::canTeach)) {
            ServerBuilding building = (ServerBuilding)workLocation;
            for (Unit teacher : building.getUnitList()) {
                building.csCheckTeach(teacher, cs);
            }
        }
        if (tileDirty) {
            cs.add(ChangeSet.See.perhaps(), tile);
        } else {
            cs.add(ChangeSet.See.only(owner), this);
        }
        lb.add(", ");
    }
}

