/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.DecimalFormat;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.CollectionUtils;

public class ModifierFormat {
    private static final DecimalFormat modifierFormat = new DecimalFormat("0.00");

    public static final String getUnknownValue() {
        return Messages.message("modifierFormat.unknown");
    }

    public static final String format(float value) {
        return Modifier.isFloatKnown(value) ? modifierFormat.format(value) : ModifierFormat.getUnknownValue();
    }

    private static final String[] getModifierStrings(Modifier modifier) {
        return ModifierFormat.getModifierStrings(modifier.getValue(), modifier.getType());
    }

    private static final String[] getModifierStrings(float value, Modifier.ModifierType type) {
        String[] stringArray;
        String bonus = modifierFormat.format(value);
        if (!Modifier.isFloatKnown(value)) {
            return new String[]{" ", bonus, null};
        }
        if (value < 0.0f) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "-";
            stringArray2[1] = bonus.substring(1);
            stringArray = stringArray2;
            stringArray2[2] = null;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "+";
            stringArray3[1] = bonus;
            stringArray = stringArray3;
            stringArray3[2] = null;
        }
        String[] result = stringArray;
        switch (type) {
            case MULTIPLICATIVE: {
                result[0] = "\u00d7";
                break;
            }
            case PERCENTAGE: {
                result[2] = "%";
                break;
            }
        }
        return result;
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    private static String getSourceName(FreeColObject source) {
        if (source == null) {
            return ModifierFormat.getUnknownValue();
        }
        String result = null;
        if (result == null && source instanceof Nameable && (result = ((Nameable)((Object)source)).getName()) != null && result.isEmpty()) {
            result = null;
        }
        if (result == null && source instanceof Named && (result = Messages.getName((Named)((Object)source))).isEmpty()) {
            result = null;
        }
        if (result == null) {
            result = Messages.getName(source.getId());
        }
        return result;
    }

    public static JLabel[] getModifierLabels(Modifier modifier, FreeColSpecObjectType fcgot, Turn turn) {
        Object sourceName = ModifierFormat.getSourceName(modifier.getSource());
        if (fcgot != null && modifier.appliesTo(fcgot)) {
            sourceName = (String)sourceName + " (" + Messages.getName(fcgot) + ")";
        }
        float value = modifier.getValue(turn);
        String[] bonus = ModifierFormat.getModifierStrings(value, modifier.getType());
        JLabel[] result = new JLabel[]{new JLabel((String)sourceName), new JLabel(bonus[0] + bonus[1]), bonus[2] == null ? null : new JLabel(bonus[2])};
        return result;
    }

    public static String getFeatureAsString(Feature feature) {
        return Messages.getName(feature) + ":" + (!feature.hasScope() ? "" : CollectionUtils.transform(feature.getScopes(), CollectionUtils.isNotNull(), Scope::getFeatureString, Collectors.joining(",")));
    }

    public static String getModifierAsString(Modifier modifier) {
        return CollectionUtils.transform(ModifierFormat.getModifierStrings(modifier), CollectionUtils.isNotNull(), Function.identity(), Collectors.joining());
    }
}

