/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class NiotProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_RESPONSE = 33;
    public static final int MSG_POSITION_DATA = 128;

    public NiotProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int type, int checksum) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeShort(22616);
            response.writeByte(33);
            response.writeShort(5);
            response.writeByte(checksum);
            response.writeByte(type);
            response.writeByte(0);
            response.writeByte(Checksum.xor(response.nioBuffer(2, response.writerIndex())));
            response.writeByte(13);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private double readCoordinate(ByteBuf buf) {
        long value = buf.readUnsignedInt();
        double result = (double)BitUtil.to(value, 31) / 1800000.0;
        return BitUtil.check(value, 31) ? -result : result;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        short type = buf.readUnsignedByte();
        buf.readUnsignedShort();
        String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
        this.sendResponse(channel, remoteAddress, type, buf.getByte(buf.writerIndex() - 2));
        if (type == 128) {
            Position position = new Position(this.getProtocolName());
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
            if (deviceSession == null) {
                return null;
            }
            position.setDeviceId(deviceSession.getDeviceId());
            DateBuilder dateBuilder = new DateBuilder().setYear(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2));
            position.setTime(dateBuilder.getDate());
            position.setValid(true);
            position.setLatitude(this.readCoordinate(buf));
            position.setLongitude(this.readCoordinate(buf));
            position.setSpeed(UnitsConverter.knotsFromKph(BcdUtil.readInteger(buf, 4)));
            position.setCourse(BcdUtil.readInteger(buf, 4));
            return position;
        }
        return null;
    }
}

