/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.commons.util;

import com.cloudhopper.commons.util.URL;
import com.cloudhopper.commons.util.codec.URLCodec;
import java.io.IOException;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLParser {
    private static final Logger logger = LoggerFactory.getLogger(URLParser.class);

    private URLParser() {
    }

    private static String decode(String str0) throws MalformedURLException {
        StringBuilder buf = new StringBuilder(str0.length());
        try {
            URLCodec.decode((CharSequence)str0, buf);
        }
        catch (IOException e) {
            throw new MalformedURLException("Invalid URL: failed while URL decoding '" + str0 + "'");
        }
        return buf.toString();
    }

    public static URL parse(String url) throws MalformedURLException {
        String query;
        String hostPort;
        int pos = 0;
        int i = url.indexOf("://");
        if (i < 0) {
            throw new MalformedURLException("Invalid URL [" + url + "]: no protocol specified");
        }
        URL r = new URL();
        String protocol = url.substring(0, i);
        r.setProtocol(protocol);
        pos = i + 3;
        i = url.indexOf(64, pos);
        if (i >= 0) {
            String userPass = url.substring(pos, i);
            int atPos = userPass.indexOf(58);
            if (atPos >= 0) {
                String username = userPass.substring(0, atPos);
                String password = userPass.substring(atPos + 1);
                if (username != null && username.length() > 0) {
                    r.setUsername(URLParser.decode(username));
                }
                if (password != null && password.length() > 0) {
                    r.setPassword(URLParser.decode(password));
                }
            } else if (userPass.length() > 0) {
                r.setUsername(URLParser.decode(userPass));
            }
            pos = i + 1;
        }
        if ((i = url.indexOf(47, pos)) < 0 && (i = url.indexOf(63, pos)) < 0) {
            i = url.length();
        }
        if ((hostPort = url.substring(pos, i)) != null && hostPort.length() > 0) {
            int colPos = hostPort.indexOf(58);
            if (colPos >= 0) {
                String host = hostPort.substring(0, colPos);
                r.setHost(host);
                String tempPort = hostPort.substring(colPos + 1);
                try {
                    Integer port = Integer.valueOf(tempPort);
                    r.setPort(port);
                }
                catch (NumberFormatException e) {
                    throw new MalformedURLException("Invalid URL [" + url + "]: port '" + tempPort + "' was not an integer");
                }
            } else {
                r.setHost(hostPort);
            }
        }
        if ((pos = i) >= url.length()) {
            return r;
        }
        if (url.charAt(pos) == '/') {
            i = url.indexOf(63);
            if (i < 0) {
                i = url.length();
            }
            String path = url.substring(pos, i);
            r.setPath(URLParser.decode(path));
        }
        if ((pos = i) >= url.length()) {
            return r;
        }
        if (url.charAt(pos) == '?' && (query = url.substring(pos + 1)) != null && query.length() > 0) {
            r.setQuery(query);
        }
        return r;
    }
}

