/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.carrot2.util.StreamUtils;
import org.carrot2.util.resource.IResource;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;

@Root(name="class-loader-resource")
public final class ClassLoaderResource
implements IResource {
    private ClassLoader clazzLoader;
    @Attribute
    private String resource;

    ClassLoaderResource() {
        this(null);
    }

    public ClassLoaderResource(String resource) {
        this(Thread.currentThread().getContextClassLoader(), resource);
    }

    public ClassLoaderResource(ClassLoader cl, String resource) {
        this.clazzLoader = cl;
        this.resource = resource;
    }

    @Override
    public InputStream open() throws IOException {
        InputStream resourceAsStream = this.clazzLoader.getResourceAsStream(this.resource);
        if (resourceAsStream == null) {
            throw new IOException("Resource not found: " + this.toString());
        }
        return StreamUtils.prefetch(resourceAsStream);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassLoaderResource) {
            return Objects.equals(((ClassLoaderResource)obj).resource, this.resource) && Objects.equals(((ClassLoaderResource)obj).clazzLoader, this.clazzLoader);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.clazzLoader) ^ Objects.hashCode(this.resource);
    }

    public String toString() {
        return "[CLASSPATH RESOURCE: " + this.resource + "@" + this.clazzLoader.toString() + "]";
    }

    public static ClassLoaderResource valueOf(String name) {
        try {
            ClassLoaderResource res = new ClassLoaderResource(name);
            res.open().close();
            return res;
        }
        catch (IOException e) {
            return null;
        }
    }
}

