/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.factory;

import org.carrot2.shaded.guava.common.base.Predicate;
import org.carrot2.shaded.guava.common.base.Throwables;
import org.carrot2.util.factory.IFactory;
import org.slf4j.Logger;

public final class FallbackFactory<T>
implements IFactory<T> {
    private final IFactory<T> defaultFactory;
    private final IFactory<T> fallbackFactory;
    private final String failureMessage;
    private final Logger logger;
    private final Predicate<T> verifier;

    public FallbackFactory(IFactory<T> defaultFactory, IFactory<T> fallbackFactory, Predicate<T> verifier, Logger logger, String failureMessage) {
        this.defaultFactory = defaultFactory;
        this.fallbackFactory = fallbackFactory;
        this.failureMessage = failureMessage;
        this.logger = logger;
        this.verifier = verifier;
    }

    @Override
    public final T createInstance() {
        try {
            T instance = this.defaultFactory.createInstance();
            if (this.verifier.apply(instance)) {
                return instance;
            }
            this.logger.warn(this.failureMessage, (Object)"(false from predicate)");
            return this.fallbackFactory.createInstance();
        }
        catch (Throwable t) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn(this.failureMessage, (Object)(t.toString() + "\n" + Throwables.getStackTraceAsString((Throwable)t)));
            } else {
                this.logger.warn(this.failureMessage, (Object)t.toString());
            }
            return this.fallbackFactory.createInstance();
        }
    }
}

