/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.solr.cloud.CloudConfigSetService;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkSolrResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.ConfigSet;
import org.apache.solr.core.ConfigSetProperties;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.IndexSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigSetService {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SolrResourceLoader parentLoader;
    private final Cache<String, IndexSchema> schemaCache;

    public static ConfigSetService createConfigSetService(NodeConfig nodeConfig, SolrResourceLoader loader, ZkController zkController) {
        if (zkController == null) {
            return new Standalone(loader, nodeConfig.hasSchemaCache(), nodeConfig.getConfigSetBaseDirectory());
        }
        return new CloudConfigSetService(loader, nodeConfig.hasSchemaCache(), zkController);
    }

    public final ConfigSet loadConfigSet(CoreDescriptor dcore) {
        SolrResourceLoader coreLoader = this.createCoreResourceLoader(dcore);
        try {
            NamedList properties = this.loadConfigSetProperties(dcore, coreLoader);
            NamedList flags = this.loadConfigSetFlags(dcore, coreLoader);
            boolean trusted = !(coreLoader instanceof ZkSolrResourceLoader) || flags == null || flags.get("trusted") == null || flags.getBooleanArg("trusted") != false;
            SolrConfig solrConfig = this.createSolrConfig(dcore, coreLoader, trusted);
            IndexSchema schema = this.createIndexSchema(dcore, solrConfig);
            return new ConfigSet(this.configSetName(dcore), solrConfig, schema, properties, trusted);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load conf for core " + dcore.getName() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public ConfigSetService(SolrResourceLoader loader, boolean shareSchema) {
        this.parentLoader = loader;
        this.schemaCache = shareSchema ? Caffeine.newBuilder().weakValues().build() : null;
    }

    protected SolrConfig createSolrConfig(CoreDescriptor cd, SolrResourceLoader loader, boolean isTrusted) {
        return SolrConfig.readFromResourceLoader(loader, cd.getConfigName(), isTrusted, cd.getSubstitutableProperties());
    }

    protected IndexSchema createIndexSchema(CoreDescriptor cd, SolrConfig solrConfig) {
        String cdSchemaName = cd.getSchemaName();
        IndexSchemaFactory indexSchemaFactory = IndexSchemaFactory.newIndexSchemaFactory(solrConfig);
        String configSet = cd.getConfigSet();
        if (configSet != null && this.schemaCache != null) {
            String guessSchemaName = indexSchemaFactory.getSchemaResourceName(cdSchemaName);
            Long modVersion = this.getCurrentSchemaModificationVersion(configSet, solrConfig, guessSchemaName);
            if (modVersion != null) {
                String cacheKey = configSet + "/" + guessSchemaName + "/" + modVersion + "/" + solrConfig.luceneMatchVersion;
                return (IndexSchema)this.schemaCache.get((Object)cacheKey, key -> indexSchemaFactory.create(cdSchemaName, solrConfig));
            }
            log.warn("Unable to get schema modification version, configSet={} schema={}", (Object)configSet, (Object)guessSchemaName);
        }
        return indexSchemaFactory.create(cdSchemaName, solrConfig);
    }

    protected abstract Long getCurrentSchemaModificationVersion(String var1, SolrConfig var2, String var3);

    protected NamedList loadConfigSetProperties(CoreDescriptor cd, SolrResourceLoader loader) {
        return ConfigSetProperties.readFromResourceLoader(loader, cd.getConfigSetPropertiesName());
    }

    protected NamedList loadConfigSetFlags(CoreDescriptor cd, SolrResourceLoader loader) {
        return null;
    }

    protected abstract SolrResourceLoader createCoreResourceLoader(CoreDescriptor var1);

    public abstract String configSetName(CoreDescriptor var1);

    public static class Standalone
    extends ConfigSetService {
        private final Path configSetBase;

        public Standalone(SolrResourceLoader loader, boolean shareSchema, Path configSetBase) {
            super(loader, shareSchema);
            this.configSetBase = configSetBase;
        }

        @Override
        public SolrResourceLoader createCoreResourceLoader(CoreDescriptor cd) {
            Path instanceDir = this.locateInstanceDir(cd);
            return new SolrResourceLoader(instanceDir, this.parentLoader.getClassLoader(), cd.getSubstitutableProperties());
        }

        @Override
        public String configSetName(CoreDescriptor cd) {
            return (cd.getConfigSet() == null ? "instancedir " : "configset ") + this.locateInstanceDir(cd);
        }

        protected Path locateInstanceDir(CoreDescriptor cd) {
            String configSet = cd.getConfigSet();
            if (configSet == null) {
                return cd.getInstanceDir();
            }
            Path configSetDirectory = this.configSetBase.resolve(configSet);
            if (!Files.isDirectory(configSetDirectory, new LinkOption[0])) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load configuration from directory " + configSetDirectory);
            }
            return configSetDirectory;
        }

        @Override
        protected Long getCurrentSchemaModificationVersion(String configSet, SolrConfig solrConfig, String schemaFileName) {
            Path schemaFile = Paths.get(solrConfig.getResourceLoader().getConfigDir(), new String[0]).resolve(schemaFileName);
            try {
                return Files.getLastModifiedTime(schemaFile, new LinkOption[0]).toMillis();
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                log.warn("Unexpected exception when getting modification time of {}", (Object)schemaFile, (Object)e);
                return null;
            }
        }
    }
}

