/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.Date;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.constant.ConstantStringValue;
import org.apache.solr.common.SolrException;
import org.apache.solr.util.DateMathParser;

class DateMathStreamFunction
extends DateValueStream.AbstractDateValueStream {
    private final DateValueStream dateParam;
    private final String mathParam;
    public static final String name = "date_math";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public DateMathStreamFunction(DateValueStream dateParam, ConstantStringValue mathParam) throws SolrException {
        this.dateParam = dateParam;
        this.mathParam = "NOW" + mathParam.getString();
        this.exprStr = AnalyticsValueStream.createExpressionString(name, dateParam, mathParam);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, dateParam);
    }

    @Override
    public void streamLongs(LongConsumer cons) {
        this.streamDates(value -> cons.accept(value.getTime()));
    }

    @Override
    public void streamDates(Consumer<Date> cons) {
        this.dateParam.streamDates(value -> cons.accept(DateMathParser.parseMath((Date)value, (String)this.mathParam)));
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

