/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.data.GHPRMergeabilityState;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRStatusChecksComponent$WhenMappings;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRStatusChecksComponent;", "", "()V", "create", "Ljavax/swing/JComponent;", "mergeability", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "createLink", "Lcom/intellij/ui/HyperlinkLabel;", "url", "", "getChecksResultsText", "failedChecks", "", "pendingChecks", "successfulChecks", "intellij.vcs.github"})
public final class GHPRStatusChecksComponent {
    public static final GHPRStatusChecksComponent INSTANCE;

    @NotNull
    public final JComponent create(@NotNull GHPRMergeabilityState mergeability) {
        Intrinsics.checkParameterIsNotNull((Object)mergeability, (String)"mergeability");
        JPanel panel2 = new JPanel(new FlowLayout(3, 0, 0));
        GHPRMergeabilityState.ChecksState checksState = mergeability.getChecksState();
        if (checksState == GHPRMergeabilityState.ChecksState.NONE) {
            panel2.setVisible(false);
        } else {
            String string;
            Icon icon;
            JLabel jLabel = new JLabel();
            boolean bl = false;
            boolean bl2 = false;
            JLabel $this$apply = jLabel;
            boolean bl3 = false;
            switch (GHPRStatusChecksComponent$WhenMappings.$EnumSwitchMapping$0[checksState.ordinal()]) {
                case 1: 
                case 2: {
                    icon = AllIcons.RunConfigurations.TestError;
                    break;
                }
                case 3: {
                    icon = AllIcons.RunConfigurations.TestFailed;
                    break;
                }
                case 4: {
                    icon = AllIcons.RunConfigurations.TestNotRan;
                    break;
                }
                case 5: {
                    icon = AllIcons.RunConfigurations.TestPassed;
                    break;
                }
                default: {
                    icon = EmptyIcon.ICON_16;
                }
            }
            $this$apply.setIcon(icon);
            switch (GHPRStatusChecksComponent$WhenMappings.$EnumSwitchMapping$1[checksState.ordinal()]) {
                case 1: {
                    string = GithubBundle.message("pull.request.branch.out.of.sync", new Object[0]);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = INSTANCE.getChecksResultsText(mergeability.getFailedChecks(), mergeability.getPendingChecks(), mergeability.getSuccessfulChecks());
                    break;
                }
                default: {
                    string = "";
                }
            }
            $this$apply.setText(string);
            JLabel label = jLabel;
            boolean bl4 = false;
            bl = false;
            JPanel $this$with = panel2;
            boolean bl5 = false;
            $this$with.add(label);
            $this$with.add((Component)INSTANCE.createLink(mergeability.getHtmlUrl()));
        }
        return panel2;
    }

    private final String getChecksResultsText(int failedChecks, int pendingChecks, int successfulChecks) {
        boolean bl = false;
        List results = new ArrayList();
        Object object = failedChecks;
        boolean bl2 = false;
        boolean bl3 = false;
        int it = ((Number)object).intValue();
        boolean bl4 = false;
        Object object2 = it > 0 ? object : null;
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl3 = false;
            it = ((Number)object).intValue();
            boolean bl5 = false;
            object2 = GithubBundle.message("pull.request.checks.failing", it);
            if (object2 != null) {
                object = object2;
                bl2 = false;
                bl3 = false;
                Object it2 = object;
                boolean bl6 = false;
                Object object3 = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
                results.add(object3);
            }
        }
        object = pendingChecks;
        bl2 = false;
        bl3 = false;
        int it3 = ((Number)object).intValue();
        boolean bl7 = false;
        Object object4 = it3 > 0 ? object : null;
        if (object4 != null) {
            object = object4;
            bl2 = false;
            bl3 = false;
            it3 = ((Number)object).intValue();
            boolean bl8 = false;
            object4 = GithubBundle.message("pull.request.checks.pending", it3);
            if (object4 != null) {
                object = object4;
                bl2 = false;
                bl3 = false;
                Object it4 = object;
                boolean bl9 = false;
                Object object5 = it4;
                Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"it");
                results.add(object5);
            }
        }
        object = successfulChecks;
        bl2 = false;
        bl3 = false;
        int it5 = ((Number)object).intValue();
        boolean bl10 = false;
        Object object6 = it5 > 0 ? object : null;
        if (object6 != null) {
            object = object6;
            bl2 = false;
            bl3 = false;
            it5 = ((Number)object).intValue();
            boolean bl11 = false;
            object6 = GithubBundle.message("pull.request.checks.successful", it5);
            if (object6 != null) {
                object = object6;
                bl2 = false;
                bl3 = false;
                Object it6 = object;
                boolean bl12 = false;
                Object object7 = it6;
                Intrinsics.checkExpressionValueIsNotNull((Object)object7, (String)"it");
                results.add(object7);
            }
        }
        int checksCount = failedChecks + pendingChecks + successfulChecks;
        return StringUtil.join((Collection)results, (String)", ") + " " + GithubBundle.message("pull.request.checks", checksCount);
    }

    private final HyperlinkLabel createLink(String url) {
        HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(GithubBundle.message("open.in.browser.link", new Object[0]));
        boolean bl = false;
        boolean bl2 = false;
        HyperlinkLabel $this$apply = hyperlinkLabel;
        boolean bl3 = false;
        $this$apply.setHyperlinkTarget(url);
        return hyperlinkLabel;
    }

    private GHPRStatusChecksComponent() {
    }

    static {
        GHPRStatusChecksComponent gHPRStatusChecksComponent;
        INSTANCE = gHPRStatusChecksComponent = new GHPRStatusChecksComponent();
    }
}

