/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.functionTypeComments;

import com.intellij.lang.SyntaxTreeBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.functionTypeComments.PyFunctionTypeAnnotationElementTypes;
import com.jetbrains.python.documentation.doctest.PyDocstringTokenTypes;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.PyParser;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.LanguageLevel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFunctionTypeAnnotationParser
extends PyParser {
    @Override
    protected ParsingContext createParsingContext(SyntaxTreeBuilder builder, LanguageLevel languageLevel, final StatementParsing.FUTURE futureFlag) {
        return new ParsingContext(builder, languageLevel, futureFlag){
            private final StatementParsing myStatementParsing;
            private final ExpressionParsing myExpressionParsing;
            {
                super(builder, languageLevel, futureFlag2);
                this.myStatementParsing = new AnnotationParser(this, futureFlag);
                this.myExpressionParsing = new ExpressionParsing(this){

                    @Override
                    protected IElementType getReferenceType() {
                        return PyDocstringTokenTypes.DOC_REFERENCE;
                    }
                };
            }

            @Override
            public StatementParsing getStatementParser() {
                return this.myStatementParsing;
            }

            @Override
            public ExpressionParsing getExpressionParser() {
                return this.myExpressionParsing;
            }
        };
    }

    private static class AnnotationParser
    extends StatementParsing {
        AnnotationParser(ParsingContext context, @Nullable StatementParsing.FUTURE futureFlag) {
            super(context, futureFlag);
        }

        @Override
        public void parseStatement() {
            if (this.myBuilder.eof()) {
                return;
            }
            this.parseFunctionType();
        }

        private void parseFunctionType() {
            if (this.atToken(PyTokenTypes.LPAR)) {
                SyntaxTreeBuilder.Marker funcTypeMark = this.myBuilder.mark();
                this.parseParameterTypeList();
                this.checkMatches(PyTokenTypes.RARROW, PyPsiBundle.message("rarrow.expected", new Object[0]));
                boolean parsed = this.getExpressionParser().parseSingleExpression(false);
                if (!parsed) {
                    this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
                }
                funcTypeMark.done((IElementType)PyFunctionTypeAnnotationElementTypes.FUNCTION_SIGNATURE);
            }
            this.recoverUntilMatches(PyPsiBundle.message("unexpected.tokens", new Object[0]), new IElementType[0]);
        }

        private void parseParameterTypeList() {
            assert (this.atToken(PyTokenTypes.LPAR));
            SyntaxTreeBuilder.Marker listMark = this.myBuilder.mark();
            this.myBuilder.advanceLexer();
            ExpressionParsing exprParser = this.getExpressionParser();
            int paramCount = 0;
            while (!this.atAnyOfTokens(PyTokenTypes.RPAR, PyTokenTypes.RARROW, PyTokenTypes.STATEMENT_BREAK) && !this.myBuilder.eof()) {
                boolean parsed;
                if (paramCount > 0) {
                    this.checkMatches(PyTokenTypes.COMMA, PyPsiBundle.message("PARSE.expected.comma", new Object[0]));
                }
                if (this.atToken(PyTokenTypes.MULT)) {
                    SyntaxTreeBuilder.Marker starMarker = this.myBuilder.mark();
                    this.myBuilder.advanceLexer();
                    parsed = exprParser.parseSingleExpression(false);
                    starMarker.done((IElementType)PyElementTypes.STAR_EXPRESSION);
                } else if (this.atToken(PyTokenTypes.EXP)) {
                    SyntaxTreeBuilder.Marker doubleStarMarker = this.myBuilder.mark();
                    this.myBuilder.advanceLexer();
                    parsed = exprParser.parseSingleExpression(false);
                    doubleStarMarker.done((IElementType)PyElementTypes.DOUBLE_STAR_EXPRESSION);
                } else {
                    parsed = exprParser.parseSingleExpression(false);
                }
                if (!parsed) {
                    this.myBuilder.error(PyPsiBundle.message("PARSE.expected.expression", new Object[0]));
                    this.recoverUntilMatches(PyPsiBundle.message("PARSE.expected.expression", new Object[0]), PyTokenTypes.COMMA, PyTokenTypes.RPAR, PyTokenTypes.RARROW, PyTokenTypes.STATEMENT_BREAK);
                }
                ++paramCount;
            }
            this.checkMatches(PyTokenTypes.RPAR, PyPsiBundle.message("PARSE.expected.rpar", new Object[0]));
            listMark.done((IElementType)PyFunctionTypeAnnotationElementTypes.PARAMETER_TYPE_LIST);
        }

        private void recoverUntilMatches(@NotNull @Nls String errorMessage, IElementType ... types) {
            if (errorMessage == null) {
                AnnotationParser.$$$reportNull$$$0(0);
            }
            if (types == null) {
                AnnotationParser.$$$reportNull$$$0(1);
            }
            SyntaxTreeBuilder.Marker errorMarker = this.myBuilder.mark();
            boolean hasNonWhitespaceTokens = false;
            while (!this.atAnyOfTokens(types) && !this.myBuilder.eof()) {
                if (!this.atToken(PyTokenTypes.STATEMENT_BREAK)) {
                    hasNonWhitespaceTokens = true;
                }
                this.myBuilder.advanceLexer();
            }
            if (hasNonWhitespaceTokens) {
                errorMarker.error(errorMessage);
            } else {
                errorMarker.drop();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "errorMessage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "types";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/codeInsight/functionTypeComments/PyFunctionTypeAnnotationParser$AnnotationParser";
            objectArray[2] = "recoverUntilMatches";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

