/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.editor;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoIndexPatternProvider;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.TodoCacheManager;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoAttributes;
import com.intellij.psi.search.TodoPattern;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.ArrayUtilRt;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class TodoItemsTestCase
extends LightPlatformCodeInsightTestCase {
    protected abstract String getFileExtension();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWithPattern(@NotNull String pattern, @NotNull Runnable runnable) {
        if (pattern == null) {
            TodoItemsTestCase.$$$reportNull$$$0(0);
        }
        if (runnable == null) {
            TodoItemsTestCase.$$$reportNull$$$0(1);
        }
        TodoConfiguration todoConfiguration = TodoConfiguration.getInstance();
        TodoPattern[] originalPatterns = todoConfiguration.getTodoPatterns();
        try {
            TodoPattern todoPattern = new TodoPattern(pattern, new TodoAttributes(new TextAttributes()), false);
            todoConfiguration.setTodoPatterns(new TodoPattern[]{todoPattern});
            runnable.run();
        }
        finally {
            todoConfiguration.setTodoPatterns(originalPatterns);
        }
    }

    @NotNull
    protected List<HighlightInfo> doHighlighting() {
        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        TIntArrayList toIgnoreList = new TIntArrayList();
        toIgnoreList.add(1);
        toIgnoreList.add(7);
        toIgnoreList.add(12);
        int[] toIgnore = toIgnoreList.isEmpty() ? ArrayUtilRt.EMPTY_INT_ARRAY : toIgnoreList.toNativeArray();
        Editor editor = this.getEditor();
        PsiFile file2 = this.getFile();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
        }
        List<HighlightInfo> list = CodeInsightTestFixtureImpl.instantiateAndRun(file2, editor, toIgnore, false);
        if (list == null) {
            TodoItemsTestCase.$$$reportNull$$$0(2);
        }
        return list;
    }

    protected void testTodos(String text) {
        this.configureFromFileText("Foo." + this.getFileExtension(), text);
        EditorTestUtil.setEditorVisibleSize(this.getEditor(), 1000, 1000);
        List<TextRange> expectedTodoRanges = this.extractExpectedTodoRanges(this.getEditor().getDocument());
        List<HighlightInfo> highlightInfos = this.doHighlighting();
        List<TextRange> actualTodoRanges = TodoItemsTestCase.getActualTodoRanges(highlightInfos);
        this.assertTodoRanges(expectedTodoRanges, actualTodoRanges);
        this.assertSameTodoCountInIndexAndHighlighting();
    }

    private void assertSameTodoCountInIndexAndHighlighting() {
        int todosInIndex = TodoCacheManager.SERVICE.getInstance((Project)this.getProject()).getTodoCount(this.getVFile(), (IndexPatternProvider)TodoIndexPatternProvider.getInstance());
        int todosInHighlighting = PsiTodoSearchHelper.SERVICE.getInstance((Project)this.getProject()).findTodoItems(this.getFile()).length;
        TodoItemsTestCase.assertEquals((String)"Mismatch between todos in index and highlighting", (int)todosInIndex, (int)todosInHighlighting);
    }

    protected void checkTodos(String text) {
        DocumentImpl document = new DocumentImpl(text);
        List<TextRange> expectedTodoRanges = this.extractExpectedTodoRanges((Document)document);
        List<HighlightInfo> highlightInfos = this.doHighlighting();
        this.checkResultByText(document.getText());
        List<TextRange> actualTodoRanges = TodoItemsTestCase.getActualTodoRanges(highlightInfos);
        this.assertTodoRanges(expectedTodoRanges, actualTodoRanges);
    }

    private List<TextRange> extractExpectedTodoRanges(Document document) {
        int startPos;
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        int offset = 0;
        while ((startPos = document.getText().indexOf(91, offset)) != -1) {
            int finalStartPos = startPos;
            WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> document.deleteString(finalStartPos, finalStartPos + 1));
            int endPos = document.getText().indexOf(93, startPos);
            if (endPos == -1) break;
            WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> document.deleteString(endPos, endPos + 1));
            result.add(new TextRange(startPos, endPos));
        }
        return result;
    }

    private static List<TextRange> getActualTodoRanges(List<? extends HighlightInfo> highlightInfos) {
        return highlightInfos.stream().filter(info -> info.type == HighlightInfoType.TODO).map(info -> TextRange.create((Segment)info.getHighlighter())).sorted(Segment.BY_START_OFFSET_THEN_END_OFFSET).collect(Collectors.toList());
    }

    private void assertTodoRanges(List<? extends TextRange> expectedTodoRanges, List<? extends TextRange> actualTodoRanges) {
        TodoItemsTestCase.assertEquals((String)"Unexpected todos highlighting", (String)this.generatePresentation(expectedTodoRanges), (String)this.generatePresentation(actualTodoRanges));
    }

    private String generatePresentation(List<? extends TextRange> ranges) {
        StringBuilder b = new StringBuilder(this.getEditor().getDocument().getText());
        int prevStart = Integer.MAX_VALUE;
        for (int i = ranges.size() - 1; i >= 0; --i) {
            TextRange r = ranges.get(i);
            TodoItemsTestCase.assertTrue((r.getEndOffset() <= prevStart ? 1 : 0) != 0);
            b.insert(r.getEndOffset(), ']');
            prevStart = r.getStartOffset();
            b.insert(prevStart, '[');
        }
        return b.toString();
    }

    protected abstract boolean supportsCStyleSingleLineComments();

    protected abstract boolean supportsCStyleMultiLineComments();

    public void testSuccessiveLineComments() {
        if (!this.supportsCStyleSingleLineComments()) {
            return;
        }
        this.testTodos("// [TODO first line]\n//      [second line]");
    }

    public void testSuccessiveLineCommentsAfterEditing() {
        if (!this.supportsCStyleSingleLineComments()) {
            return;
        }
        this.testTodos("// [TODO first line]\n// <caret>second line");
        this.type("     ");
        this.checkTodos("// [TODO first line]\n//      [second line]");
    }

    public void testAllLinesLoseHighlightingWithFirstLine() {
        if (!this.supportsCStyleSingleLineComments()) {
            return;
        }
        this.testTodos("// [TO<caret>DO first line]\n//      [second line]");
        this.delete();
        this.checkTodos("// TOO first line\n//      second line");
    }

    public void testContinuationIsNotOverlappedWithFollowingTodo() {
        if (!this.supportsCStyleSingleLineComments()) {
            return;
        }
        this.testTodos("// [TODO first line]\n//  [TODO second line]");
    }

    public void testContinuationInBlockCommentWithStars() {
        if (!this.supportsCStyleMultiLineComments()) {
            return;
        }
        this.testTodos("/*\n * [TODO first line]\n *  [second line]\n */");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/editor/TodoItemsTestCase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/editor/TodoItemsTestCase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doHighlighting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doWithPattern";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

