/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceBackwardHandler;
import com.intellij.slicer.SliceForwardHandler;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SliceHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(SliceHandler.class);
    final boolean myDataFlowToThis;

    SliceHandler(boolean dataFlowToThis) {
        this.myDataFlowToThis = dataFlowToThis;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement expression;
        if (project == null) {
            SliceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SliceHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            SliceHandler.$$$reportNull$$$0(2);
        }
        if ((expression = this.getExpressionAtCaret(editor, file2)) == null) {
            HintManager.getInstance().showErrorHint(editor, LangBundle.message((String)"hint.text.cannot.find.what.to.analyze", (Object[])new Object[0]));
            return;
        }
        if (!expression.isPhysical()) {
            PsiFile expressionFile = expression.getContainingFile();
            LOG.error("Analyzed entity should be physical. Analyzed element: " + expression.getText() + " (class = " + expression.getClass() + "), file = " + file2 + " expression file = " + expressionFile + " (class = " + expressionFile.getClass() + ")");
        }
        SliceManager sliceManager = SliceManager.getInstance(project);
        sliceManager.slice(expression, this.myDataFlowToThis, this);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getExpressionAtCaret(Editor editor, PsiFile file2) {
        int offset = TargetElementUtil.adjustOffset(file2, editor.getDocument(), editor.getCaretModel().getOffset());
        if (offset == 0) {
            return null;
        }
        PsiElement atCaret = file2.findElementAt(offset);
        SliceLanguageSupportProvider provider = LanguageSlicing.getProvider((PsiElement)file2);
        if (provider == null || atCaret == null) {
            return null;
        }
        return provider.getExpressionAtCaret(atCaret, this.myDataFlowToThis);
    }

    public abstract SliceAnalysisParams askForParams(PsiElement var1, SliceManager.StoredSettingsBean var2, String var3);

    public static SliceHandler create(boolean dataFlowToThis) {
        return dataFlowToThis ? new SliceBackwardHandler() : new SliceForwardHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/slicer/SliceHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

