/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewFolderAction
extends FileChooserAction
implements LightEditCompatible {
    public NewFolderAction() {
    }

    public NewFolderAction(String text, String description, Icon icon2) {
        this(() -> text, () -> description, icon2);
    }

    public NewFolderAction(@NotNull Supplier<String> text, @NotNull Supplier<String> description, Icon icon2) {
        if (text == null) {
            NewFolderAction.$$$reportNull$$$0(0);
        }
        if (description == null) {
            NewFolderAction.$$$reportNull$$$0(1);
        }
        super(text, description, icon2);
    }

    @Override
    protected void update(FileSystemTree fileSystemTree, AnActionEvent e) {
        Presentation presentation2 = e.getPresentation();
        VirtualFile parent = fileSystemTree.getNewFileParent();
        presentation2.setEnabled(parent != null && parent.isDirectory());
        this.setEnabledInModalContext(true);
    }

    @Override
    protected void actionPerformed(FileSystemTree fileSystemTree, AnActionEvent e) {
        NewFolderAction.createNewFolder(fileSystemTree);
    }

    private static void createNewFolder(FileSystemTree fileSystemTree) {
        VirtualFile file2 = fileSystemTree.getNewFileParent();
        if (file2 == null || !file2.isDirectory()) {
            return;
        }
        NewFolderValidator validator = new NewFolderValidator(file2);
        String newFolderName = Messages.showInputDialog((String)UIBundle.message((String)"create.new.folder.enter.new.folder.name.prompt.text", (Object[])new Object[0]), (String)UIBundle.message((String)"new.folder.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
        if (newFolderName == null) {
            return;
        }
        Exception failReason = ((FileSystemTreeImpl)fileSystemTree).createNewFolder(file2, newFolderName);
        if (failReason != null) {
            Messages.showMessageDialog((String)UIBundle.message((String)"create.new.folder.could.not.create.folder.error.message", (Object[])new Object[]{newFolderName}), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "description";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/fileChooser/actions/NewFolderAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NewFolderValidator
    implements InputValidatorEx {
        private final VirtualFile myDirectory;
        private String myErrorText;

        NewFolderValidator(VirtualFile directory) {
            this.myDirectory = directory;
        }

        @Nullable
        public String getErrorText(String inputString) {
            return this.myErrorText;
        }

        public boolean checkInput(String inputString) {
            boolean firstToken = true;
            for (String token : StringUtil.tokenize((String)inputString, (String)"\\/")) {
                VirtualFile child2;
                if (firstToken && (child2 = this.myDirectory.findChild(token)) != null) {
                    this.myErrorText = "A " + (child2.isDirectory() ? "folder" : "file") + " with name '" + token + "' already exists";
                    return false;
                }
                firstToken = false;
                if (token.equals(".") || token.equals("..")) {
                    this.myErrorText = "Can't create a folder with name '" + token + "'";
                    return false;
                }
                if (!FileTypeManager.getInstance().isFileIgnored(token)) continue;
                this.myErrorText = "Trying to create a folder with an ignored name, the result will not be visible";
                return true;
            }
            this.myErrorText = null;
            return !inputString.isEmpty();
        }

        public boolean canClose(String inputString) {
            return true;
        }
    }
}

