/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.RunConfigurationExtensionBase;
import com.intellij.execution.configuration.RunConfigurationExtensionsManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.FragmentedSettingsEditor;
import com.intellij.execution.ui.RunConfigurationEditorFragment;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public abstract class RunConfigurationFragmentedEditor<Settings extends RunConfigurationBase<?>>
extends FragmentedSettingsEditor<Settings> {
    private static final Logger LOG = Logger.getInstance(RunConfigurationFragmentedEditor.class);
    private final Settings myRunConfiguration;
    private final RunConfigurationExtensionsManager<RunConfigurationBase<?>, RunConfigurationExtensionBase<RunConfigurationBase<?>>> myExtensionsManager;

    protected RunConfigurationFragmentedEditor(Settings runConfiguration, RunConfigurationExtensionsManager extensionsManager) {
        this.myRunConfiguration = runConfiguration;
        this.myExtensionsManager = extensionsManager;
    }

    protected final List<SettingsEditorFragment<Settings, ?>> createFragments() {
        ArrayList fragments = new ArrayList(this.createRunFragments());
        for (SettingsEditorFragment wrapper2 : this.myExtensionsManager.createFragments(this.myRunConfiguration)) {
            fragments.add(wrapper2);
        }
        this.addRunnerSettingsEditors(fragments);
        return fragments;
    }

    private void addRunnerSettingsEditors(List<SettingsEditorFragment<Settings, ?>> fragments) {
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            final ProgramRunner runner = ProgramRunner.getRunner((String)executor.getId(), this.myRunConfiguration);
            if (runner == null) continue;
            final SettingsEditor configEditor = this.myRunConfiguration.getRunnerSettingsEditor(runner);
            final SettingsEditor runnerEditor = runner.getSettingsEditor(executor, this.myRunConfiguration);
            if (configEditor == null && runnerEditor == null) continue;
            JPanel component2 = new JPanel(new BorderLayout());
            component2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)executor.getStartActionText(), (boolean)false));
            if (configEditor != null) {
                component2.add((Component)configEditor.getComponent(), "Center");
            }
            if (runnerEditor != null) {
                component2.add((Component)runnerEditor.getComponent(), configEditor == null ? "Center" : "South");
            }
            RunConfigurationEditorFragment fragment = new RunConfigurationEditorFragment<Settings, JComponent>(executor.getId() + ".config", executor.getStartActionText(), ExecutionBundle.message((String)"run.configuration.startup.connection.rab.title", (Object[])new Object[0]), component2, 0){

                @Override
                public void resetEditorFrom(@NotNull RunnerAndConfigurationSettingsImpl s) {
                    if (s == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (configEditor != null) {
                        configEditor.resetFrom((Object)s.getConfigurationSettings(runner));
                    }
                    if (runnerEditor != null) {
                        runnerEditor.resetFrom(s.getRunnerSettings(runner));
                    }
                }

                @Override
                public void applyEditorTo(@NotNull RunnerAndConfigurationSettingsImpl s) {
                    if (s == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    try {
                        if (configEditor != null) {
                            configEditor.applyTo((Object)s.getConfigurationSettings(runner));
                        }
                        if (runnerEditor != null) {
                            runnerEditor.applyTo(s.getRunnerSettings(runner));
                        }
                    }
                    catch (ConfigurationException e) {
                        LOG.error((Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "s";
                    objectArray2[1] = "com/intellij/execution/ui/RunConfigurationFragmentedEditor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "resetEditorFrom";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applyEditorTo";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            if (configEditor != null) {
                Disposer.register((Disposable)fragment, (Disposable)configEditor);
            }
            if (runnerEditor != null) {
                Disposer.register((Disposable)fragment, (Disposable)runnerEditor);
            }
            fragments.add(fragment);
        }
    }

    protected abstract List<SettingsEditorFragment<Settings, ?>> createRunFragments();

    public void resetEditorFrom(@NotNull RunnerAndConfigurationSettingsImpl s) {
        if (s == null) {
            RunConfigurationFragmentedEditor.$$$reportNull$$$0(0);
        }
        for (RunConfigurationEditorFragment<?, ?> fragment : this.getRunFragments()) {
            fragment.resetEditorFrom(s);
        }
    }

    public void applyEditorTo(@NotNull RunnerAndConfigurationSettingsImpl s) {
        if (s == null) {
            RunConfigurationFragmentedEditor.$$$reportNull$$$0(1);
        }
        for (RunConfigurationEditorFragment<?, ?> fragment : this.getRunFragments()) {
            fragment.applyEditorTo(s);
        }
    }

    @NotNull
    private @NotNull List<@NotNull RunConfigurationEditorFragment<?, ?>> getRunFragments() {
        List list2 = ContainerUtil.mapNotNull((Collection)this.getFragments(), fragment -> fragment instanceof RunConfigurationEditorFragment ? (RunConfigurationEditorFragment)((Object)fragment) : null);
        if (list2 == null) {
            RunConfigurationFragmentedEditor.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/RunConfigurationFragmentedEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/RunConfigurationFragmentedEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunFragments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

