/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.ElementSignatureProvider;
import com.intellij.codeInsight.folding.impl.GenericElementSignatureProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FoldingPolicy {
    private static final Logger LOG = Logger.getInstance(FoldingPolicy.class);
    private static final GenericElementSignatureProvider GENERIC_PROVIDER = new GenericElementSignatureProvider();

    private FoldingPolicy() {
    }

    static boolean isCollapsedByDefault(@NotNull FoldingDescriptor foldingDescriptor, @NotNull FoldingBuilder foldingBuilder) {
        if (foldingDescriptor == null) {
            FoldingPolicy.$$$reportNull$$$0(0);
        }
        if (foldingBuilder == null) {
            FoldingPolicy.$$$reportNull$$$0(1);
        }
        try {
            return foldingBuilder.isCollapsedByDefault(foldingDescriptor);
        }
        catch (IndexNotReadyException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    @Nullable
    public static String getSignature(@NotNull PsiElement element2) {
        if (element2 == null) {
            FoldingPolicy.$$$reportNull$$$0(2);
        }
        for (ElementSignatureProvider provider : ElementSignatureProvider.EP_NAME.getExtensionList()) {
            String signature = provider.getSignature(element2);
            if (signature == null) continue;
            return signature;
        }
        return GENERIC_PROVIDER.getSignature(element2);
    }

    @Nullable
    public static PsiElement restoreBySignature(@NotNull PsiFile file2, @NotNull String signature) {
        if (file2 == null) {
            FoldingPolicy.$$$reportNull$$$0(3);
        }
        if (signature == null) {
            FoldingPolicy.$$$reportNull$$$0(4);
        }
        return FoldingPolicy.restoreBySignature(file2, signature, null);
    }

    @Nullable
    public static PsiElement restoreBySignature(@NotNull PsiFile file2, @NotNull String signature, @Nullable StringBuilder processingInfoStorage) {
        if (file2 == null) {
            FoldingPolicy.$$$reportNull$$$0(5);
        }
        if (signature == null) {
            FoldingPolicy.$$$reportNull$$$0(6);
        }
        for (ElementSignatureProvider provider : ElementSignatureProvider.EP_NAME.getExtensionList()) {
            PsiElement result2 = provider.restoreBySignature(file2, signature, processingInfoStorage);
            if (result2 == null) continue;
            return result2;
        }
        return GENERIC_PROVIDER.restoreBySignature(file2, signature, processingInfoStorage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/FoldingPolicy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCollapsedByDefault";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSignature";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreBySignature";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

