/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback } from 'react';
import { EuiButtonGroup, EuiFormRow, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
var PARAMS = {
  NAME: 'row',
  ROWS: 'visEditorSplitBy__true',
  COLUMNS: 'visEditorSplitBy__false'
};

function RowsOrColumnsControl(_ref) {
  var editorStateParams = _ref.editorStateParams,
      setStateParamValue = _ref.setStateParamValue;

  if (editorStateParams.row === undefined) {
    setStateParamValue(PARAMS.NAME, true);
  }

  var idSelected = "visEditorSplitBy__".concat(editorStateParams.row);
  var options = [{
    id: PARAMS.ROWS,
    label: i18n.translate('visDefaultEditor.controls.rowsLabel', {
      defaultMessage: 'Rows'
    })
  }, {
    id: PARAMS.COLUMNS,
    label: i18n.translate('visDefaultEditor.controls.columnsLabel', {
      defaultMessage: 'Columns'
    })
  }];
  var onChange = useCallback(function (optionId) {
    return setStateParamValue(PARAMS.NAME, optionId === PARAMS.ROWS);
  }, [setStateParamValue]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiFormRow, {
    compressed: true,
    fullWidth: true
  }, /*#__PURE__*/React.createElement(EuiButtonGroup, {
    "data-test-subj": "visEditorSplitBy",
    legend: i18n.translate('visDefaultEditor.controls.splitByLegend', {
      defaultMessage: 'Split chart by rows or columns.'
    }),
    options: options,
    isFullWidth: true,
    idSelected: idSelected,
    onChange: onChange
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }));
}

export { RowsOrColumnsControl };