function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { lazy, Suspense } from 'react';
import ReactDOM from 'react-dom';
import { Router, Switch, Route } from 'react-router-dom';
import { I18nProvider } from '@kbn/i18n/react';
import { EuiLoadingSpinner } from '@elastic/eui';
import { getAllowedTypes } from './../lib';
var allowedObjectTypes;
var SavedObjectsEditionPage = /*#__PURE__*/lazy(function () {
  return import('./saved_objects_edition_page');
});
var SavedObjectsTablePage = /*#__PURE__*/lazy(function () {
  return import('./saved_objects_table_page');
});
export var mountManagementSection = /*#__PURE__*/function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref) {
    var core, mountParams, serviceRegistry, _yield$core$getStartS, _yield$core$getStartS2, coreStart, data, pluginStart, element, history, setBreadcrumbs, capabilities, RedirectToHomeIfUnauthorized;

    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            core = _ref.core, mountParams = _ref.mountParams, serviceRegistry = _ref.serviceRegistry;
            _context.next = 3;
            return core.getStartServices();

          case 3:
            _yield$core$getStartS = _context.sent;
            _yield$core$getStartS2 = _slicedToArray(_yield$core$getStartS, 3);
            coreStart = _yield$core$getStartS2[0];
            data = _yield$core$getStartS2[1].data;
            pluginStart = _yield$core$getStartS2[2];
            element = mountParams.element, history = mountParams.history, setBreadcrumbs = mountParams.setBreadcrumbs;

            if (!(allowedObjectTypes === undefined)) {
              _context.next = 13;
              break;
            }

            _context.next = 12;
            return getAllowedTypes(coreStart.http);

          case 12:
            allowedObjectTypes = _context.sent;

          case 13:
            capabilities = coreStart.application.capabilities;

            RedirectToHomeIfUnauthorized = function RedirectToHomeIfUnauthorized(_ref3) {
              var _capabilities$managem, _capabilities$managem2, _capabilities$managem3;

              var children = _ref3.children;
              var allowed = (_capabilities$managem = capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$managem2 = capabilities.management) === null || _capabilities$managem2 === void 0 ? void 0 : (_capabilities$managem3 = _capabilities$managem2.kibana) === null || _capabilities$managem3 === void 0 ? void 0 : _capabilities$managem3.objects) !== null && _capabilities$managem !== void 0 ? _capabilities$managem : false;

              if (!allowed) {
                coreStart.application.navigateToApp('home');
                return null;
              }

              return children;
            };

            ReactDOM.render( /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(Router, {
              history: history
            }, /*#__PURE__*/React.createElement(Switch, null, /*#__PURE__*/React.createElement(Route, {
              path: '/:service/:id',
              exact: true
            }, /*#__PURE__*/React.createElement(RedirectToHomeIfUnauthorized, null, /*#__PURE__*/React.createElement(Suspense, {
              fallback: /*#__PURE__*/React.createElement(EuiLoadingSpinner, null)
            }, /*#__PURE__*/React.createElement(SavedObjectsEditionPage, {
              coreStart: coreStart,
              serviceRegistry: serviceRegistry,
              setBreadcrumbs: setBreadcrumbs,
              history: history
            })))), /*#__PURE__*/React.createElement(Route, {
              path: '/',
              exact: false
            }, /*#__PURE__*/React.createElement(RedirectToHomeIfUnauthorized, null, /*#__PURE__*/React.createElement(Suspense, {
              fallback: /*#__PURE__*/React.createElement(EuiLoadingSpinner, null)
            }, /*#__PURE__*/React.createElement(SavedObjectsTablePage, {
              coreStart: coreStart,
              dataStart: data,
              serviceRegistry: serviceRegistry,
              actionRegistry: pluginStart.actions,
              allowedTypes: allowedObjectTypes,
              setBreadcrumbs: setBreadcrumbs
            }))))))), element);
            return _context.abrupt("return", function () {
              ReactDOM.unmountComponentAtNode(element);
            });

          case 17:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));

  return function mountManagementSection(_x) {
    return _ref2.apply(this, arguments);
  };
}();