/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export function buildCSS() {
  var maxHeight = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
  var truncateGradientHeight = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 15;
  return "\n.truncate-by-height {\n  max-height: ".concat(maxHeight > 0 ? "".concat(maxHeight, "px !important") : 'none', ";\n  display: inline-block;\n}\n.truncate-by-height:before {\n  top:  ").concat(maxHeight > 0 ? maxHeight - truncateGradientHeight : truncateGradientHeight * -1, "px;\n}\n");
}
export function injectHeaderStyle(uiSettings) {
  var style = document.createElement('style');
  style.setAttribute('id', 'style-compile');
  document.getElementsByTagName('head')[0].appendChild(style);
  uiSettings.get$('truncate:maxHeight').subscribe(function (value) {
    style.innerHTML = buildCSS(value);
  });
}