/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import $ from 'jquery'; // @ts-ignore

import rison from 'rison-node';
import '../../doc_viewer'; // @ts-ignore

import { noWhiteSpace } from '../../../../../../../legacy/core_plugins/kibana/common/utils/no_white_space';
import openRowHtml from './table_row/open.html';
import detailsHtml from './table_row/details.html';
import { dispatchRenderComplete } from '../../../../../../kibana_utils/public';
import { DOC_HIDE_TIME_COLUMN_SETTING } from '../../../../../common';
import cellTemplateHtml from '../components/table_row/cell.html';
import truncateByHeightTemplateHtml from '../components/table_row/truncate_by_height.html';
import { esFilters } from '../../../../../../data/public';
import { getServices } from '../../../../kibana_services'; // guesstimate at the minimum number of chars wide cells in the table should be

var MIN_LINE_LENGTH = 20;
export function createTableRowDirective($compile, $httpParamSerializer) {
  var cellTemplate = _.template(noWhiteSpace(cellTemplateHtml));

  var truncateByHeightTemplate = _.template(noWhiteSpace(truncateByHeightTemplateHtml));

  return {
    restrict: 'A',
    scope: {
      columns: '=',
      filter: '=',
      indexPattern: '=',
      row: '=kbnTableRow',
      onAddColumn: '=?',
      onRemoveColumn: '=?'
    },
    link: function link($scope, $el) {
      $el.after('<tr data-test-subj="docTableDetailsRow" class="kbnDocTableDetails__row">');
      $el.empty(); // when we compile the details, we use this $scope

      var $detailsScope; // when we compile the toggle button in the summary, we use this $scope

      var $toggleScope; // toggle display of the rows details, a full list of the fields from each row

      $scope.toggleRow = function () {
        var $detailsTr = $el.next();
        $scope.open = !$scope.open; ///
        // add/remove $details children
        ///

        $detailsTr.toggle($scope.open);

        if (!$scope.open) {
          // close the child scope if it exists
          $detailsScope.$destroy(); // no need to go any further

          return;
        } else {
          $detailsScope = $scope.$new();
        } // empty the details and rebuild it


        $detailsTr.html(detailsHtml);
        $detailsScope.row = $scope.row;
        $detailsScope.hit = $scope.row;
        $detailsScope.uriEncodedId = encodeURIComponent($detailsScope.hit._id);
        $compile($detailsTr)($detailsScope);
      };

      $scope.$watchMulti(['indexPattern.timeFieldName', 'row.highlight', '[]columns'], function () {
        createSummaryRow($scope.row);
      });

      $scope.inlineFilter = function inlineFilter($event, type) {
        var column = $($event.target).data().column;
        var field = $scope.indexPattern.fields.getByName(column);
        $scope.filter(field, $scope.flattenedRow[column], type);
      };

      $scope.getContextAppHref = function () {
        var path = "#/context/".concat(encodeURIComponent($scope.indexPattern.id), "/").concat(encodeURIComponent($scope.row._id));
        var globalFilters = getServices().filterManager.getGlobalFilters();
        var appFilters = getServices().filterManager.getAppFilters();
        var hash = $httpParamSerializer({
          _g: encodeURI(rison.encode({
            filters: globalFilters || []
          })),
          _a: encodeURI(rison.encode({
            columns: $scope.columns,
            filters: (appFilters || []).map(esFilters.disableFilter)
          }))
        });
        return "".concat(path, "?").concat(hash);
      }; // create a tr element that lists the value for each *column*


      function createSummaryRow(row) {
        var indexPattern = $scope.indexPattern;
        $scope.flattenedRow = indexPattern.flattenHit(row); // We just create a string here because its faster.

        var newHtmls = [openRowHtml];
        var mapping = indexPattern.fields.getByName;
        var hideTimeColumn = getServices().uiSettings.get(DOC_HIDE_TIME_COLUMN_SETTING, false);

        if (indexPattern.timeFieldName && !hideTimeColumn) {
          newHtmls.push(cellTemplate({
            timefield: true,
            formatted: _displayField(row, indexPattern.timeFieldName),
            filterable: mapping(indexPattern.timeFieldName).filterable && $scope.filter,
            column: indexPattern.timeFieldName
          }));
        }

        $scope.columns.forEach(function (column) {
          var isFilterable = mapping(column) && mapping(column).filterable && $scope.filter;
          newHtmls.push(cellTemplate({
            timefield: false,
            sourcefield: column === '_source',
            formatted: _displayField(row, column, true),
            filterable: isFilterable,
            column: column
          }));
        });
        var $cells = $el.children();
        newHtmls.forEach(function (html, i) {
          var $cell = $cells.eq(i);
          if ($cell.data('discover:html') === html) return;

          var reuse = _.find($cells.slice(i + 1), function (cell) {
            return $.data(cell, 'discover:html') === html;
          });

          var $target = reuse ? $(reuse).detach() : $(html);
          $target.data('discover:html', html);
          var $before = $cells.eq(i - 1);

          if ($before.length) {
            $before.after($target);
          } else {
            $el.append($target);
          } // rebuild cells since we modified the children


          $cells = $el.children();

          if (!reuse) {
            $toggleScope = $scope.$new();
            $compile($target)($toggleScope);
          }
        });

        if ($scope.open) {
          $detailsScope.row = row;
        } // trim off cells that were not used rest of the cells


        $cells.filter(':gt(' + (newHtmls.length - 1) + ')').remove();
        dispatchRenderComplete($el[0]);
      }
      /**
       * Fill an element with the value of a field
       */


      function _displayField(row, fieldName) {
        var truncate = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
        var indexPattern = $scope.indexPattern;
        var text = indexPattern.formatField(row, fieldName);

        if (truncate && text.length > MIN_LINE_LENGTH) {
          return truncateByHeightTemplate({
            body: text
          });
        }

        return text;
      }
    }
  };
}