function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { BucketAggType } from './bucket_agg_type';
import { createFilterTerms } from './create_filter/terms';
import { isStringType, migrateIncludeExcludeFormat } from './migrate_include_exclude_format';
import { BUCKET_TYPES } from './bucket_agg_types';
import { KBN_FIELD_TYPES } from '../../../../common';
var significantTermsTitle = i18n.translate('data.search.aggs.buckets.significantTermsTitle', {
  defaultMessage: 'Significant Terms'
});
export var getSignificantTermsBucketAgg = function getSignificantTermsBucketAgg() {
  return new BucketAggType({
    name: BUCKET_TYPES.SIGNIFICANT_TERMS,
    title: significantTermsTitle,
    makeLabel: function makeLabel(aggConfig) {
      return i18n.translate('data.search.aggs.buckets.significantTermsLabel', {
        defaultMessage: 'Top {size} unusual terms in {fieldName}',
        values: {
          size: aggConfig.params.size,
          fieldName: aggConfig.getFieldDisplayName()
        }
      });
    },
    createFilter: createFilterTerms,
    params: [{
      name: 'field',
      type: 'field',
      scriptable: false,
      filterFieldTypes: KBN_FIELD_TYPES.STRING
    }, {
      name: 'size',
      default: ''
    }, _objectSpread({
      name: 'exclude',
      displayName: i18n.translate('data.search.aggs.buckets.significantTerms.excludeLabel', {
        defaultMessage: 'Exclude'
      }),
      type: 'string',
      advanced: true,
      shouldShow: isStringType
    }, migrateIncludeExcludeFormat), _objectSpread({
      name: 'include',
      displayName: i18n.translate('data.search.aggs.buckets.significantTerms.includeLabel', {
        defaultMessage: 'Include'
      }),
      type: 'string',
      advanced: true,
      shouldShow: isStringType
    }, migrateIncludeExcludeFormat)]
  });
};