function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { createStateContainer, syncState } from '../../../../kibana_utils/public';
import { connectToQueryState } from './connect_to_query_state';
import { FilterStateStore } from '../../../common/es_query/filters';
var GLOBAL_STATE_STORAGE_KEY = '_g';
/**
 * Helper to setup syncing of global data with the URL
 * @param QueryService: either setup or start
 * @param kbnUrlStateStorage to use for syncing
 */

export var syncQueryStateWithUrl = function syncQueryStateWithUrl(query, kbnUrlStateStorage) {
  var timefilter = query.timefilter.timefilter,
      filterManager = query.filterManager;
  var defaultState = {
    time: timefilter.getTime(),
    refreshInterval: timefilter.getRefreshInterval(),
    filters: filterManager.getGlobalFilters()
  }; // retrieve current state from `_g` url

  var initialStateFromUrl = kbnUrlStateStorage.get(GLOBAL_STATE_STORAGE_KEY); // remember whether there was info in the URL

  var hasInheritedQueryFromUrl = Boolean(initialStateFromUrl && Object.keys(initialStateFromUrl).length); // prepare initial state, whatever was in URL takes precedences over current state in services

  var initialState = _objectSpread(_objectSpread({}, defaultState), initialStateFromUrl);

  var globalQueryStateContainer = createStateContainer(initialState);
  var stopSyncingWithStateContainer = connectToQueryState(query, globalQueryStateContainer, {
    refreshInterval: true,
    time: true,
    filters: FilterStateStore.GLOBAL_STATE
  }); // if there weren't any initial state in url,
  // then put _g key into url

  if (!initialStateFromUrl) {
    kbnUrlStateStorage.set(GLOBAL_STATE_STORAGE_KEY, initialState, {
      replace: true
    });
  } // trigger initial syncing from state container to services if needed


  globalQueryStateContainer.set(initialState);

  var _syncState = syncState({
    stateStorage: kbnUrlStateStorage,
    stateContainer: _objectSpread(_objectSpread({}, globalQueryStateContainer), {}, {
      set: function set(state) {
        if (state) {
          // syncState utils requires to handle incoming "null" value
          globalQueryStateContainer.set(state);
        }
      }
    }),
    storageKey: GLOBAL_STATE_STORAGE_KEY
  }),
      start = _syncState.start,
      stopSyncingWithUrl = _syncState.stop;

  start();
  return {
    stop: function stop() {
      stopSyncingWithStateContainer();
      stopSyncingWithUrl();
    },
    hasInheritedQueryFromUrl: hasInheritedQueryFromUrl
  };
};