function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { BehaviorSubject } from 'rxjs';
export var History = /*#__PURE__*/function () {
  function History(storage) {
    _classCallCheck(this, History);

    this.storage = storage;

    _defineProperty(this, "changeEmitter", new BehaviorSubject(this.getHistory() || []));
  }

  _createClass(History, [{
    key: "getHistoryKeys",
    value: function getHistoryKeys() {
      return this.storage.keys().filter(function (key) {
        return key.indexOf('hist_elem') === 0;
      }).sort().reverse();
    }
  }, {
    key: "getHistory",
    value: function getHistory() {
      var _this = this;

      return this.getHistoryKeys().map(function (key) {
        return _this.storage.get(key);
      });
    } // This is used as an optimization mechanism so that different components
    // can listen for changes to history and update because changes to history can
    // be triggered from different places in the app. The alternative would be to store
    // this in state so that we hook into the React model, but it would require loading history
    // every time the application starts even if a user is not going to view history.

  }, {
    key: "change",
    value: function change(listener) {
      var subscription = this.changeEmitter.subscribe(listener);
      return function () {
        return subscription.unsubscribe();
      };
    }
  }, {
    key: "addToHistory",
    value: function addToHistory(endpoint, method, data) {
      var _this2 = this;

      var keys = this.getHistoryKeys();
      keys.splice(0, 500); // only maintain most recent X;

      keys.forEach(function (key) {
        _this2.storage.delete(key);
      });
      var timestamp = new Date().getTime();
      var k = 'hist_elem_' + timestamp;
      this.storage.set(k, {
        time: timestamp,
        endpoint: endpoint,
        method: method,
        data: data
      });
      this.changeEmitter.next(this.getHistory());
    }
  }, {
    key: "updateCurrentState",
    value: function updateCurrentState(content) {
      var timestamp = new Date().getTime();
      this.storage.set('editor_state', {
        time: timestamp,
        content: content
      });
    }
  }, {
    key: "getLegacySavedEditorState",
    value: function getLegacySavedEditorState() {
      var saved = this.storage.get('editor_state');
      if (!saved) return;
      var time = saved.time,
          content = saved.content;
      return {
        time: time,
        content: content
      };
    }
    /**
     * This function should only ever be called once for a user if they had legacy state.
     */

  }, {
    key: "deleteLegacySavedEditorState",
    value: function deleteLegacySavedEditorState() {
      this.storage.delete('editor_state');
    }
  }, {
    key: "clearHistory",
    value: function clearHistory() {
      var _this3 = this;

      this.getHistoryKeys().forEach(function (key) {
        return _this3.storage.delete(key);
      });
    }
  }]);

  return History;
}();
export function createHistory(deps) {
  return new History(deps.storage);
}