"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseConfigsTask = parseConfigsTask;

var path = _interopRequireWildcard(require("path"));

var _config = require("../config");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function parseConfigsTask() {
  const kibanaRoot = process.cwd();
  const xpackRoot = path.join(kibanaRoot, 'x-pack');
  const configRoots = [kibanaRoot, xpackRoot];
  return configRoots.map(configRoot => ({
    task: async context => {
      try {
        const configs = await (0, _config.parseTelemetryRC)(configRoot);
        configs.forEach(config => {
          context.roots.push({
            config
          });
        });
      } catch (err) {
        const {
          reporter
        } = context;
        const reporterWithContext = reporter.withContext({
          name: configRoot
        });
        reporterWithContext.report(err);
        throw reporter;
      }
    },
    title: `Parsing configs in ${configRoot}`
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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