"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSideNav = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _icon = require("../icon");

var _side_nav_item = require("./side_nav_item");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiSideNav =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiSideNav, _Component);

  function EuiSideNav() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiSideNav);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiSideNav)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "isItemOpen", function (item) {
      // The developer can force the item to be open.
      if (item.forceOpen) {
        return true;
      } // Of course a selected item is open.


      if (item.isSelected) {
        return true;
      } // The item has to be open if it has a child that's open.


      if (item.items) {
        return item.items.some(_this.isItemOpen);
      }

      return false;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "renderTree", function (items) {
      var depth = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var renderItem = _this.props.renderItem;
      return items.map(function (item) {
        var id = item.id,
            name = item.name,
            isSelected = item.isSelected,
            childItems = item.items,
            icon = item.icon,
            onClick = item.onClick,
            href = item.href,
            forceOpen = item.forceOpen,
            rest = (0, _objectWithoutProperties2.default)(item, ["id", "name", "isSelected", "items", "icon", "onClick", "href", "forceOpen"]); // Root items are always open.

        var isOpen = depth === 0 ? true : _this.isItemOpen(item);
        var renderedItems;

        if (childItems) {
          renderedItems = _this.renderTree(childItems, depth + 1);
        }

        return _react.default.createElement(_side_nav_item.EuiSideNavItem, (0, _extends2.default)({
          isOpen: isOpen,
          isSelected: isSelected,
          isParent: !!childItems,
          icon: icon,
          onClick: onClick,
          href: href,
          items: renderedItems,
          key: id,
          depth: depth,
          renderItem: renderItem
        }, rest), name);
      });
    });
    return _this;
  }

  (0, _createClass2.default)(EuiSideNav, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          className = _this$props.className,
          items = _this$props.items,
          toggleOpenOnMobile = _this$props.toggleOpenOnMobile,
          isOpenOnMobile = _this$props.isOpenOnMobile,
          mobileTitle = _this$props.mobileTitle,
          renderItem = _this$props.renderItem,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["className", "items", "toggleOpenOnMobile", "isOpenOnMobile", "mobileTitle", "renderItem"]);
      var classes = (0, _classnames.default)('euiSideNav', className, {
        'euiSideNav-isOpenMobile': isOpenOnMobile
      });
      var nav = this.renderTree(items);
      return _react.default.createElement("nav", (0, _extends2.default)({
        className: classes
      }, rest), _react.default.createElement("button", {
        type: "button",
        className: "euiSideNav__mobileToggle euiLink",
        onClick: toggleOpenOnMobile
      }, _react.default.createElement("span", {
        className: "euiSideNav__mobileWrap"
      }, _react.default.createElement("span", {
        className: "euiSideNav__mobileTitle"
      }, mobileTitle), _react.default.createElement(_icon.EuiIcon, {
        className: "euiSideNav__mobileIcon",
        type: "apps",
        size: "m",
        "aria-hidden": "true"
      }))), _react.default.createElement("div", {
        className: "euiSideNav__content"
      }, nav));
    }
  }]);
  return EuiSideNav;
}(_react.Component);

exports.EuiSideNav = EuiSideNav;
(0, _defineProperty2.default)(EuiSideNav, "defaultProps", {
  items: []
});
EuiSideNav.propTypes = {
  /**
       * Class names to be merged into the final `className` property.
       */
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * When called, toggles visibility of the navigation menu at mobile responsive widths. The callback should set the `isOpenOnMobile` prop to actually toggle navigation visibility.
       */
  toggleOpenOnMobile: _propTypes.default.func,

  /**
       * If `true`, the navigation menu will be open at mobile device widths. Use in conjunction with the `toggleOpenOnMobile` prop.
       */
  isOpenOnMobile: _propTypes.default.bool,

  /**
       * A React node to render at mobile responsive widths, representing the title of this navigation menu.
       */
  mobileTitle: _propTypes.default.node,

  /**
       *  An array of #EuiSideNavItem objects. Lists navigation menu items.
       */
  items: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * A value that is passed to React as the `key` for this item
       */
    id: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired,

    /**
       * If set to true it will force the item to display in an "open" state at all times.
       */
    forceOpen: _propTypes.default.bool,

    /**
       * Is an optional string to be passed as the navigation item's `href` prop, and by default it will force rendering of the item as an `<a>`.
       */
    href: _propTypes.default.string,
    target: _propTypes.default.string,
    rel: _propTypes.default.string,

    /**
       * React node which will be rendered as a small icon to the left of the navigation item text.
       */
    icon: _propTypes.default.element,

    /**
       * If set to true it will render the item in a visible "selected" state, and will force all ancestor navigation items to render in an "open" state.
       */
    isSelected: _propTypes.default.bool,

    /**
       * Array containing additional item objects, representing nested children of this navigation item.
       */
    items: _propTypes.default.arrayOf(_propTypes.default.shape({
      /**
         * A value that is passed to React as the `key` for this item
         */
      id: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired,

      /**
         * If set to true it will force the item to display in an "open" state at all times.
         */
      forceOpen: _propTypes.default.bool,

      /**
         * Is an optional string to be passed as the navigation item's `href` prop, and by default it will force rendering of the item as an `<a>`.
         */
      href: _propTypes.default.string,
      target: _propTypes.default.string,
      rel: _propTypes.default.string,

      /**
         * React node which will be rendered as a small icon to the left of the navigation item text.
         */
      icon: _propTypes.default.element,

      /**
         * If set to true it will render the item in a visible "selected" state, and will force all ancestor navigation items to render in an "open" state.
         */
      isSelected: _propTypes.default.bool,

      /**
         * Array containing additional item objects, representing nested children of this navigation item.
         */
      items: _propTypes.default.arrayOf(_propTypes.default.any.isRequired),

      /**
         * React node representing the text to render for this item (usually a string will suffice).
         */
      name: _propTypes.default.node.isRequired,

      /**
         * Callback function to be passed as the navigation item's `onClick` prop, and by default it will force rendering of the item as a `<button>` instead of a link.
         */
      onClick: _propTypes.default.func,

      /**
         * Function overriding default rendering for this navigation item — when called, it should return a React node representing a replacement navigation item.
         */
      renderItem: _propTypes.default.func
    }).isRequired),

    /**
       * React node representing the text to render for this item (usually a string will suffice).
       */
    name: _propTypes.default.node.isRequired,

    /**
       * Callback function to be passed as the navigation item's `onClick` prop, and by default it will force rendering of the item as a `<button>` instead of a link.
       */
    onClick: _propTypes.default.func,

    /**
       * Function overriding default rendering for this navigation item — when called, it should return a React node representing a replacement navigation item.
       */
    renderItem: _propTypes.default.func
  }).isRequired).isRequired,

  /**
       * Overrides default navigation menu item rendering. When called, it should return a React node representing a replacement navigation item.
       */
  renderItem: _propTypes.default.func
};
EuiSideNav.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "isItemOpen",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "item",
      "type": null
    }],
    "returns": null
  }, {
    "name": "renderTree",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "items",
      "type": null
    }, {
      "name": "depth",
      "type": null
    }],
    "returns": null
  }],
  "displayName": "EuiSideNav",
  "props": {
    "items": {
      "defaultValue": {
        "value": "[]",
        "computed": false
      },
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "shape",
          "value": {
            "id": {
              "name": "union",
              "value": [{
                "name": "string"
              }, {
                "name": "number"
              }],
              "description": "A value that is passed to React as the `key` for this item",
              "required": true
            },
            "forceOpen": {
              "name": "bool",
              "description": "If set to true it will force the item to display in an \"open\" state at all times.",
              "required": false
            },
            "href": {
              "name": "string",
              "description": "Is an optional string to be passed as the navigation item's `href` prop, and by default it will force rendering of the item as an `<a>`.",
              "required": false
            },
            "target": {
              "name": "string",
              "required": false
            },
            "rel": {
              "name": "string",
              "required": false
            },
            "icon": {
              "name": "element",
              "description": "React node which will be rendered as a small icon to the left of the navigation item text.",
              "required": false
            },
            "isSelected": {
              "name": "bool",
              "description": "If set to true it will render the item in a visible \"selected\" state, and will force all ancestor navigation items to render in an \"open\" state.",
              "required": false
            },
            "items": {
              "name": "arrayOf",
              "value": {
                "name": "shape",
                "value": {
                  "id": {
                    "name": "union",
                    "value": [{
                      "name": "string"
                    }, {
                      "name": "number"
                    }],
                    "description": "A value that is passed to React as the `key` for this item",
                    "required": true
                  },
                  "forceOpen": {
                    "name": "bool",
                    "description": "If set to true it will force the item to display in an \"open\" state at all times.",
                    "required": false
                  },
                  "href": {
                    "name": "string",
                    "description": "Is an optional string to be passed as the navigation item's `href` prop, and by default it will force rendering of the item as an `<a>`.",
                    "required": false
                  },
                  "target": {
                    "name": "string",
                    "required": false
                  },
                  "rel": {
                    "name": "string",
                    "required": false
                  },
                  "icon": {
                    "name": "element",
                    "description": "React node which will be rendered as a small icon to the left of the navigation item text.",
                    "required": false
                  },
                  "isSelected": {
                    "name": "bool",
                    "description": "If set to true it will render the item in a visible \"selected\" state, and will force all ancestor navigation items to render in an \"open\" state.",
                    "required": false
                  },
                  "items": {
                    "name": "arrayOf",
                    "value": {
                      "name": "any"
                    },
                    "description": "Array containing additional item objects, representing nested children of this navigation item.",
                    "required": false
                  },
                  "name": {
                    "name": "node",
                    "description": "React node representing the text to render for this item (usually a string will suffice).",
                    "required": true
                  },
                  "onClick": {
                    "name": "func",
                    "description": "Callback function to be passed as the navigation item's `onClick` prop, and by default it will force rendering of the item as a `<button>` instead of a link.",
                    "required": false
                  },
                  "renderItem": {
                    "name": "func",
                    "description": "Function overriding default rendering for this navigation item \u2014 when called, it should return a React node representing a replacement navigation item.",
                    "required": false
                  }
                }
              },
              "description": "Array containing additional item objects, representing nested children of this navigation item.",
              "required": false
            },
            "name": {
              "name": "node",
              "description": "React node representing the text to render for this item (usually a string will suffice).",
              "required": true
            },
            "onClick": {
              "name": "func",
              "description": "Callback function to be passed as the navigation item's `onClick` prop, and by default it will force rendering of the item as a `<button>` instead of a link.",
              "required": false
            },
            "renderItem": {
              "name": "func",
              "description": "Function overriding default rendering for this navigation item \u2014 when called, it should return a React node representing a replacement navigation item.",
              "required": false
            }
          }
        }
      },
      "required": false,
      "description": "An array of #EuiSideNavItem objects. Lists navigation menu items."
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "Class names to be merged into the final `className` property."
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "toggleOpenOnMobile": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": "When called, toggles visibility of the navigation menu at mobile responsive widths. The callback should set the `isOpenOnMobile` prop to actually toggle navigation visibility."
    },
    "isOpenOnMobile": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "If `true`, the navigation menu will be open at mobile device widths. Use in conjunction with the `toggleOpenOnMobile` prop."
    },
    "mobileTitle": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": "A React node to render at mobile responsive widths, representing the title of this navigation menu."
    },
    "renderItem": {
      "type": {
        "name": "func"
      },
      "required": false,
      "description": "Overrides default navigation menu item rendering. When called, it should return a React node representing a replacement navigation item."
    }
  }
};