"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFormRow = exports.DISPLAYS = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../../common");

var _objects = require("../../../services/objects");

var _form_help_text = require("../form_help_text");

var _form_error_text = require("../form_error_text");

var _form_label = require("../form_label");

var _accessibility = require("../../../services/accessibility");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var displayToClassNameMap = {
  row: null,
  rowCompressed: 'euiFormRow--compressed',
  columnCompressed: 'euiFormRow--compressed euiFormRow--horizontal',
  center: null,
  centerCompressed: 'euiFormRow--compressed',
  columnCompressedSwitch: 'euiFormRow--compressed euiFormRow--horizontal euiFormRow--hasSwitch'
};
var DISPLAYS = (0, _common.keysOf)(displayToClassNameMap);
exports.DISPLAYS = DISPLAYS;

var EuiFormRow =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiFormRow, _Component);

  function EuiFormRow() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiFormRow);

    for (var _len = arguments.length, _args = new Array(_len), _key = 0; _key < _len; _key++) {
      _args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiFormRow)).call.apply(_getPrototypeOf2, [this].concat(_args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      isFocused: false,
      id: _this.props.id || (0, _accessibility.htmlIdGenerator)()()
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFocus", function () {
      // Doing this to allow onFocus to be called correctly from the child input element as this component overrides it
      var onChildFocus = (0, _objects.get)(_this.props, 'children.props.onFocus');

      if (onChildFocus) {
        onChildFocus.apply(void 0, arguments);
      }

      _this.setState({
        isFocused: true
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onBlur", function () {
      // Doing this to allow onBlur to be called correctly from the child input element as this component overrides it
      var onChildBlur = (0, _objects.get)(_this.props, 'children.props.onBlur');

      if (onChildBlur) {
        onChildBlur.apply(void 0, arguments);
      }

      _this.setState({
        isFocused: false
      });
    });
    return _this;
  }

  (0, _createClass2.default)(EuiFormRow, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          helpText = _this$props.helpText,
          isInvalid = _this$props.isInvalid,
          error = _this$props.error,
          label = _this$props.label,
          labelType = _this$props.labelType,
          labelAppend = _this$props.labelAppend,
          hasEmptyLabelSpace = _this$props.hasEmptyLabelSpace,
          fullWidth = _this$props.fullWidth,
          className = _this$props.className,
          describedByIds = _this$props.describedByIds,
          compressed = _this$props.compressed,
          display = _this$props.display,
          displayOnly = _this$props.displayOnly,
          hasChildLabel = _this$props.hasChildLabel,
          propsId = _this$props.id,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["children", "helpText", "isInvalid", "error", "label", "labelType", "labelAppend", "hasEmptyLabelSpace", "fullWidth", "className", "describedByIds", "compressed", "display", "displayOnly", "hasChildLabel", "id"]);
      var id = this.state.id;
      /**
       * Remove when `compressed` is deprecated
       */

      var shimDisplay;

      if (compressed && display === 'row') {
        shimDisplay = 'rowCompressed';
      } else {
        /**
         * Safe use of ! as prop default is 'row'
         */
        shimDisplay = display;
      }
      /**
       * Remove when `displayOnly` is deprecated
       */


      if (compressed && displayOnly) {
        shimDisplay = 'centerCompressed';
      } else if (displayOnly && display === 'row') {
        shimDisplay = 'center';
      }

      var classes = (0, _classnames.default)('euiFormRow', {
        'euiFormRow--hasEmptyLabelSpace': hasEmptyLabelSpace,
        'euiFormRow--fullWidth': fullWidth
      }, displayToClassNameMap[shimDisplay], className);
      var optionalHelpText;

      if (helpText) {
        optionalHelpText = _react.default.createElement(_form_help_text.EuiFormHelpText, {
          id: "".concat(id, "-help"),
          className: "euiFormRow__text"
        }, helpText);
      }

      var optionalErrors;

      if (error && isInvalid) {
        var errorTexts = Array.isArray(error) ? error : [error];
        optionalErrors = errorTexts.map(function (error, i) {
          var key = typeof error === 'string' ? error : i;
          return _react.default.createElement(_form_error_text.EuiFormErrorText, {
            key: key,
            id: "".concat(id, "-error-").concat(i),
            className: "euiFormRow__text"
          }, error);
        });
      }

      var optionalLabel;
      var isLegend = label && labelType === 'legend' ? true : false;

      if (label || labelAppend) {
        var labelProps = {};

        if (isLegend) {
          labelProps = {
            type: labelType
          };
        } else {
          labelProps = {
            htmlFor: hasChildLabel ? id : undefined,
            isFocused: this.state.isFocused,
            type: labelType
          };
        }

        optionalLabel = _react.default.createElement("div", {
          className: "euiFormRow__labelWrapper"
        }, _react.default.createElement(_form_label.EuiFormLabel, (0, _extends2.default)({
          className: "euiFormRow__label",
          isInvalid: isInvalid,
          "aria-invalid": isInvalid
        }, labelProps), label), labelAppend && ' ', labelAppend);
      }

      var optionalProps = {};
      /**
       * Safe use of ! as default prop is []
       */

      var describingIds = (0, _toConsumableArray2.default)(describedByIds);

      if (optionalHelpText) {
        describingIds.push(optionalHelpText.props.id);
      }

      if (optionalErrors) {
        optionalErrors.forEach(function (error) {
          return describingIds.push(error.props.id);
        });
      }

      if (describingIds.length > 0) {
        optionalProps['aria-describedby'] = describingIds.join(' ');
      }

      var field = (0, _react.cloneElement)(_react.Children.only(children), _objectSpread({
        id: id,
        onFocus: this.onFocus,
        onBlur: this.onBlur
      }, optionalProps));
      var fieldWrapperClasses = (0, _classnames.default)('euiFormRow__fieldWrapper', {
        euiFormRow__fieldWrapperDisplayOnly:
        /**
         * Safe use of ! as default prop is 'row'
         */
        displayOnly || display.startsWith('center')
      });
      var sharedProps = {
        className: classes,
        id: "".concat(id, "-row")
      };

      var contents = _react.default.createElement(_react.default.Fragment, null, optionalLabel, _react.default.createElement("div", {
        className: fieldWrapperClasses
      }, field, optionalErrors, optionalHelpText));

      return labelType === 'legend' ? _react.default.createElement("fieldset", (0, _extends2.default)({}, sharedProps, rest), contents) : _react.default.createElement("div", (0, _extends2.default)({}, sharedProps, rest), contents);
    }
  }]);
  return EuiFormRow;
}(_react.Component);

exports.EuiFormRow = EuiFormRow;
(0, _defineProperty2.default)(EuiFormRow, "defaultProps", {
  display: 'row',
  hasEmptyLabelSpace: false,
  fullWidth: false,
  describedByIds: [],
  labelType: 'label',
  hasChildLabel: true
});
EuiFormRow.propTypes = {
  /**
     * Defaults to rendering a `<label>` but if passed `'legend'` for labelType,
     * will render both a `<legend>` and the surrounding container as a `<fieldset>`
     */
  labelType: _propTypes.default.oneOfType([_propTypes.default.oneOf(["label"]), _propTypes.default.oneOf(["legend"])]),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * When `rowCompressed`, just tightens up the spacing;
     * Set to `columnCompressed` if compressed
     * and horizontal layout is needed.
     * Set to `center` or `centerCompressed` to align non-input
     * content better with inline rows.
     * Set to `columnCompressedSwitch` if the form control being passed
     * as the child is a switch.
     */

  /**
     * When `rowCompressed`, just tightens up the spacing;
     * Set to `columnCompressed` if compressed
     * and horizontal layout is needed.
     * Set to `center` or `centerCompressed` to align non-input
     * content better with inline rows.
     * Set to `columnCompressedSwitch` if the form control being passed
     * as the child is a switch.
     */
  display: _propTypes.default.oneOf(["row", "rowCompressed", "columnCompressed", "center", "centerCompressed", "columnCompressedSwitch"]),
  hasEmptyLabelSpace: _propTypes.default.bool,
  fullWidth: _propTypes.default.bool,

  /**
     * IDs of additional elements that should be part of children's `aria-describedby`
     */

  /**
     * IDs of additional elements that should be part of children's `aria-describedby`
     */
  describedByIds: _propTypes.default.arrayOf(_propTypes.default.string.isRequired),

  /**
     * Escape hatch to not render duplicate labels if the child also renders a label
     */

  /**
     * Escape hatch to not render duplicate labels if the child also renders a label
     */
  hasChildLabel: _propTypes.default.bool,
  children: _propTypes.default.element.isRequired,
  label: _propTypes.default.node,

  /**
     * Adds an extra node to the right of the form label without
     * being contained inside the form label. Good for things
     * like documentation links.
     */

  /**
     * Adds an extra node to the right of the form label without
     * being contained inside the form label. Good for things
     * like documentation links.
     */
  labelAppend: _propTypes.default.any,
  id: _propTypes.default.string,
  isInvalid: _propTypes.default.bool,
  error: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.arrayOf(_propTypes.default.node.isRequired).isRequired]),
  helpText: _propTypes.default.node,

  /**
     * **DEPRECATED: use `display: rowCompressed` instead.**
     * When `true`, tightens up the spacing.
     */

  /**
     * **DEPRECATED: use `display: rowCompressed` instead.**
     * When `true`, tightens up the spacing.
     */
  compressed: _propTypes.default.bool,

  /**
     * **DEPRECATED: use `display: center` instead.**
     * Vertically centers non-input style content so it aligns
     * better with input style content.
     */

  /**
     * **DEPRECATED: use `display: center` instead.**
     * Vertically centers non-input style content so it aligns
     * better with input style content.
     */
  displayOnly: _propTypes.default.bool
};
EuiFormRow.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "onFocus",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "...args",
      "type": null
    }],
    "returns": null
  }, {
    "name": "onBlur",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "...args",
      "type": null
    }],
    "returns": null
  }],
  "displayName": "EuiFormRow",
  "props": {
    "display": {
      "defaultValue": {
        "value": "'row'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"row\"",
          "computed": false
        }, {
          "value": "\"rowCompressed\"",
          "computed": false
        }, {
          "value": "\"columnCompressed\"",
          "computed": false
        }, {
          "value": "\"center\"",
          "computed": false
        }, {
          "value": "\"centerCompressed\"",
          "computed": false
        }, {
          "value": "\"columnCompressedSwitch\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "When `rowCompressed`, just tightens up the spacing;\nSet to `columnCompressed` if compressed\nand horizontal layout is needed.\nSet to `center` or `centerCompressed` to align non-input\ncontent better with inline rows.\nSet to `columnCompressedSwitch` if the form control being passed\nas the child is a switch."
    },
    "hasEmptyLabelSpace": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "fullWidth": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "describedByIds": {
      "defaultValue": {
        "value": "[]",
        "computed": false
      },
      "type": {
        "name": "arrayOf",
        "value": {
          "name": "string"
        }
      },
      "required": false,
      "description": "IDs of additional elements that should be part of children's `aria-describedby`"
    },
    "labelType": {
      "defaultValue": {
        "value": "'label'",
        "computed": false
      },
      "type": {
        "name": "union",
        "value": [{
          "name": "enum",
          "value": [{
            "value": "\"label\"",
            "computed": false
          }]
        }, {
          "name": "enum",
          "value": [{
            "value": "\"legend\"",
            "computed": false
          }]
        }]
      },
      "required": false,
      "description": "Defaults to rendering a `<label>` but if passed `'legend'` for labelType,\nwill render both a `<legend>` and the surrounding container as a `<fieldset>`"
    },
    "hasChildLabel": {
      "defaultValue": {
        "value": "true",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Escape hatch to not render duplicate labels if the child also renders a label"
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "children": {
      "type": {
        "name": "element"
      },
      "required": true,
      "description": ""
    },
    "label": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": ""
    },
    "labelAppend": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": "Adds an extra node to the right of the form label without\nbeing contained inside the form label. Good for things\nlike documentation links."
    },
    "id": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "isInvalid": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "error": {
      "type": {
        "name": "union",
        "value": [{
          "name": "node"
        }, {
          "name": "arrayOf",
          "value": {
            "name": "node"
          }
        }]
      },
      "required": false,
      "description": ""
    },
    "helpText": {
      "type": {
        "name": "node"
      },
      "required": false,
      "description": ""
    },
    "compressed": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "**DEPRECATED: use `display: rowCompressed` instead.**\nWhen `true`, tightens up the spacing."
    },
    "displayOnly": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "**DEPRECATED: use `display: center` instead.**\nVertically centers non-input style content so it aligns\nbetter with input style content."
    }
  }
};