/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class RemoveSourceDBAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(RemoveSourceDBAction.class);
    private final ArchitectFrame frame;
    private final DBTree tree;

    public RemoveSourceDBAction(DBTree tree) {
        super(Messages.getString("DBTree.removeDbcsActionName"));
        this.tree = tree;
        this.frame = null;
    }

    public RemoveSourceDBAction(ArchitectFrame frame) {
        super(Messages.getString("DBTree.removeDbcsActionName"));
        this.frame = frame;
        this.tree = null;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        DBTree localTree = this.tree == null ? this.frame.getCurrentSession().getDBTree() : this.tree;
        TreePath tp = localTree.getSelectionPath();
        if (tp == null) {
            JOptionPane.showMessageDialog(localTree, Messages.getString("DBTree.noItemsSelected"), Messages.getString("DBTree.noItemsSelectedDialogTitle"), 2);
            return;
        }
        if (!(tp.getLastPathComponent() instanceof SQLDatabase)) {
            JOptionPane.showMessageDialog(localTree, Messages.getString("DBTree.selectionNotADb"), Messages.getString("DBTree.selectionNotADbDialogTitle"), 2);
            return;
        }
        if (localTree.isTargetDatabaseNode(tp)) {
            JOptionPane.showMessageDialog(localTree, Messages.getString("DBTree.cannotRemoveTargetDb"), Messages.getString("DBTree.cannotRemoveTargetDbDialogTitle"), 2);
            return;
        }
        SQLDatabase selection = (SQLDatabase)tp.getLastPathComponent();
        SQLObject root = (SQLObject)localTree.getModel().getRoot();
        try {
            if (root.removeChild((SPObject)selection)) {
                selection.disconnect();
            } else {
                logger.error((Object)"root.removeChild(selection) returned false!");
                JOptionPane.showMessageDialog(localTree, Messages.getString("DBTree.deleteConnectionFailed"), Messages.getString("DBTree.deleteConnectionFailedDialogTitle"), 0);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (ObjectDependentException e) {
            throw new RuntimeException(e);
        }
    }
}

