/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.table;

import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.FontSelector;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.table.EditableJTable;
import ca.sqlpower.swingui.table.TableModelCSVFormatter;
import ca.sqlpower.swingui.table.TableModelHTMLFormatter;
import ca.sqlpower.swingui.table.TableModelSearchDecorator;
import ca.sqlpower.swingui.table.TableModelSortDecorator;
import ca.sqlpower.swingui.table.TableModelWrapper;
import ca.sqlpower.swingui.table.TableTextConverter;
import ca.sqlpower.swingui.table.TableUtils;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPopupMenu;
import javax.swing.table.TableModel;
import javax.swing.text.Document;

public class FancyExportableJTable
extends EditableJTable {
    private final Action exportHTMLAction = new AbstractAction("Export Selected to HTML.."){

        @Override
        public void actionPerformed(ActionEvent e) {
            TableModelHTMLFormatter htmlFormatter = new TableModelHTMLFormatter();
            for (Map.Entry entry : FancyExportableJTable.this.columnFormatters.entrySet()) {
                htmlFormatter.setFormatter((Integer)entry.getKey(), (Format)entry.getValue());
            }
            JFileChooser chooser = new JFileChooser();
            chooser.addChoosableFileFilter(SPSUtils.HTML_FILE_FILTER);
            chooser.setFileFilter(SPSUtils.HTML_FILE_FILTER);
            int chooserResult = chooser.showSaveDialog(FancyExportableJTable.this);
            if (chooserResult == 0) {
                File file = chooser.getSelectedFile();
                try {
                    PrintWriter writer = new PrintWriter(file);
                    if (FancyExportableJTable.this.getSelectedRows().length != 0) {
                        htmlFormatter.formatToStream(FancyExportableJTable.this.getModel(), writer, FancyExportableJTable.this.getSelectedRows());
                    } else {
                        htmlFormatter.formatToStream(FancyExportableJTable.this.getModel(), writer);
                    }
                }
                catch (FileNotFoundException ex) {
                    throw new RuntimeException("Could not open file " + file.getName(), ex);
                }
            }
        }
    };
    private final Map<Integer, Format> columnFormatters = new HashMap<Integer, Format>();
    private final Action exportCSVAction = new AbstractAction("Export Selected to CSV.."){

        @Override
        public void actionPerformed(ActionEvent e) {
            TableModelCSVFormatter csvFormatter = new TableModelCSVFormatter();
            for (Map.Entry entry : FancyExportableJTable.this.columnFormatters.entrySet()) {
                csvFormatter.setFormatter((Integer)entry.getKey(), (Format)entry.getValue());
            }
            JFileChooser chooser = new JFileChooser();
            chooser.addChoosableFileFilter(SPSUtils.CSV_FILE_FILTER);
            chooser.setFileFilter(SPSUtils.CSV_FILE_FILTER);
            int chooserResult = chooser.showSaveDialog(FancyExportableJTable.this);
            if (chooserResult == 0) {
                File file = chooser.getSelectedFile();
                try {
                    PrintWriter writer = new PrintWriter(file);
                    if (FancyExportableJTable.this.getSelectedRows().length != 0) {
                        csvFormatter.formatToStream(FancyExportableJTable.this.getModel(), writer, FancyExportableJTable.this.getSelectedRows());
                    } else {
                        csvFormatter.formatToStream(FancyExportableJTable.this.getModel(), writer);
                    }
                }
                catch (FileNotFoundException ex) {
                    throw new RuntimeException("Could not open file " + file.getName(), ex);
                }
            }
        }
    };
    private TableTextConverter textConverter = new TableTextConverter(){

        @Override
        public String getTextForCell(Object cellValue) {
            if (cellValue != null) {
                return cellValue.toString();
            }
            return "";
        }

        public int modelIndex(int viewIndex) {
            return viewIndex;
        }
    };
    private TableModelSortDecorator sortDecorator;

    public FancyExportableJTable(TableModel model, Document doc) {
        this.sortDecorator = new TableModelSortDecorator(model, this.getTableHeader());
        model = this.sortDecorator;
        if (doc != null) {
            TableModelSearchDecorator newModel = new TableModelSearchDecorator(model);
            newModel.setDoc(doc);
            newModel.setTableTextConverter(this.textConverter);
            model = newModel;
        }
        this.setModel(model);
        this.addMouseListener(new PopupMenuMouseListener());
        TableUtils.fitColumnWidths(this, 15);
    }

    public FancyExportableJTable(TableModel model) {
        this(model, (Document)null);
    }

    @Override
    public void setModel(TableModel model) {
        TableModel m = this.getModel();
        if (!(m instanceof TableModelWrapper)) {
            super.setModel(model);
        } else {
            TableModelWrapper lowestWrapper = (TableModelWrapper)((Object)m);
            while (lowestWrapper.getWrappedModel() instanceof TableModelWrapper) {
                lowestWrapper = (TableModelWrapper)((Object)lowestWrapper.getWrappedModel());
            }
            lowestWrapper.setWrappedModel(model);
        }
    }

    @Override
    public void createDefaultColumnsFromModel() {
        super.createDefaultColumnsFromModel();
        TableUtils.fitColumnWidths(this, 15);
    }

    public TableModelSortDecorator getTableModelSortDecorator() {
        return this.sortDecorator;
    }

    public Action getExportHTMLAction() {
        return this.exportHTMLAction;
    }

    public Action getExportCSVAction() {
        return this.exportCSVAction;
    }

    public void setColumnFormatter(int column, Format formatter) {
        this.columnFormatters.put(column, formatter);
    }

    private class PopupMenuMouseListener
    implements MouseListener {
        private JPopupMenu menu = new JPopupMenu();

        public PopupMenuMouseListener() {
            this.menu.add(new AbstractAction("Change Font Size.."){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    final FontSelector fontSelector = new FontSelector(FancyExportableJTable.this.getFont());
                    Callable<Boolean> okCall = new Callable<Boolean>(){

                        @Override
                        public Boolean call() {
                            FancyExportableJTable.this.setFont(fontSelector.getSelectedFont());
                            TableUtils.fitColumnWidths(FancyExportableJTable.this, 15);
                            FontRenderContext frc = ((Graphics2D)FancyExportableJTable.this.getGraphics()).getFontRenderContext();
                            Rectangle2D fontBounds = fontSelector.getSelectedFont().getMaxCharBounds(frc);
                            FancyExportableJTable.this.setRowHeight((int)fontBounds.getHeight());
                            return true;
                        }
                    };
                    Callable<Boolean> cancelCall = new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return true;
                        }
                    };
                    JDialog d = DataEntryPanelBuilder.createDataEntryPanelDialog(fontSelector, FancyExportableJTable.this.getTopLevelAncestor(), "Choose a font", "OK", okCall, cancelCall);
                    d.setVisible(true);
                }
            });
            this.menu.add(FancyExportableJTable.this.exportHTMLAction);
            this.menu.add(FancyExportableJTable.this.exportCSVAction);
            this.menu.pack();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 3) {
                this.menu.show(e.getComponent(), e.getX(), e.getY());
            } else {
                this.menu.setVisible(false);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

