/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Appender;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobMap {
    private Map<String, Job> jobMap = new Hashtable<String, Job>();
    private Map<String, JobConfiguration> configurationMap = new Hashtable<String, JobConfiguration>();
    private Map<String, Appender> loggingMap = new Hashtable<String, Appender>();

    public synchronized void addJob(String jobName, Job job, JobConfiguration jobConfiguration) {
        this.jobMap.put(jobName, job);
        this.configurationMap.put(jobName, jobConfiguration);
    }

    public synchronized Job getJob(String jobName) {
        return this.jobMap.get(jobName);
    }

    public synchronized JobConfiguration getConfiguration(String jobName) {
        return this.configurationMap.get(jobName);
    }

    public synchronized void removeJob(String jobName) {
        this.jobMap.remove(jobName);
        this.configurationMap.remove(jobName);
    }

    public synchronized Appender getAppender(String jobName) {
        return this.loggingMap.get(jobName);
    }

    public synchronized void addAppender(String jobName, Appender appender) {
        this.loggingMap.put(jobName, appender);
    }

    public synchronized void removeAppender(String jobName) {
        this.loggingMap.remove(jobName);
    }

    public String[] getJobNames() {
        Set<String> keySet = this.jobMap.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public Map<String, JobConfiguration> getConfigurationMap() {
        return this.configurationMap;
    }

    public void setConfigurationMap(Map<String, JobConfiguration> configurationMap) {
        this.configurationMap = configurationMap;
    }
}

