/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pgbulkloader;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.pgbulkloader.Messages;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoader;
import org.pentaho.di.trans.steps.pgbulkloader.PGBulkLoaderData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PGBulkLoaderMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String schemaName;
    private String tableName;
    private String PsqlPath;
    private DatabaseMeta databaseMeta;
    private String[] fieldTable;
    private String[] fieldStream;
    private String[] dateMask;
    private String loadAction;
    private String dbNameOverride;
    private String delimiter;
    private String enclosure;
    public static final String ACTION_INSERT = "INSERT";
    public static final String ACTION_TRUNCATE = "TRUNCATE";
    public static final String DATE_MASK_PASS_THROUGH = "PASS THROUGH";
    public static final String DATE_MASK_DATE = "DATE";
    public static final String DATE_MASK_DATETIME = "DATETIME";
    public static final int NR_DATE_MASK_PASS_THROUGH = 0;
    public static final int NR_DATE_MASK_DATE = 1;
    public static final int NR_DATE_MASK_DATETIME = 2;

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPsqlpath() {
        return this.PsqlPath;
    }

    public void setPsqlpath(String PsqlPath) {
        this.PsqlPath = PsqlPath;
    }

    public String[] getFieldTable() {
        return this.fieldTable;
    }

    public void setFieldTable(String[] fieldTable) {
        this.fieldTable = fieldTable;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    public String[] getDateMask() {
        return this.dateMask;
    }

    public void setDateMask(String[] dateMask) {
        this.dateMask = dateMask;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrvalues) {
        this.fieldTable = new String[nrvalues];
        this.fieldStream = new String[nrvalues];
        this.dateMask = new String[nrvalues];
    }

    @Override
    public Object clone() {
        PGBulkLoaderMeta retval = (PGBulkLoaderMeta)super.clone();
        int nrvalues = this.fieldTable.length;
        retval.allocate(nrvalues);
        for (int i = 0; i < nrvalues; ++i) {
            retval.fieldTable[i] = this.fieldTable[i];
            retval.fieldStream[i] = this.fieldStream[i];
            retval.dateMask[i] = this.dateMask[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            this.enclosure = XMLHandler.getTagValue((Node)stepnode, (String)"enclosure");
            this.delimiter = XMLHandler.getTagValue((Node)stepnode, (String)"delimiter");
            this.loadAction = XMLHandler.getTagValue((Node)stepnode, (String)"load_action");
            this.PsqlPath = XMLHandler.getTagValue((Node)stepnode, (String)"PsqlPath");
            this.dbNameOverride = XMLHandler.getTagValue((Node)stepnode, (String)"dbname_override");
            int nrvalues = XMLHandler.countNodes((Node)stepnode, (String)"mapping");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                String locDateMask;
                Node vnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"mapping", (int)i);
                this.fieldTable[i] = XMLHandler.getTagValue((Node)vnode, (String)"stream_name");
                this.fieldStream[i] = XMLHandler.getTagValue((Node)vnode, (String)"field_name");
                if (this.fieldStream[i] == null) {
                    this.fieldStream[i] = this.fieldTable[i];
                }
                this.dateMask[i] = (locDateMask = XMLHandler.getTagValue((Node)vnode, (String)"date_mask")) == null ? "" : (DATE_MASK_DATE.equals(locDateMask) || DATE_MASK_PASS_THROUGH.equals(locDateMask) || DATE_MASK_DATETIME.equals(locDateMask) ? locDateMask : "");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("GPBulkLoaderMeta.Exception.UnableToReadStepInfoFromXML"), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.fieldTable = null;
        this.databaseMeta = null;
        this.schemaName = "";
        this.tableName = Messages.getString("GPBulkLoaderMeta.DefaultTableName");
        this.PsqlPath = "PsqlPath";
        this.dbNameOverride = "";
        this.delimiter = ";";
        this.enclosure = "\"";
        int nrvalues = 0;
        this.allocate(nrvalues);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"load_action", (String)this.loadAction));
        retval.append("    ").append(XMLHandler.addTagValue((String)"PsqlPath", (String)this.PsqlPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dbname_override", (String)this.dbNameOverride));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enclosure", (String)this.enclosure));
        retval.append("    ").append(XMLHandler.addTagValue((String)"delimiter", (String)this.delimiter));
        for (int i = 0; i < this.fieldTable.length; ++i) {
            retval.append("      <mapping>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.fieldTable[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_name", (String)this.fieldStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"date_mask", (String)this.dateMask[i]));
            retval.append("      </mapping>").append(Const.CR);
        }
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (long)id_connection);
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.loadAction = rep.getStepAttributeString(id_step, "load_action");
            this.PsqlPath = rep.getStepAttributeString(id_step, "PsqlPath");
            this.dbNameOverride = rep.getStepAttributeString(id_step, "dbname_override");
            int nrvalues = rep.countNrStepAttributes(id_step, "stream_name");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                this.fieldTable[i] = rep.getStepAttributeString(id_step, i, "stream_name");
                this.fieldStream[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.dateMask[i] = rep.getStepAttributeString(id_step, i, "date_mask");
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("GPBulkLoaderMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta == null ? -1.0 : (double)this.databaseMeta.getID());
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "load_action", this.loadAction);
            rep.saveStepAttribute(id_transformation, id_step, "PsqlPath", this.PsqlPath);
            rep.saveStepAttribute(id_transformation, id_step, "dbname_override", this.dbNameOverride);
            for (int i = 0; i < this.fieldTable.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "stream_name", this.fieldTable[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "date_mask", this.dateMask[i]);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getID());
            }
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("GPBulkLoaderMeta.Exception.UnableToSaveStepInfoToRepository") + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        block17: {
            String error_message = "";
            if (this.databaseMeta != null) {
                Database db = new Database(this.databaseMeta);
                db.shareVariablesWith((VariableSpace)transMeta);
                try {
                    try {
                        boolean error_found;
                        boolean first;
                        db.connect();
                        if (!Const.isEmpty((String)this.tableName)) {
                            cr = new CheckResult(1, Messages.getString("GPBulkLoaderMeta.CheckResult.TableNameOK"), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                            first = true;
                            error_found = false;
                            error_message = "";
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                            RowMetaInterface r = db.getTableFields(schemaTable);
                            if (r != null) {
                                cr = new CheckResult(1, Messages.getString("GPBulkLoaderMeta.CheckResult.TableExists"), (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                                first = true;
                                error_found = false;
                                error_message = "";
                                for (int i = 0; i < this.fieldTable.length; ++i) {
                                    String field = this.fieldTable[i];
                                    ValueMetaInterface v = r.searchValueMeta(field);
                                    if (v != null) continue;
                                    if (first) {
                                        first = false;
                                        error_message = error_message + Messages.getString("GPBulkLoaderMeta.CheckResult.MissingFieldsToLoadInTargetTable") + Const.CR;
                                    }
                                    error_found = true;
                                    error_message = error_message + "\t\t" + field + Const.CR;
                                }
                                cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("GPBulkLoaderMeta.CheckResult.AllFieldsFoundInTargetTable"), (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                            } else {
                                error_message = Messages.getString("GPBulkLoaderMeta.CheckResult.CouldNotReadTableInfo");
                                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                            }
                        }
                        if (prev != null && prev.size() > 0) {
                            cr = new CheckResult(1, Messages.getString("GPBulkLoaderMeta.CheckResult.StepReceivingDatas", prev.size() + ""), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                            first = true;
                            error_message = "";
                            error_found = false;
                            for (int i = 0; i < this.fieldStream.length; ++i) {
                                ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                                if (v != null) continue;
                                if (first) {
                                    first = false;
                                    error_message = error_message + Messages.getString("GPBulkLoaderMeta.CheckResult.MissingFieldsInInput") + Const.CR;
                                }
                                error_found = true;
                                error_message = error_message + "\t\t" + this.fieldStream[i] + Const.CR;
                            }
                            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("GPBulkLoaderMeta.CheckResult.AllFieldsFoundInInput"), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                        } else {
                            error_message = Messages.getString("GPBulkLoaderMeta.CheckResult.MissingFieldsInInput3") + Const.CR;
                            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                        }
                    }
                    catch (KettleException e) {
                        error_message = Messages.getString("GPBulkLoaderMeta.CheckResult.DatabaseErrorOccurred") + e.getMessage();
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        Object var19_21 = null;
                        db.disconnect();
                        break block17;
                    }
                    Object var19_20 = null;
                }
                catch (Throwable throwable) {
                    Object var19_22 = null;
                    db.disconnect();
                    throw throwable;
                }
                db.disconnect();
            } else {
                error_message = Messages.getString("GPBulkLoaderMeta.CheckResult.InvalidConnection");
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("GPBulkLoaderMeta.CheckResult.StepReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            return;
        }
        cr = new CheckResult(4, Messages.getString("GPBulkLoaderMeta.CheckResult.NoInputError"), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev) throws KettleStepException {
        SQLStatement retval;
        block12: {
            retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    RowMeta tableFields = new RowMeta();
                    for (int i = 0; i < this.fieldTable.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v == null) {
                            throw new KettleStepException("Unable to find field [" + this.fieldStream[i] + "] in the input rows");
                        }
                        ValueMetaInterface tableField = v.clone();
                        tableField.setName(this.fieldTable[i]);
                        tableFields.addValueMeta(tableField);
                    }
                    if (!Const.isEmpty((String)this.tableName)) {
                        Database db = new Database(this.databaseMeta);
                        db.shareVariablesWith((VariableSpace)transMeta);
                        try {
                            String sql;
                            db.connect();
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                            String cr_table = db.getDDL(schemaTable, (RowMetaInterface)tableFields, null, false, null, true);
                            String cr_index = "";
                            String[] idx_fields = null;
                            if (idx_fields != null && idx_fields.length > 0 && !db.checkIndexExists(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName), idx_fields)) {
                                String indexname = "idx_" + this.tableName + "_lookup";
                                cr_index = db.getCreateIndexStatement(schemaTable, indexname, idx_fields, false, false, false, true);
                            }
                            if ((sql = cr_table + cr_index).length() == 0) {
                                retval.setSQL(null);
                                break block12;
                            }
                            retval.setSQL(sql);
                        }
                        catch (KettleException e) {
                            retval.setError(Messages.getString("GPBulkLoaderMeta.GetSQL.ErrorOccurred") + e.getMessage());
                        }
                    } else {
                        retval.setError(Messages.getString("GPBulkLoaderMeta.GetSQL.NoTableDefinedOnConnection"));
                    }
                } else {
                    retval.setError(Messages.getString("GPBulkLoaderMeta.GetSQL.NotReceivingAnyFields"));
                }
            } else {
                retval.setError(Messages.getString("GPBulkLoaderMeta.GetSQL.NoConnectionDefined"));
            }
        }
        return retval;
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) throws KettleStepException {
        if (prev != null) {
            for (int i = 0; i < this.fieldTable.length; ++i) {
                ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                DatabaseImpact ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), transMeta.environmentSubstitute(this.tableName), this.fieldTable[i], this.fieldStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new PGBulkLoader(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new PGBulkLoaderData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        Database db;
        block5: {
            String realTableName = space.environmentSubstitute(this.tableName);
            String realSchemaName = space.environmentSubstitute(this.schemaName);
            if (this.databaseMeta == null) throw new KettleException(Messages.getString("GPBulkLoaderMeta.Exception.ConnectionNotDefined"));
            db = new Database(this.databaseMeta);
            db.connect();
            if (Const.isEmpty((String)realTableName)) throw new KettleException(Messages.getString("GPBulkLoaderMeta.Exception.TableNotSpecified"));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (!db.checkTableExists(schemaTable)) break block5;
            RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
            Object var8_8 = null;
            db.disconnect();
            return rowMetaInterface;
        }
        try {
            try {
                throw new KettleException(Messages.getString("GPBulkLoaderMeta.Exception.TableNotFound"));
            }
            catch (Exception e) {
                throw new KettleException(Messages.getString("GPBulkLoaderMeta.Exception.ErrorGettingFields"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            db.disconnect();
            throw throwable;
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setLoadAction(String action) {
        this.loadAction = action;
    }

    public String getLoadAction() {
        return this.loadAction;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public String getDbNameOverride() {
        return this.dbNameOverride;
    }

    public void setDbNameOverride(String dbNameOverride) {
        this.dbNameOverride = dbNameOverride;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }
}

