/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.parse;

import java.io.IOException;
import java.util.LinkedList;
import net.arnx.jsonic.JSONEventType;
import net.arnx.jsonic.io.InputSource;
import net.arnx.jsonic.parse.JSONParser;
import net.arnx.jsonic.util.LocalCache;

public class TraditionalParser
extends JSONParser {
    private InputSource in;
    private boolean emptyRoot = false;
    private long nameLineNumber = Long.MAX_VALUE;
    private int backupState = -1;
    private LinkedList<Token> backupTokens;

    public TraditionalParser(InputSource in, int maxDepth, boolean interpretterMode, boolean ignoreWhirespace, LocalCache cache) {
        super(in, maxDepth, interpretterMode, ignoreWhirespace, cache);
        this.in = in;
    }

    @Override
    int beforeRoot() throws IOException {
        int n = this.in.next();
        if (n == 65279) {
            n = this.in.next();
        }
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 0;
            }
            case 47: {
                this.in.back();
                String comment = this.parseComment();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.COMMENT, comment, false);
                }
                return 0;
            }
            case 123: {
                this.push(JSONEventType.START_OBJECT);
                return 2;
            }
            case 91: {
                this.push(JSONEventType.START_ARRAY);
                return 4;
            }
            case -1: {
                if (this.isInterpretterMode()) {
                    return -1;
                }
                this.emptyRoot = true;
                this.push(JSONEventType.START_OBJECT);
                return 2;
            }
            case 34: 
            case 39: {
                this.in.back();
                this.parseTokens(JSONEventType.STRING, this.parseString(true));
                return 6;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.in.back();
                this.parseTokens(JSONEventType.NUMBER, this.parseNumber());
                return 6;
            }
        }
        this.in.back();
        Object literal = this.parseLiteral(true);
        this.parseTokens(this.getParsedType(), literal);
        return 6;
    }

    @Override
    int afterRoot() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 1;
            }
            case 47: {
                this.in.back();
                String comment = this.parseComment();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.COMMENT, comment, false);
                }
                return 1;
            }
            case -1: {
                return -1;
            }
            case 44: {
                if (this.isInterpretterMode()) {
                    return 0;
                }
            }
            case 34: 
            case 39: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 91: 
            case 102: 
            case 110: 
            case 116: 
            case 123: {
                if (!this.isInterpretterMode()) break;
                this.in.back();
                return 0;
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    @Override
    int beforeName() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 2;
            }
            case 47: {
                this.in.back();
                String comment = this.parseComment();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.COMMENT, comment, false);
                }
                return 2;
            }
            case 34: 
            case 39: {
                this.in.back();
                this.set(JSONEventType.NAME, this.parseString(true), false);
                return 3;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.in.back();
                Object num = this.parseNumber();
                this.set(JSONEventType.NAME, num != null ? num.toString() : null, false);
                return 3;
            }
            case 125: {
                if (this.isFirst() && this.getBeginType() == JSONEventType.START_OBJECT) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        if (this.emptyRoot) {
                            throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                        }
                        return 1;
                    }
                    this.nameLineNumber = this.in.getLineNumber();
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case -1: {
                this.pop();
                if (this.getBeginType() == null && this.emptyRoot) {
                    return -1;
                }
                throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
            }
        }
        this.in.back();
        Object literal = this.parseLiteral(true);
        this.set(JSONEventType.NAME, literal != null ? literal.toString() : null, false);
        return 3;
    }

    @Override
    int afterName() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 3;
            }
            case 47: {
                this.in.back();
                String comment = this.parseComment();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.COMMENT, comment, false);
                }
                return 3;
            }
            case 91: 
            case 123: {
                this.in.back();
            }
            case 58: {
                return 4;
            }
            case -1: {
                throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
            }
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    @Override
    int beforeValue() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 4;
            }
            case 47: {
                this.in.back();
                String comment = this.parseComment();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.COMMENT, comment, false);
                }
                return 4;
            }
            case 123: {
                this.push(JSONEventType.START_OBJECT);
                return 2;
            }
            case 91: {
                this.push(JSONEventType.START_ARRAY);
                return 4;
            }
            case 34: 
            case 39: {
                this.in.back();
                this.set(JSONEventType.STRING, this.parseString(true), true);
                this.nameLineNumber = this.in.getLineNumber();
                return 5;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.in.back();
                this.set(JSONEventType.NUMBER, this.parseNumber(), true);
                this.nameLineNumber = this.in.getLineNumber();
                return 5;
            }
            case 44: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    this.set(JSONEventType.NULL, null, true);
                    return 2;
                }
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    this.set(JSONEventType.NULL, null, true);
                    return 4;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case 125: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    this.set(JSONEventType.NULL, null, true);
                    this.in.back();
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case 93: {
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    if (this.isFirst()) {
                        this.pop();
                        if (this.getBeginType() == null) {
                            return 1;
                        }
                        this.nameLineNumber = this.in.getLineNumber();
                        return 5;
                    }
                    this.set(JSONEventType.NULL, null, true);
                    this.in.back();
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case -1: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    this.in.back();
                    this.set(JSONEventType.NULL, null, true);
                    return 5;
                }
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    throw this.createParseException(this.in, "json.parse.ArrayNotClosedError");
                }
                throw new IllegalStateException();
            }
        }
        this.in.back();
        Object literal = this.parseLiteral(true);
        this.set(this.getParsedType(), literal, true);
        this.nameLineNumber = this.in.getLineNumber();
        return 5;
    }

    @Override
    int afterValue() throws IOException {
        int n = this.in.next();
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                this.in.back();
                String ws = this.parseWhitespace();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.WHITESPACE, ws, false);
                }
                return 5;
            }
            case 47: {
                this.in.back();
                String comment = this.parseComment();
                if (!this.isIgnoreWhitespace()) {
                    this.set(JSONEventType.COMMENT, comment, false);
                }
                return 5;
            }
            case 44: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    return 2;
                }
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    return 4;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case 125: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        if (this.emptyRoot) {
                            throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                        }
                        return 1;
                    }
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case 93: {
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    this.pop();
                    if (this.getBeginType() == null) {
                        return 1;
                    }
                    return 5;
                }
                throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
            }
            case -1: {
                if (this.getBeginType() == JSONEventType.START_OBJECT) {
                    this.pop();
                    if (this.getBeginType() == null && this.emptyRoot) {
                        return -1;
                    }
                    throw this.createParseException(this.in, "json.parse.ObjectNotClosedError");
                }
                if (this.getBeginType() == JSONEventType.START_ARRAY) {
                    throw this.createParseException(this.in, "json.parse.ArrayNotClosedError");
                }
                throw new IllegalStateException();
            }
        }
        if (this.in.getLineNumber() > this.nameLineNumber) {
            this.in.back();
            this.nameLineNumber = Long.MAX_VALUE;
            if (this.getBeginType() == JSONEventType.START_OBJECT) {
                return 2;
            }
            if (this.getBeginType() == JSONEventType.START_ARRAY) {
                return 4;
            }
            throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
        }
        throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
    }

    void parseTokens(JSONEventType type, Object value) throws IOException {
        this.backupTokens = new LinkedList();
        block8: while (true) {
            int n = this.in.next();
            switch (n) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.in.back();
                    String ws = this.parseWhitespace();
                    if (this.isIgnoreWhitespace()) continue block8;
                    this.backupTokens.add(new Token(JSONEventType.WHITESPACE, ws, false));
                    break;
                }
                case 47: {
                    this.in.back();
                    String comment = this.parseComment();
                    if (this.isIgnoreWhitespace()) continue block8;
                    this.backupTokens.add(new Token(JSONEventType.COMMENT, comment, false));
                    break;
                }
                case 91: 
                case 123: {
                    if (this.isInterpretterMode()) {
                        this.in.back();
                        this.backupState = 0;
                        break block8;
                    }
                    this.in.back();
                }
                case 58: {
                    this.emptyRoot = true;
                    this.push(JSONEventType.START_OBJECT);
                    this.backupState = 4;
                    break block8;
                }
                case -1: {
                    this.backupState = -1;
                    break block8;
                }
                case 44: {
                    if (this.isInterpretterMode()) {
                        this.backupState = 0;
                        break block8;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                }
                default: {
                    if (this.isInterpretterMode()) {
                        this.in.back();
                        this.backupState = 0;
                        break block8;
                    }
                    throw this.createParseException(this.in, "json.parse.UnexpectedChar", Character.valueOf((char)n));
                }
            }
        }
        if (this.emptyRoot) {
            if (value != null) {
                value = value.toString();
            }
            this.backupTokens.addFirst(new Token(JSONEventType.NAME, value, false));
        } else {
            this.backupTokens.addFirst(new Token(type, value, true));
        }
    }

    @Override
    int otherState() throws IOException {
        Token token = this.backupTokens.removeFirst();
        this.set(token.type, token.value, token.isValue);
        if (this.backupTokens.isEmpty()) {
            this.backupTokens = null;
            return this.backupState;
        }
        return 6;
    }

    private class Token {
        public JSONEventType type;
        public Object value;
        public boolean isValue;

        public Token(JSONEventType type, Object value, boolean isValue) {
            this.type = type;
            this.value = value;
            this.isValue = isValue;
        }
    }
}

