# Minimalist Symbol Exec example
from miasm2.core.bin_stream import bin_stream_str
from miasm2.ir.symbexec import SymbolicExecutionEngine
from miasm2.analysis.machine import Machine
from miasm2.core.asmblock import AsmSymbolPool

START_ADDR = 0
machine = Machine("x86_32")

symbol_pool = AsmSymbolPool()


# Assemble and disassemble a MOV
## Ensure that attributes 'offset' and 'l' are set
line = machine.mn.fromstring("MOV EAX, EBX", symbol_pool, 32)
asm = machine.mn.asm(line)[0]

# Get back block
bin_stream = bin_stream_str(asm)
mdis = machine.dis_engine(bin_stream, symbol_pool=symbol_pool)
mdis.lines_wd = 1
asm_block = mdis.dis_block(START_ADDR)

# Translate ASM -> IR
ira = machine.ira(mdis.symbol_pool)
ira.add_block(asm_block)

# Instanciate a Symbolic Execution engine with default value for registers
symb = SymbolicExecutionEngine(ira, {})

# Emulate one IR basic block
## Emulation of several basic blocks can be done through .emul_ir_blocks
cur_addr = symb.run_at(START_ADDR)

# Modified elements
print 'Modified registers:'
symb.dump(mems=False)
print 'Modified memory (should be empty):'
symb.dump(ids=False)

# Check final status
eax, ebx = ira.arch.regs.EAX, ira.arch.regs.EBX
assert symb.symbols[eax] == ebx
assert eax in symb.symbols
