"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var vega_util_1 = require("vega-util");
var log = require("./log");
function _normalizeAutoSize(autosize) {
    return vega_util_1.isString(autosize) ? { type: autosize } : autosize || {};
}
function normalizeAutoSize(topLevelAutosize, configAutosize, isUnitOrLayer) {
    if (isUnitOrLayer === void 0) { isUnitOrLayer = true; }
    var autosize = tslib_1.__assign({ type: 'pad' }, _normalizeAutoSize(configAutosize), _normalizeAutoSize(topLevelAutosize));
    if (autosize.type === 'fit') {
        if (!isUnitOrLayer) {
            log.warn(log.message.FIT_NON_SINGLE);
            autosize.type = 'pad';
        }
    }
    return autosize;
}
exports.normalizeAutoSize = normalizeAutoSize;
var TOP_LEVEL_PROPERTIES = [
    'background', 'padding', 'datasets'
    // We do not include "autosize" here as it is supported by only unit and layer specs and thus need to be normalized
];
function extractTopLevelProperties(t) {
    return TOP_LEVEL_PROPERTIES.reduce(function (o, p) {
        if (t && t[p] !== undefined) {
            o[p] = t[p];
        }
        return o;
    }, {});
}
exports.extractTopLevelProperties = extractTopLevelProperties;
//# sourceMappingURL=data:application/json;base64,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