"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var log = require("../../../log");
var mark_1 = require("../../../mark");
var selection_1 = require("../selection");
var VORONOI = 'voronoi';
var nearest = {
    has: function (selCmpt) {
        return selCmpt.type !== 'interval' && selCmpt.nearest;
    },
    marks: function (model, selCmpt, marks) {
        var _a = selection_1.positionalProjections(selCmpt), x = _a.x, y = _a.y;
        var markType = model.mark;
        if (mark_1.isPathMark(markType)) {
            log.warn(log.message.nearestNotSupportForContinuous(markType));
            return marks;
        }
        var cellDef = {
            name: model.getName(VORONOI),
            type: 'path',
            from: { data: model.getName('marks') },
            encode: {
                enter: {
                    fill: { value: 'transparent' },
                    strokeWidth: { value: 0.35 },
                    stroke: { value: 'transparent' },
                    isVoronoi: { value: true }
                }
            },
            transform: [{
                    type: 'voronoi',
                    x: { expr: (x || (!x && !y)) ? 'datum.datum.x || 0' : '0' },
                    y: { expr: (y || (!x && !y)) ? 'datum.datum.y || 0' : '0' },
                    size: [model.getSizeSignalRef('width'), model.getSizeSignalRef('height')]
                }]
        };
        var index = 0;
        var exists = false;
        marks.forEach(function (mark, i) {
            var name = mark.name || '';
            if (name === model.component.mark[0].name) {
                index = i;
            }
            else if (name.indexOf(VORONOI) >= 0) {
                exists = true;
            }
        });
        if (!exists) {
            marks.splice(index + 1, 0, cellDef);
        }
        return marks;
    }
};
exports.default = nearest;
//# sourceMappingURL=data:application/json;base64,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