"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var fielddef_1 = require("../../fielddef");
var util_1 = require("../../util");
var common_1 = require("../common");
exports.HEADER_CHANNELS = ['row', 'column'];
exports.HEADER_TYPES = ['header', 'footer'];
function getHeaderType(orient) {
    if (orient === 'top' || orient === 'left') {
        return 'header';
    }
    return 'footer';
}
exports.getHeaderType = getHeaderType;
function getTitleGroup(model, channel) {
    var title = model.component.layoutHeaders[channel].title;
    var textOrient = channel === 'row' ? 'vertical' : undefined;
    var update = tslib_1.__assign({ align: { value: 'center' }, text: { value: title } }, (textOrient === 'vertical' ? { angle: { value: 270 } } : {}));
    return {
        name: model.getName(channel + "_title"),
        role: channel + "-title",
        type: 'group',
        marks: [tslib_1.__assign({ type: 'text', role: channel + "-title-text", style: 'guide-title' }, (util_1.keys(update).length > 0 ? { encode: { update: update } } : {}))]
    };
}
exports.getTitleGroup = getTitleGroup;
function getHeaderGroups(model, channel) {
    var layoutHeader = model.component.layoutHeaders[channel];
    var groups = [];
    for (var _i = 0, HEADER_TYPES_1 = exports.HEADER_TYPES; _i < HEADER_TYPES_1.length; _i++) {
        var headerType = HEADER_TYPES_1[_i];
        if (layoutHeader[headerType]) {
            for (var _a = 0, _b = layoutHeader[headerType]; _a < _b.length; _a++) {
                var headerCmpt = _b[_a];
                groups.push(getHeaderGroup(model, channel, headerType, layoutHeader, headerCmpt));
            }
        }
    }
    return groups;
}
exports.getHeaderGroups = getHeaderGroups;
// 0, (0,90), 90, (90, 180), 180, (180, 270), 270, (270, 0)
function labelAlign(angle) {
    // to keep angle in [0, 360)
    angle = ((angle % 360) + 360) % 360;
    if ((angle + 90) % 180 === 0) { // for 90 and 270
        return {}; // default center
    }
    else if (angle < 90 || 270 < angle) {
        return { align: { value: 'right' } };
    }
    else if (135 <= angle && angle < 225) {
        return { align: { value: 'left' } };
    }
    return {};
}
exports.labelAlign = labelAlign;
function labelBaseline(angle) {
    // to keep angle in [0, 360)
    angle = ((angle % 360) + 360) % 360;
    if (45 <= angle && angle <= 135) {
        return { baseline: { value: 'top' } };
    }
    return {};
}
exports.labelBaseline = labelBaseline;
function getHeaderGroup(model, channel, headerType, layoutHeader, headerCmpt) {
    if (headerCmpt) {
        var title = null;
        var facetFieldDef = layoutHeader.facetFieldDef;
        if (facetFieldDef && headerCmpt.labels) {
            var _a = facetFieldDef.header, header = _a === void 0 ? {} : _a;
            var format = header.format, labelAngle = header.labelAngle;
            var update = tslib_1.__assign({}, (labelAngle !== undefined ? { angle: { value: labelAngle } } : {}), labelAlign(labelAngle), labelBaseline(labelAngle));
            title = tslib_1.__assign({ text: common_1.formatSignalRef(facetFieldDef, format, 'parent', model.config), offset: 10, orient: channel === 'row' ? 'left' : 'top', style: 'guide-label' }, (util_1.keys(update).length > 0 ? { encode: { update: update } } : {}));
        }
        var axes = headerCmpt.axes;
        var hasAxes = axes && axes.length > 0;
        if (title || hasAxes) {
            var sizeChannel = channel === 'row' ? 'height' : 'width';
            return tslib_1.__assign({ name: model.getName(channel + "_" + headerType), type: 'group', role: channel + "-" + headerType }, (layoutHeader.facetFieldDef ? {
                from: { data: model.getName(channel + '_domain') },
                sort: {
                    field: fielddef_1.vgField(facetFieldDef, { expr: 'datum' }),
                    order: facetFieldDef.sort || 'ascending'
                }
            } : {}), (title ? { title: title } : {}), (headerCmpt.sizeSignal ? {
                encode: {
                    update: (_b = {},
                        _b[sizeChannel] = headerCmpt.sizeSignal,
                        _b)
                }
            } : {}), (hasAxes ? { axes: axes } : {}));
        }
    }
    return null;
    var _b;
}
//# sourceMappingURL=data:application/json;base64,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