'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _text = require('../text');

var _icon = require('../icon');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function StatusText(_ref) {
  var width = _ref.width,
      height = _ref.height,
      text = _ref.text;

  return _react2.default.createElement(
    'div',
    { className: 'euixychart-error-nodata', style: { width: width, height: height } },
    _react2.default.createElement(
      'div',
      {
        style: {
          position: 'absolute',
          top: '50%',
          left: '50%',
          transform: 'translate(-50%, -50%)',
          color: 'rgb(53, 129, 255)'
        }
      },
      _react2.default.createElement(
        'div',
        { className: 'euiToastHeader--withBody' },
        _react2.default.createElement(_icon.EuiIcon, { className: 'euiToastHeader__icon', type: 'stats', size: 'm', 'aria-hidden': 'true' }),
        _react2.default.createElement(
          'span',
          { className: 'euiToastHeader__title' },
          'Graph not avaliable'
        )
      ),
      text && _react2.default.createElement(
        _text.EuiText,
        { size: 's' },
        text
      )
    )
  );
}

StatusText.propTypes = {
  text: _propTypes2.default.string
};

exports.default = StatusText;
StatusText.__docgenInfo = [{
  'description': '',
  'displayName': 'StatusText',
  'methods': [],
  'props': {
    'text': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    }
  }
}];
module.exports = exports['default'];