'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiEmptyPrompt = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _title = require('../title/title');

var _flex = require('../flex');

var _spacer = require('../spacer');

var _icon = require('../icon/icon');

var _text = require('../text');

var _title2 = require('../title');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var EuiEmptyPrompt = function EuiEmptyPrompt(_ref) {
  var iconType = _ref.iconType,
      iconColor = _ref.iconColor,
      title = _ref.title,
      titleSize = _ref.titleSize,
      body = _ref.body,
      actions = _ref.actions,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ['iconType', 'iconColor', 'title', 'titleSize', 'body', 'actions', 'className']);

  var classes = (0, _classnames2.default)('euiEmptyPrompt', className);

  var icon = void 0;

  if (iconType) {
    icon = _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement(_icon.EuiIcon, { type: iconType, size: 'xxl', color: iconColor }),
      _react2.default.createElement(_spacer.EuiSpacer, { size: 's' })
    );
  }

  var content = void 0;

  if (body || title) {
    var titleEl = void 0;

    if (title) {
      titleEl = _react2.default.createElement(
        _react.Fragment,
        null,
        _react2.default.createElement(
          _title2.EuiTitle,
          { size: titleSize },
          title
        ),
        _react2.default.createElement(_spacer.EuiSpacer, { size: 'm' })
      );
    }

    var bodyEl = void 0;

    if (body) {
      bodyEl = _react2.default.createElement(
        _react.Fragment,
        null,
        _react2.default.createElement(
          _text.EuiText,
          null,
          body
        ),
        _react2.default.createElement(_spacer.EuiSpacer, { size: 'l' })
      );
    }

    content = _react2.default.createElement(
      _text.EuiTextColor,
      { color: 'subdued' },
      titleEl,
      bodyEl
    );
  }

  var actionsEl = void 0;

  if (actions) {
    var actionsRow = void 0;

    if (Array.isArray(actions)) {
      actionsRow = _react2.default.createElement(
        _flex.EuiFlexGroup,
        {
          gutterSize: 'm',
          alignItems: 'center',
          justifyContent: 'center',
          direction: 'column'
        },
        actions.map(function (action, index) {
          return _react2.default.createElement(
            _flex.EuiFlexItem,
            { key: index, grow: false },
            action
          );
        })
      );
    } else {
      actionsRow = actions;
    }

    actionsEl = _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement(_spacer.EuiSpacer, { size: 's' }),
      actionsRow
    );
  }

  return _react2.default.createElement(
    'div',
    _extends({
      className: classes
    }, rest),
    icon,
    content,
    actionsEl
  );
};

exports.EuiEmptyPrompt = EuiEmptyPrompt;
EuiEmptyPrompt.propTypes = {
  iconType: _propTypes2.default.oneOf(_icon.TYPES),

  /**
   * Pass `null` to use original icon color
   */
  iconColor: _propTypes2.default.oneOf(_icon.COLORS),
  title: _propTypes2.default.node,
  titleSize: _propTypes2.default.oneOf(_title.TITLE_SIZES),
  body: _propTypes2.default.node,
  actions: _propTypes2.default.node,
  className: _propTypes2.default.string
};

EuiEmptyPrompt.defaultProps = {
  iconColor: 'subdued'
};
EuiEmptyPrompt.__docgenInfo = [{
  'description': '',
  'methods': [],
  'props': {
    'iconType': {
      'type': {
        'name': 'enum',
        'computed': true,
        'value': 'TYPES'
      },
      'required': false,
      'description': ''
    },
    'iconColor': {
      'type': {
        'name': 'enum',
        'computed': true,
        'value': 'COLORS'
      },
      'required': false,
      'description': 'Pass `null` to use original icon color',
      'defaultValue': {
        'value': '\'subdued\'',
        'computed': false
      }
    },
    'title': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': ''
    },
    'titleSize': {
      'type': {
        'name': 'enum',
        'computed': true,
        'value': 'TITLE_SIZES'
      },
      'required': false,
      'description': ''
    },
    'body': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': ''
    },
    'actions': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': ''
    },
    'className': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    }
  }
}];