'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiContextMenuItem = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _icon = require('../icon');

var _tool_tip = require('../tool_tip');

var _services = require('../../services');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EuiContextMenuItem = exports.EuiContextMenuItem = function (_Component) {
  _inherits(EuiContextMenuItem, _Component);

  function EuiContextMenuItem() {
    _classCallCheck(this, EuiContextMenuItem);

    return _possibleConstructorReturn(this, (EuiContextMenuItem.__proto__ || Object.getPrototypeOf(EuiContextMenuItem)).apply(this, arguments));
  }

  _createClass(EuiContextMenuItem, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          className = _props.className,
          hasPanel = _props.hasPanel,
          icon = _props.icon,
          buttonRef = _props.buttonRef,
          disabled = _props.disabled,
          toolTipTitle = _props.toolTipTitle,
          toolTipContent = _props.toolTipContent,
          toolTipPosition = _props.toolTipPosition,
          href = _props.href,
          target = _props.target,
          rel = _props.rel,
          rest = _objectWithoutProperties(_props, ['children', 'className', 'hasPanel', 'icon', 'buttonRef', 'disabled', 'toolTipTitle', 'toolTipContent', 'toolTipPosition', 'href', 'target', 'rel']);

      var iconInstance = void 0;

      if (icon) {
        switch (typeof icon === 'undefined' ? 'undefined' : _typeof(icon)) {
          case 'string':
            iconInstance = _react2.default.createElement(_icon.EuiIcon, {
              type: icon,
              size: 'm',
              className: 'euiContextMenu__icon'
            });
            break;

          default:
            // Assume it's already an instance of an icon.
            iconInstance = (0, _react.cloneElement)(icon, {
              className: 'euiContextMenu__icon'
            });
        }
      }

      var arrow = void 0;

      if (hasPanel) {
        arrow = _react2.default.createElement(_icon.EuiIcon, {
          type: 'arrowRight',
          size: 'm',
          className: 'euiContextMenu__arrow'
        });
      }

      var classes = (0, _classnames2.default)('euiContextMenuItem', className, {
        'euiContextMenuItem-isDisabled': disabled
      });

      var buttonInner = _react2.default.createElement(
        'span',
        { className: 'euiContextMenu__itemLayout' },
        iconInstance,
        _react2.default.createElement(
          'span',
          { className: 'euiContextMenuItem__text' },
          children
        ),
        arrow
      );

      var button = void 0;
      // <a> elements don't respect the `disabled` attribute. So if we're disabled, we'll just pretend
      // this is a button and piggyback off its disabled styles.
      if (href && !disabled) {
        var secureRel = (0, _services.getSecureRelForTarget)(target, rel);

        button = _react2.default.createElement(
          'a',
          _extends({
            className: classes,
            href: href,
            target: target,
            rel: secureRel,
            ref: buttonRef
          }, rest),
          buttonInner
        );
      } else {
        button = _react2.default.createElement(
          'button',
          _extends({
            disabled: disabled,
            className: classes,
            type: 'button',
            ref: buttonRef
          }, rest),
          buttonInner
        );
      }

      if (toolTipContent) {
        return _react2.default.createElement(
          _tool_tip.EuiToolTip,
          {
            title: toolTipTitle ? toolTipTitle : null,
            content: toolTipContent,
            anchorClassName: 'eui-displayBlock',
            position: toolTipPosition
          },
          button
        );
      } else {
        return button;
      }
    }
  }]);

  return EuiContextMenuItem;
}(_react.Component);

EuiContextMenuItem.propTypes = {
  children: _propTypes2.default.node,
  className: _propTypes2.default.string,
  /**
   * Icon used for the item
   */
  icon: _propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string]),
  onClick: _propTypes2.default.func,
  /**
   * Whether the item leads to a new set of items
   */
  hasPanel: _propTypes2.default.bool,
  buttonRef: _propTypes2.default.func,
  disabled: _propTypes2.default.bool,
  /**
   * Required if using a tooltip. Add an optional tooltip on hover
   */
  toolTipContent: _propTypes2.default.node,
  /**
   * Optional title for the tooltip
   */
  toolTipTitle: _propTypes2.default.node,
  /**
   * Dictates the position of the tooltip.
   */
  toolTipPosition: _propTypes2.default.string,
  href: _propTypes2.default.string,
  target: _propTypes2.default.string,
  rel: _propTypes2.default.string
};


EuiContextMenuItem.defaultProps = {
  toolTipPosition: 'right'
};
EuiContextMenuItem.__docgenInfo = [{
  'description': '',
  'displayName': 'EuiContextMenuItem',
  'methods': [],
  'props': {
    'children': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': ''
    },
    'className': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'icon': {
      'type': {
        'name': 'union',
        'value': [{
          'name': 'element'
        }, {
          'name': 'string'
        }]
      },
      'required': false,
      'description': 'Icon used for the item'
    },
    'onClick': {
      'type': {
        'name': 'func'
      },
      'required': false,
      'description': ''
    },
    'hasPanel': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': 'Whether the item leads to a new set of items'
    },
    'buttonRef': {
      'type': {
        'name': 'func'
      },
      'required': false,
      'description': ''
    },
    'disabled': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': ''
    },
    'toolTipContent': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': 'Required if using a tooltip. Add an optional tooltip on hover'
    },
    'toolTipTitle': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': 'Optional title for the tooltip'
    },
    'toolTipPosition': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': 'Dictates the position of the tooltip.',
      'defaultValue': {
        'value': '\'right\'',
        'computed': false
      }
    },
    'href': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'target': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'rel': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    }
  }
}];