/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Formatter;
import org.jboss.logmanager.formatters.Formatters;
import org.jboss.logmanager.handlers.UncloseableOutputStream;
import org.jboss.logmanager.handlers.UninterruptibleOutputStream;
import org.jboss.logmanager.handlers.WriterHandler;

public class OutputStreamHandler
extends WriterHandler {
    private OutputStream outputStream;

    public OutputStreamHandler() {
        this.setFormatter(Formatters.nullFormatter());
    }

    public OutputStreamHandler(Formatter formatter) {
        this.setFormatter(formatter);
    }

    public OutputStreamHandler(OutputStream outputStream, Formatter formatter) {
        this.setFormatter(formatter);
        this.setOutputStream(outputStream);
    }

    @Override
    protected void setCharsetPrivate(Charset charset) throws SecurityException {
        this.lock.lock();
        try {
            super.setCharsetPrivate(charset);
            OutputStream outputStream = this.outputStream;
            if (outputStream != null) {
                super.setWriter(this.getNewWriter(outputStream));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setWriter(Writer writer) {
        this.lock.lock();
        try {
            super.setWriter(writer);
            OutputStream oldStream = this.outputStream;
            this.outputStream = null;
            this.safeFlush(oldStream);
            this.safeClose(oldStream);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            this.setWriter(null);
            return;
        }
        OutputStreamHandler.checkAccess();
        try {
            this.lock.lock();
            try {
                OutputStream oldStream = this.outputStream;
                Writer writer = this.getNewWriter(outputStream);
                try {
                    this.outputStream = outputStream;
                    super.setWriter(writer);
                }
                finally {
                    this.safeFlush(oldStream);
                    this.safeClose(oldStream);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception e) {
            this.reportError("Error opening output stream", e, 4);
            return;
        }
    }

    OutputStream getOutputStream() {
        assert (this.lock.isHeldByCurrentThread());
        return this.outputStream;
    }

    private Writer getNewWriter(OutputStream newOutputStream) {
        if (newOutputStream == null) {
            return null;
        }
        UninterruptibleOutputStream outputStream = new UninterruptibleOutputStream(new UncloseableOutputStream(newOutputStream));
        return new OutputStreamWriter((OutputStream)outputStream, this.getCharset());
    }
}

