/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.IqView;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.util.ToStringUtil;

public abstract class AbstractIqBuilder<IB extends AbstractIqBuilder<IB>>
extends StanzaBuilder<IB>
implements IqView {
    protected IQ.Type type = IQ.Type.get;

    AbstractIqBuilder(IQ other, String stanzaId) {
        super((Stanza)other, stanzaId);
    }

    AbstractIqBuilder(AbstractIqBuilder<?> other) {
        super(other);
        this.type = other.type;
    }

    AbstractIqBuilder(StanzaIdSource stanzaIdSource) {
        super(stanzaIdSource);
    }

    AbstractIqBuilder(String stanzaId) {
        super(stanzaId);
    }

    public static IqData createResponse(IqView request) {
        return AbstractIqBuilder.createResponse(request, IQ.ResponseType.result);
    }

    public static IqData createErrorResponse(IqView request) {
        return AbstractIqBuilder.createResponse(request, IQ.ResponseType.error);
    }

    protected static IqData createResponse(IqView request, IQ.ResponseType responseType) {
        if (request.getType() != IQ.Type.get && request.getType() != IQ.Type.set) {
            throw new IllegalArgumentException("IQ request must be of type 'set' or 'get'. Original IQ: " + request);
        }
        IqData commonResponseIqData = AbstractIqBuilder.buildResponse(request, s2 -> StanzaBuilder.buildIqData(s2));
        commonResponseIqData.ofType(responseType.getType());
        return commonResponseIqData;
    }

    @Override
    protected final void addStanzaSpecificAttributes(ToStringUtil.Builder builder) {
        builder.addValue("type", (Object)this.getType());
    }

    @Override
    public final IQ.Type getType() {
        return this.type;
    }
}

