/*
 * Copyright (C) 2003-2015 FreeIPMI Core Team
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IPMI_OEM_FUJITSU_SPEC_H
#define IPMI_OEM_FUJITSU_SPEC_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Fujitsu iRMC S1 / iRMC S2
 *
 * All of the below are from
 *
 * http://manuals.ts.fujitsu.com/file/4390/irmc_s2-en.pdf
 */

/* w/ IPMI_CMD_OEM_FUJITSU_POWER */
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_POWER_ON_SOURCE    0x15
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_POWER_OFF_SOURCE   0x16
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_SET_POWER_OFF_INHIBIT  0x1C
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_POWER_OFF_INHIBIT  0x1D
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_SET_NEXT_POWER_ON_TIME 0x20

/* w/ IPMI_CMD_OEM_FUJITSU_COMMUNICATION */
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_SYSTEM_OS_SHUTDOWN_REQUEST           0x05
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_SYSTEM_OS_SHUTDOWN_REQUEST_AND_RESET 0x06
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_AGENT_CONNECT_STATUS                 0x08
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_SHUTDOWN_REQUEST_CANCELLED           0x09

/* w/ IPMI_CMD_OEM_FUJITSU_FAN_TEST */
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_WRITE_TO_SYSTEM_DISPLAY 0x02

/* w/ IPMI_CMD_OEM_FUJITSU_BIOS */
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_BIOS_POST_STATE 0x09
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_CPU_INFO        0x15

/* w/ IPMI_CMD_OEM_FUJITSU_SYSTEM */
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_SYSTEM_STATUS                          0x10
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_EEPROM_VERSION_INFO                    0x12
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_SEL_ENTRY_LONG_TEXT                    0x43
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_SEL_ENTRY_TEXT                         0x45
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_SET_IDENTIFY_LED                           0xB0
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_IDENTIFY_LED                           0xB1
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_ERROR_LED                              0xB3
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_RESET_NONVOLATILE_CFG_VARIABLES_TO_DEFAULT 0xDF
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_RESET_CONFIGSPACE_VARIABLES_TO_DEFAULT     0xE0

/* w/ IPMI_CMD_OEM_FUJITSU_GET_REMOTE_STORAGE_CONNECTION_OR_STATUS */
/* achu: making up names, not listed in documents */
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_REMOTE_STORAGE_CONNECTED 0x01
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_REMOTE_STORAGE_STATUS    0x02

/* w/ IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_POWER_ON_SOURCE */
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_SOFTWARE_OR_COMMAND                                   0x00
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_POWER_SWITCH                                          0x01
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_AUTOMATIC_RESTART_AFTER_POWER_FAILURE                 0x02
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_CLOCK_OR_TIMER                                        0x03
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_AUTOMATIC_RESTART_AFTER_FAN_FAILURE_SHUTDOWN          0x04
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_AUTOMATIC_RESTART_AFTER_CRITICAL_TEMPERATURE_SHUTDOWN 0x05
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_REBOOT_AFTER_WATCHDOG_TIMEOUT                         0x08
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_REMOTE_ON                                             0x09
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_REBOOT_AFTER_A_CPU_ERROR                              0x0C
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_REBOOT_BY_HARDWARE_RESET                              0x15
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_REBOOT_AFTER_WARM_START                               0x16
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_POWERED_ON_BY_A_PCI_BUS_POWER_MANAGEMENT_EVENT        0x1A
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_POWERED_ON_BY_REMOTE_CONTROL_VIA_REMOTE_MANAGER       0x1D
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_REBOOT_RESET_BY_REMOTE_CONTROL_VIA_REMOTE_MANAGER     0x1E

/* w/ IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_POWER_OFF_SOURCE */
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_SOFTWARE                                         0x00
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_POWER_SWITCH                                     0x01
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_AC_POWER_FAIL                                    0x02
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_CLOCK_OR_TIMER                                   0x03
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_FAN_FAILURE                                      0x04
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_CRITICAL_TEMPERATURE                             0x05
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_FINAL_POWER_OFF_AFTER_REPEATED_WATCHDOG_TIMEOUTS 0x08
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_FINAL_POWER_OFF_AFTER_REPEATED_CPU_ERRORS        0x0C
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_POWERED_OFF_BY_REMOTE_CONTROL_VIA_REMOTE_MANAGER 0x1D

/* w/ IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_SYSTEM_STATUS */
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SYSTEM_POWER_BITMASK 0x80
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SYSTEM_POWER_SHIFT   7

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SEL_ENTRIES_AVAILABLE_BITMASK  0x10
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SEL_ENTRIES_AVAILABLE_SHIFT    4

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_WATCHDOG_ACTIVE_BITMASK 0x04
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_WATCHDOG_ACTIVE_SHIFT   2

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_AGENT_CONNECTED_BITMASK 0x02
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_AGENT_CONNECTED_SHIFT   1

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_POST_STATE_BITMASK 0x01
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_POST_STATE_SHIFT   0

/* rename from "localize" */
/* Bit 7 */
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SIGNALING_LOCAL_LED_BITMASK 0x80
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SIGNALING_LOCAL_LED_SHIFT   7
/* Bit 6..4 currently undefined */

/* Bit 3..2 */
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SIGNALING_CSS_LED_BITMASK 0x0C
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SIGNALING_CSS_LED_SHIFT   2

/* Bit 1..0 */
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SIGNALING_GLOBAL_ERROR_LED_BITMASK 0x03
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SIGNALING_GLOBAL_ERROR_LED_SHIFT   0

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_SEL_MODIFIED_NEW_SEL_ENTRY_BITMASK 0x80
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_SEL_MODIFIED_NEW_SEL_ENTRY_SHIFT   7

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_SEL_MODIFIED_SEL_CLEARED_BITMASK 0x40
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_SEL_MODIFIED_SEL_CLEARED_SHIFT   6

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_SDR_MODIFIED_BITMASK  0x20
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_SDR_MODIFIED_SHIFT    5

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_NONVOLATILE_IPMI_VARIABLE_MODIFIED_BITMASK 0x10
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_NONVOLATILE_IPMI_VARIABLE_MODIFIED_SHIFT   4

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_CONFIGSPACE_MODIFIED_BITMASK 0x08
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_CONFIGSPACE_MODIFIED_SHIFT   3

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_NEW_OUTPUT_ON_LOCALVIEW_DISPLAY_BITMASK 0x01
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_NEW_OUTPUT_ON_LOCALVIEW_DISPLAY_SHIFT   0

/* achu: not defined in Fujitsu docs.  "off" is confirmed to be
 * correct, but "on" and "blink" are being gussed based on ordering of
 * error leds in LED sections.
 */
#define IPMI_OEM_FUJITSU_CSS_LED_OFF   0x0
#define IPMI_OEM_FUJITSU_CSS_LED_ON    0x1
#define IPMI_OEM_FUJITSU_CSS_LED_BLINK 0x2

/* achu: not defined in Fujitsu docs.  "off" is confirmed to be
 * correct, but "on" and "blink" are being gussed based on ordering of
 * error leds in LED sections.
 */
#define IPMI_OEM_FUJITSU_GLOBAL_ERROR_LED_OFF   0x0
#define IPMI_OEM_FUJITSU_GLOBAL_ERROR_LED_ON    0x1
#define IPMI_OEM_FUJITSU_GLOBAL_ERROR_LED_BLINK 0x2

/* w/ IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_EEPROM_VERSION_INFO */
#define IPMI_OEM_FUJITSU_EEPROM_NUMBER_MIN 0
#define IPMI_OEM_FUJITSU_EEPROM_NUMBER_MAX 1

#define IPMI_OEM_FUJITSU_EEPROM_CHECKSUM_OK    0x01
#define IPMI_OEM_FUJITSU_EEPROM_CHECKSUM_ERROR 0x00

/* w/ IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_SEL_ENTRY_LONG_TEXT */
#define IPMI_OEM_FUJITSU_SEL_ENTRY_LONG_TEXT_IRMC_S1_MAX_READ_LENGTH 32
#define IPMI_OEM_FUJITSU_SEL_ENTRY_LONG_TEXT_IRMC_S2_MAX_READ_LENGTH 100

#define IPMI_OEM_FUJITSU_SEL_ENTRY_LONG_TEXT_IRMC_S1_MAX_DATA_LENGTH 80
#define IPMI_OEM_FUJITSU_SEL_ENTRY_LONG_TEXT_IRMC_S2_MAX_DATA_LENGTH 100

#define IPMI_OEM_FUJITSU_SEL_ENTRY_LONG_TEXT_MAX_READ_LENGTH 100
#define IPMI_OEM_FUJITSU_SEL_ENTRY_LONG_TEXT_MAX_DATA_LENGTH 100

/*
 * CSS (Customer Self Service)
 *
 * If the component is marked as CSS, the customer can replace it by
 * himself without a service technican (e.g. Memory DIMM etc.)  CSS is
 * combined with the severity information.
 */
#define IPMI_OEM_FUJITSU_CSS_BITMASK      0x80
#define IPMI_OEM_FUJITSU_CSS_SHIFT        7

/*
 * Severity of a decoded event. All events should have an assigned severity.
 */
#define IPMI_OEM_FUJITSU_SEVERITY_BITMASK 0x70
#define IPMI_OEM_FUJITSU_SEVERITY_SHIFT   4

#define IPMI_OEM_FUJITSU_CSS_COMPONENT    1
#define IPMI_OEM_FUJITSU_NO_CSS_COMPONENT 0

#define IPMI_OEM_FUJITSU_SEVERITY_INFORMATIONAL 0
#define IPMI_OEM_FUJITSU_SEVERITY_MINOR         1
#define IPMI_OEM_FUJITSU_SEVERITY_MAJOR         2
#define IPMI_OEM_FUJITSU_SEVERITY_CRITICAL      3

/* w/ IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_SET_IDENTIFY_LED / IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_IDENTIFY_LED */
#define IPMI_OEM_FUJITSU_IDENTIFY_LED_ON  0x1
#define IPMI_OEM_FUJITSU_IDENTIFY_LED_OFF 0x0

#define IPMI_OEM_FUJITSU_IDENTIFY_LED_BITMASK 0x01
#define IPMI_OEM_FUJITSU_IDENTIFY_LED_SHIFT      0 

/* IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_ERROR_LED */
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_OFF_GEL_OFF     0
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_OFF_GEL_ON      1
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_OFF_GEL_BLINK   2
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_ON_GEL_OFF      3
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_ON_GEL_ON       4
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_ON_GEL_BLINK    5
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_BLINK_GEL_OFF   6
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_BLINK_GEL_ON    7
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_BLINK_GEL_BLINK 8

/* w/ IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_REMOTE_STORAGE_STATUS */
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_CONNECTION_MIN 0
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_CONNECTION_MAX 1

#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_CONNECTED     0x01
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_NOT_CONNECTED 0x00

#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_STATUS_INVALID_UNKNOWN                              0x00
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_STATUS_IDLE                                         0x01
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_STATUS_CONNECTION_ATTEMPT_PENDING                   0x02
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_STATUS_CONNECTED                                    0x03
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_STATUS_CONNECTION_ATTEMPTS_RETRIES_EXHAUSTED_FAILED 0x04
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_STATUS_CONNECTION_LOST                              0x05
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_STATUS_DISCONNECT_PENDING                           0x06

#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_TYPE_INVALID_UNKNOWN     0x00
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_TYPE_STORAGE_SERVER_IPMI 0x01
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_TYPE_APPLET              0x02
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_TYPE_NONE_NOT_CONNECTED  0x03

#ifdef __cplusplus
}
#endif

#endif /* IPMI_OEM_FUJITSU_SPEC_H */
