/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.Agilent34970A;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.VoltageReadable;

public class Agilent34970AChannel
implements VoltageReadable {
    private final Agilent34970A dvm;
    private final int channel;
    public final String name;
    private String voltageRange = "DEF";
    private String voltageResolution = "DEF";
    private String voltageNPLC = "10";
    private int lastFunction = -1;
    public static final int FUNCTION_UNDEFINED = -1;
    public static final int FUNCTION_VOLTAGE = 0;
    public static final int FUNCTION_CURRENT = 1;

    public Agilent34970AChannel(String channelName, String dvmName, int channel) {
        this.name = channelName;
        this.dvm = new Agilent34970A(dvmName);
        this.channel = channel;
    }

    public void setVoltageRange(String voltageRange) {
        this.voltageRange = voltageRange;
        if (this.lastFunction == 0) {
            this.lastFunction = -1;
        }
    }

    public String getVoltageRange() {
        return this.voltageRange;
    }

    public void setVoltageResolution(String voltageResolution) {
        this.voltageResolution = voltageResolution;
        if (this.lastFunction == 0) {
            this.lastFunction = -1;
        }
    }

    public String getVoltageResolution() {
        return this.voltageResolution;
    }

    public void setVoltageNPLC(String voltageNPLC) {
        this.voltageNPLC = voltageNPLC;
        if (this.lastFunction == 0) {
            this.lastFunction = -1;
        }
    }

    public String getVoltageNPLC() {
        return this.voltageNPLC;
    }

    public float readVoltage() {
        if (this.lastFunction != 0 || this.dvm.lastChannel != this.channel) {
            System.out.println("Configuring voltage on channel " + this.channel);
            this.dvm.write("CONF:VOLT:DC " + this.getVoltageRange() + "," + this.getVoltageResolution() + ", (@" + this.channel + ");:VOLT:DC:NPLC " + this.getVoltageNPLC() + ", (@" + this.channel + ")");
        }
        this.dvm.write("READ?");
        this.dvm.lastChannel = this.channel;
        this.lastFunction = 0;
        return this.dvm.readFloat(40);
    }

    private long timeReadVoltage() {
        long startTime = System.currentTimeMillis();
        for (int ind = 0; ind < 200; ++ind) {
            System.out.println(this.readVoltage());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("dt = " + (endTime - startTime));
        return endTime - startTime;
    }

    private void measureReadVoltageTimes() {
        System.out.println("Default 4-digit:");
        this.setVoltageResolution("MAX");
        this.setVoltageNPLC("1");
        long defaultTime = this.timeReadVoltage();
        this.setVoltageResolution("MAX");
        this.setVoltageNPLC("0.02");
        System.out.println("Fast:");
        long fastTime = this.timeReadVoltage();
        System.out.println("MAX resolution times for 200 reads, as function of NPLC:");
        System.out.println("1.00: " + defaultTime);
        System.out.println("0.02: " + fastTime);
    }

    public static void main(String[] args) {
        Infrastructure.gpibControllers = new int[]{1};
        Agilent34970AChannel channel = new Agilent34970AChannel("test", "HP34970", 101);
        Agilent34970AChannel channel2 = new Agilent34970AChannel("test2", "HP34970", 102);
        System.out.println(channel.name + ": " + channel.readVoltage());
        System.out.println(channel2.name + ": " + channel2.readVoltage());
        channel2.measureReadVoltageTimes();
    }
}

