/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpVisitor;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.InlineCalls;
import gnu.expr.Language;
import gnu.expr.PrimProcedure;
import gnu.expr.ReferenceExp;
import gnu.expr.Special;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.util.IdentityHashTable;
import gnu.lists.AbstractFormat;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.mapping.WrongArguments;
import gnu.text.SourceLocator;

public class QuoteExp
extends Expression {
    Object value;
    public static final int EXPLICITLY_TYPED = 2;
    public static final int SHARED_CONSTANT = 4;
    protected Type type;
    public static QuoteExp undefined_exp = QuoteExp.makeShared(Special.undefined);
    public static QuoteExp abstractExp = QuoteExp.makeShared(Special.abstractSpecial);
    public static QuoteExp voidExp = QuoteExp.makeShared(Values.empty, Type.voidType);
    public static QuoteExp trueExp = QuoteExp.makeShared(Boolean.TRUE);
    public static QuoteExp falseExp = QuoteExp.makeShared(Boolean.FALSE);
    public static QuoteExp nullExp = QuoteExp.makeShared(null, Type.nullType);
    public static final QuoteExp classObjectExp = QuoteExp.makeShared(Type.objectType);

    public final Object getValue() {
        return this.value;
    }

    @Override
    public final Object valueIfConstant() {
        return this.value;
    }

    public final Type getRawType() {
        return this.type;
    }

    @Override
    public final Type getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.value == Values.empty) {
            return Type.voidType;
        }
        if (this.value == null) {
            return Type.nullType;
        }
        if (this == undefined_exp) {
            return Type.pointer_type;
        }
        return Type.make(this.value.getClass());
    }

    public void setType(Type type) {
        this.type = type;
        this.setFlag(2);
    }

    public boolean isExplicitlyTyped() {
        return this.getFlag(2);
    }

    public boolean isSharedConstant() {
        return this.getFlag(4);
    }

    public static QuoteExp getInstance(Object value) {
        return QuoteExp.getInstance(value, null);
    }

    public static QuoteExp getInstance(Object value, SourceLocator position) {
        if (value == null) {
            return nullExp;
        }
        if (value == Type.pointer_type) {
            return classObjectExp;
        }
        if (value == Special.undefined) {
            return undefined_exp;
        }
        if (value == Values.empty) {
            return voidExp;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? trueExp : falseExp;
        }
        QuoteExp q = new QuoteExp(value);
        if (position != null) {
            q.setLocation(position);
        }
        return q;
    }

    static QuoteExp makeShared(Object value) {
        QuoteExp exp = new QuoteExp(value);
        exp.setFlag(4);
        return exp;
    }

    static QuoteExp makeShared(Object value, Type type) {
        QuoteExp exp = new QuoteExp(value, type);
        exp.setFlag(4);
        return exp;
    }

    public QuoteExp(Object val) {
        this.value = val;
    }

    public QuoteExp(Object val, Type type) {
        this.value = val;
        this.setType(type);
    }

    @Override
    protected boolean mustCompile() {
        return false;
    }

    @Override
    public void apply(CallContext ctx) {
        ctx.writeValue(this.value);
    }

    @Override
    public void compile(Compilation comp, Target target) {
        if (this.type == null || this.type == Type.pointer_type || target instanceof IgnoreTarget || this.type instanceof ObjectType && this.type.isInstance(this.value)) {
            comp.compileConstant(this.value, target);
        } else {
            comp.compileConstant(this.value, StackTarget.getInstance(this.type));
            target.compileFromStack(comp, this.type);
        }
    }

    @Override
    public Expression deepCopy(IdentityHashTable mapper) {
        return this;
    }

    @Override
    protected <R, D> R visit(ExpVisitor<R, D> visitor, D d) {
        return visitor.visitQuoteExp(this, d);
    }

    @Override
    public Expression validateApply(ApplyExp exp, InlineCalls visitor, Type required, Declaration decl) {
        Expression e;
        if (this == undefined_exp) {
            return exp;
        }
        Object fval = this.getValue();
        if (!(fval instanceof Procedure)) {
            return visitor.noteError(decl == null || fval == null ? "called value is not a procedure" : "calling " + decl.getName() + " which is a " + fval.getClass().getName());
        }
        Procedure proc = (Procedure)fval;
        int nargs = exp.getArgCount();
        String msg = WrongArguments.checkArgCount(proc, nargs);
        if (msg != null) {
            return visitor.noteError(msg);
        }
        Expression inlined = visitor.maybeInline(exp, required, proc);
        if (inlined != null) {
            return inlined;
        }
        Expression[] args = exp.args;
        MethodProc asMProc = proc instanceof MethodProc ? (MethodProc)proc : null;
        for (int i = 0; i < nargs; ++i) {
            Type ptype;
            Type type = ptype = asMProc != null ? asMProc.getParameterType(i) : null;
            if (i == nargs - 1 && ptype != null && asMProc.maxArgs() < 0 && i == asMProc.minArgs()) {
                ptype = null;
            }
            args[i] = visitor.visit(args[i], ptype);
        }
        if (exp.getFlag(4) && (e = exp.inlineIfConstant(proc, visitor)) != exp) {
            return visitor.visit(e, required);
        }
        Compilation comp = visitor.getCompilation();
        if (comp.inlineOk(proc)) {
            if (ApplyExp.asInlineable(proc) != null) {
                if (exp.getFunction() == this) {
                    return exp;
                }
                return new ApplyExp(this, exp.getArgs()).setLine(exp);
            }
            PrimProcedure mproc = PrimProcedure.getMethodFor(proc, decl, exp.args, comp.getLanguage());
            if (mproc != null) {
                ApplyExp nexp;
                if (mproc.getStaticFlag() || decl == null) {
                    nexp = new ApplyExp(mproc, exp.args);
                } else {
                    if (decl.base == null) {
                        return exp;
                    }
                    Expression[] margs = new Expression[1 + nargs];
                    System.arraycopy(exp.getArgs(), 0, margs, 1, nargs);
                    margs[0] = new ReferenceExp(decl.base);
                    nexp = new ApplyExp(mproc, margs);
                }
                return nexp.setLine(exp);
            }
        }
        return exp;
    }

    @Override
    public boolean side_effects() {
        return false;
    }

    @Override
    public String toString() {
        return "QuoteExp[" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(OutPort out) {
        out.startLogicalBlock("(Quote", ")", 2);
        out.writeSpaceLinear();
        Object val = this.value;
        if (val instanceof Expression) {
            val = val.toString();
        }
        AbstractFormat saveFormat = out.objectFormat;
        try {
            out.objectFormat = Language.getDefaultLanguage().getFormat(true);
            out.print(val);
            if (this.type != null) {
                out.print(" ::");
                out.print(this.type.getName());
            }
        }
        finally {
            out.objectFormat = saveFormat;
        }
        out.endLogicalBlock(")");
    }
}

