/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
static const char RCSID[]="$Id: menus-athena.c,v 1.3 2003/08/04 02:10:48 jmd Exp $";


#include <malloc.h>
#include <stdio.h>
#include <assert.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>


#include "menus.h"


/* used just to detect memory leaks */
int heap_bytes=0;

void placeMenu(Widget w, XtPointer clientData, XtPointer callData);
void killWindow(Widget w, XtPointer clientData, XtPointer callData);

/* release the memory associated with a menu */
void
destroyMenu(Menu p)
{
  int n=0;
  Menu s = p;
  
  while (*p){
    ++n;
    free(*p);

    heap_bytes -= sizeof(struct MenuParameters);
    ++p;
  }
  free(s); 
  
  heap_bytes -= (n+1)*sizeof(struct MenuParameters*);
  
}

Menu
createMenu(Widget shell, Widget launch, struct MenuDef* menuItems, int itemQty)
{
  Widget  menubox;
  int i;

  MenuWidgetData menu ;
  struct MenuParameters *mp;

  struct MenuParameters **parameterPointers;

  char widgetname[80];
  char transTable[80];

  sprintf(widgetname,"%s-menu",XtName(launch));
  sprintf(transTable,"<BtnDown>: XtMenuPopup(%s)",widgetname);

  XtVaSetValues(launch,
		XtNtranslations, XtParseTranslationTable(transTable),
		NULL);
  menu.parent = XtCreatePopupShell(widgetname,
				   transientShellWidgetClass,
				   shell,
				   NULL,0);


  menubox = XtCreateManagedWidget("menubox",
				  boxWidgetClass,
				  menu.parent,
				  NULL,0);

  menu.caller = launch;


  /* create an array of structuctures to hold menu parameters */
  parameterPointers = (struct MenuParameters**) 
    malloc((itemQty+1) * sizeof(struct MenuParameters*));
  if ( !parameterPointers){
    perror("Can't allocate memory");
    return 0;
  }
  heap_bytes+=(itemQty+1) * sizeof(struct MenuParameters*);

  /*  create a button for each item in the menu */
  for(i=0; i< itemQty ; ++i)    {
    Widget w;

    mp = (struct MenuParameters*) malloc(sizeof(struct MenuParameters));
    if ( !mp){
      perror("Can't allocate memory");
      return 0 ;
    }
    heap_bytes+=sizeof(*mp);
    parameterPointers[i]=mp;
    

    mp->widgets = menu;

    mp->definition = menuItems[i];

    w = XtVaCreateManagedWidget(menuItems[i].name,
				commandWidgetClass,
				menubox,
				NULL
				);

    if (menuItems[i].callback) {
      XtAddCallback(w, XtNcallback,menuItems[i].callback,mp);
    }
    
  }
  parameterPointers[i]=0;

  XtAddCallback(menu.parent, XtNpopupCallback,placeMenu,mp);

  return parameterPointers;
}


/* position a popup shell just to the left of the mouse cursor */
void
placeMenu(Widget w, XtPointer clientData, XtPointer callData)
{
  Position x,y;
  Dimension height;

  MenuWidgetData *widgetData = (MenuWidgetData*) clientData;
  
  assert(widgetData);

  XtTranslateCoords(widgetData->caller,0,0,&x,&y);
  
  XtVaGetValues(widgetData->caller,
		XtNheight,&height,
		NULL);

  XtVaSetValues(widgetData->parent,
		XtNx, x-1,
		XtNy, y+height,
		NULL);
}
		

extern Widget main_application_window;

/* show the a message box at the pointer position 
    clientData must be the MenuParameter structure associated with the
    menu it was called from */
void 
showBox(Widget w, XtPointer clientData, XtPointer callData)
{

  struct MenuParameters *mp = (struct MenuParameters *) clientData;
  Widget textbox, form, button;
  Widget pshell;

  static MenuWidgetData widgets;


  struct MessageBoxData defaultData = {100,50,""};
  struct MessageBoxData  *msgBoxData;
  


  widgets.caller = w;

  /* we must be passed something */
  assert(mp);

  msgBoxData = (mp->definition).clientData;

  if (!msgBoxData)
    msgBoxData = &defaultData;

  
  /* create a new popup shell */
  pshell= XtCreatePopupShell("pshell",
			     transientShellWidgetClass,
			     main_application_window,
			     NULL,0);

  widgets.parent = pshell;  

  form = XtVaCreateManagedWidget(
				 "form",
				 formWidgetClass,
				 pshell,
				 NULL);


  textbox = XtVaCreateManagedWidget("menubox",
				    asciiTextWidgetClass,
				    form,
				    XtNstring, msgBoxData->message,
				    XtNheight,msgBoxData->height,
				    XtNwidth, msgBoxData->width,
				    NULL);

  button = XtVaCreateManagedWidget(
				   "ok",
				   commandWidgetClass,
				   form,
				   NULL);

  XtVaSetValues(button,
		XtNfromHoriz, (XtArgVal) NULL ,
		XtNfromVert, (XtArgVal) NULL,
     		XtNtop, XtChainBottom,
		XtNbottom, XtChainBottom ,
		XtNleft, XtChainLeft ,
		XtNright, XtChainLeft,
		NULL);



  XtVaSetValues(textbox,
		XtNfromHoriz, (XtArgVal) NULL ,
		XtNfromVert, button,
     		XtNtop, XtChainTop,
		XtNbottom, XtChainBottom ,
		XtNleft, XtChainLeft ,
		XtNright, XtChainRight,
		NULL);



  XtAddCallback(button, XtNcallback, killWindow, pshell);
  XtAddCallback(pshell, XtNpopupCallback,placeMenu,&widgets);


  XtPopup(pshell,XtGrabNone);

  /* remove the pulldown menu which called this message box */
  XtPopdown((mp->widgets).parent);
}

void
popDown(Widget w, XtPointer clientData, XtPointer callData)
{
  MenuWidgetData *widgetData = (MenuWidgetData *) clientData;
  XtPopdown(widgetData->parent);
}


void
killWindow(Widget w, XtPointer clientData, XtPointer callData)
{
  XtPopdown((Widget)clientData);
}

