/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.acl2;

import com.sun.electric.util.acl2.Rational;
import java.math.BigInteger;

class Complex {
    final Rational re;
    final Rational im;

    Complex(Rational re, Rational im) {
        this.re = re;
        this.im = im;
    }

    int signum() {
        int rsig = this.re.signum();
        return rsig != 0 ? rsig : this.im.signum();
    }

    boolean isRational() {
        return this.im.signum() == 0;
    }

    Complex negate() {
        return new Complex(this.re.negate(), this.im.negate());
    }

    Complex inverse() {
        Rational sqrInv = this.re.mul(this.re).add(this.im.mul(this.im)).inverse();
        return new Complex(this.re.mul(sqrInv), this.im.negate().mul(sqrInv));
    }

    Complex add(Complex y) {
        return new Complex(this.re.add(y.re), this.im.add(y.im));
    }

    Complex add(Rational y) {
        return new Complex(this.re.add(y), this.im);
    }

    Complex add(BigInteger y) {
        return new Complex(this.re.add(y), this.im);
    }

    Complex mul(Complex y) {
        Rational zre = this.re.mul(y.re).add(this.im.mul(y.im).negate());
        Rational zim = this.re.mul(y.im).add(this.im.mul(y.re));
        return new Complex(zre, zim);
    }

    Complex mul(Rational y) {
        Rational zre = this.re.mul(y);
        Rational zim = this.im.mul(y);
        return new Complex(zre, zim);
    }

    Complex mul(BigInteger y) {
        Rational zre = this.re.mul(y);
        Rational zim = this.im.mul(y);
        return new Complex(zre, zim);
    }

    public boolean equals(Object o) {
        return o instanceof Complex && this.re.equals(((Complex)o).re) && this.im.equals(((Complex)o).im);
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + this.re.hashCode();
        hash = 59 * hash + this.im.hashCode();
        return hash;
    }

    public String toString() {
        return "#c(" + this.re + "," + this.im + ")";
    }

    int compareTo(Complex y) {
        int resig = this.re.compareTo(y.re);
        return resig != 0 ? resig : this.im.compareTo(y.im);
    }

    int compareTo(Rational y) {
        int resig = this.re.compareTo(y);
        return resig != 0 ? resig : this.im.signum();
    }

    int compareTo(BigInteger y) {
        int resig = this.re.compareTo(y);
        return resig != 0 ? resig : this.im.signum();
    }
}

