/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.MutableInteger;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HighlightConnectivity {
    private Cell cell;
    private List<ConnectingLayer> allConnectingLayers;
    private List<ConnectingVia> allConnectingVias;
    private Map<Layer, Layer> removeLayers;
    private String[] topology;
    public static final Variable.Key TOPOLOGY_QUICK_DATA = Variable.newKey("USER_topology_quick");
    public static final Variable.Key TOPOLOGY_QUICK_DATE = Variable.newKey("USER_topology_quick_date");
    Map<Integer, List<MutableInteger>> netIDsByValue = new HashMap<Integer, List<MutableInteger>>();

    public HighlightConnectivity(Cell cell) {
        Long t;
        Object topologyDate;
        Variable varDate;
        this.cell = cell;
        Variable varData = cell.getVar(TOPOLOGY_QUICK_DATA);
        if (varData != null && (varDate = cell.getVar(TOPOLOGY_QUICK_DATE)) != null && ((Date)(topologyDate = new Date(t = (Long)varDate.getObject()))).after(cell.getRevisionDate())) {
            this.topology = (String[])varData.getObject();
            return;
        }
        this.initializeDesignRules();
        this.buildRTrees();
        this.extractRTrees();
        ERectangle limit = cell.getBounds();
        HashMap<Integer, StringBuffer> geomsOnNet = new HashMap<Integer, StringBuffer>();
        for (ConnectingLayer cl : this.allConnectingLayers) {
            Iterator<QCBound> sea = cl.tree.search(limit);
            while (sea.hasNext()) {
                QCBound sBound = sea.next();
                Geometric geom = sBound.getTopGeom();
                if (geom == null) continue;
                int thisNet = 0;
                if (sBound.getNetID() != null && sBound.getNetID().intValue() != 0) {
                    thisNet = sBound.getNetID().intValue();
                }
                if (thisNet == 0) continue;
                Integer thisNetInt = thisNet;
                StringBuffer sb = (StringBuffer)geomsOnNet.get(thisNetInt);
                if (sb == null) {
                    sb = new StringBuffer();
                    geomsOnNet.put(thisNetInt, sb);
                }
                if (sb.length() != 0) {
                    sb.append("/");
                }
                if (geom instanceof NodeInst) {
                    NodeInst ni = (NodeInst)geom;
                    sb.append("N" + ni.getName());
                } else {
                    ArcInst ai = (ArcInst)geom;
                    sb.append("A" + ai.getName());
                }
                ERectangle geomRect = geom.getBounds();
                ERectangle rTreeRect = sBound.getBounds();
                if (geomRect.equals(sBound.getBounds())) continue;
                sb.append("[" + rTreeRect.getMinX() + ";" + rTreeRect.getMinY() + ";" + rTreeRect.getWidth() + ";" + rTreeRect.getHeight() + "]");
            }
        }
        int numNets = geomsOnNet.size();
        this.topology = new String[numNets];
        int netNum = 0;
        for (Integer key : geomsOnNet.keySet()) {
            StringBuffer sb = (StringBuffer)geomsOnNet.get(key);
            this.topology[netNum++] = sb.toString();
        }
        new StoreTopology(cell, this.topology);
    }

    public String[] getTopology() {
        return this.topology;
    }

    private void buildRTrees() {
        HashMap<Layer, List<Rectangle2D>> removeGeometry = new HashMap<Layer, List<Rectangle2D>>();
        ArrayList<EPoint> linesInNonMahnattan = new ArrayList<EPoint>();
        boolean nonMan = this.addArea(this.cell, true, Orientation.IDENT.pureRotate(), linesInNonMahnattan, removeGeometry);
        if (nonMan) {
            System.out.println("Non-Manhattan geometry found");
        }
        for (Layer cutLayer : removeGeometry.keySet()) {
            Layer primaryLayer = this.removeLayers.get(cutLayer);
            List removeRects = (List)removeGeometry.get(cutLayer);
            ConnectingLayer thisCL = null;
            for (ConnectingLayer cl : this.allConnectingLayers) {
                if (!cl.layers.contains(primaryLayer)) continue;
                thisCL = cl;
                break;
            }
            if (thisCL == null) continue;
            GeometryTree bTree = thisCL.tree;
            for (Rectangle2D rect : removeRects) {
                ArrayList<QCBound> thingsThatGetRemoved = new ArrayList<QCBound>();
                Iterator<QCBound> sea = bTree.search(rect);
                while (sea.hasNext()) {
                    QCBound sBound = sea.next();
                    ERectangle bound = sBound.getBounds();
                    if (((RectangularShape)bound).getMaxX() <= rect.getMinX() || ((RectangularShape)bound).getMinX() >= rect.getMaxX() || ((RectangularShape)bound).getMaxY() <= rect.getMinY() || ((RectangularShape)bound).getMinY() >= rect.getMaxY()) continue;
                    thingsThatGetRemoved.add(sBound);
                }
                RTNode<QCBound> rootFixp = bTree.getRoot();
                for (QCBound s : thingsThatGetRemoved) {
                    RTNode<QCBound> newRootFixp = RTNode.unLinkGeom(null, rootFixp, s);
                    if (newRootFixp == rootFixp) continue;
                    rootFixp = newRootFixp;
                    bTree.setRoot(rootFixp);
                }
                for (QCBound s : thingsThatGetRemoved) {
                    PolyMerge merge = new PolyMerge();
                    merge.addRectangle(cutLayer, s.getBounds());
                    merge.subtract(cutLayer, new Poly(rect));
                    List<PolyBase> remaining = merge.getMergedPoints(cutLayer, true);
                    for (PolyBase pb : remaining) {
                        ERectangle reducedBound = ERectangle.fromLambda(pb.getBounds2D());
                        QCBound qcb = new QCBound(reducedBound, s.getNetID(), s.getTopGeom());
                        RTNode<QCBound> newRootFixp = RTNode.linkGeom(null, rootFixp, qcb);
                        if (newRootFixp == rootFixp) continue;
                        rootFixp = newRootFixp;
                        bTree.setRoot(rootFixp);
                    }
                }
            }
        }
    }

    private boolean addArea(Cell cell, boolean topLevel, FixpTransform transToTop, List<EPoint> linesInNonMahnattan, Map<Layer, List<Rectangle2D>> removeGeometry) {
        boolean hasNonmanhattan = false;
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.isCellInstance()) {
                FixpTransform transBack = ni.transformOut(transToTop);
                this.addArea((Cell)ni.getProto(), false, transBack, linesInNonMahnattan, removeGeometry);
                continue;
            }
            PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
            if (pNp.getFunction() == PrimitiveNode.Function.PIN) continue;
            FixpTransform nodeTrans = ni.rotateOut(transToTop);
            Technology tech = pNp.getTechnology();
            Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, true, false, null);
            for (int i = 0; i < nodeInstPolyList.length; ++i) {
                Poly poly = nodeInstPolyList[i];
                if (!this.addLayer(poly, topLevel ? ni : null, nodeTrans, linesInNonMahnattan, removeGeometry)) continue;
                hasNonmanhattan = true;
            }
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                if (!this.addLayer(poly, topLevel ? ai : null, transToTop, linesInNonMahnattan, removeGeometry)) continue;
                hasNonmanhattan = true;
            }
        }
        return hasNonmanhattan;
    }

    private boolean addLayer(PolyBase poly, Geometric topGeom, FixpTransform trans, List<EPoint> linesInNonMahnattan, Map<Layer, List<Rectangle2D>> removeGeometry) {
        FixpRectangle bounds;
        boolean isNonmanhattan = false;
        Layer layer = poly.getLayer();
        Layer removeLay = this.removeLayers.get(layer);
        if (removeLay != null) {
            List<Rectangle2D> geomsToRemove = removeGeometry.get(layer);
            if (geomsToRemove == null) {
                geomsToRemove = new ArrayList<Rectangle2D>();
                removeGeometry.put(layer, geomsToRemove);
            }
            poly.transform(trans);
            FixpRectangle bounds2 = poly.getBox();
            if (bounds2 == null) {
                return true;
            }
            geomsToRemove.add(bounds2);
            return false;
        }
        for (ConnectingLayer cl : this.allConnectingLayers) {
            if (!cl.layers.contains(layer)) continue;
            if (poly.getStyle() != Poly.Type.FILLED) {
                return false;
            }
            poly.transform(trans);
            bounds = poly.getBox();
            if (bounds == null) {
                this.addPolygon(poly, cl, topGeom);
                PolyBase.Point[] points = poly.getPoints();
                for (int i = 1; i < points.length; ++i) {
                    if (points[i - 1].getX() == points[i].getX() || points[i - 1].getY() == points[i].getY()) continue;
                    isNonmanhattan = true;
                    linesInNonMahnattan.add(EPoint.fromLambda(points[i - 1].getX(), points[i - 1].getY()));
                    linesInNonMahnattan.add(EPoint.fromLambda(points[i].getX(), points[i].getY()));
                }
                continue;
            }
            this.addRectangle(bounds, cl, topGeom);
        }
        for (ConnectingVia cv : this.allConnectingVias) {
            if (layer != cv.viaLayer) continue;
            bounds = poly.getBounds2D();
            DBMath.transformRect((Rectangle2D)bounds, trans);
            this.addVia(ERectangle.fromLambda(bounds), cv);
        }
        return isNonmanhattan;
    }

    private QCBound addRectangle(Rectangle2D bounds, ConnectingLayer cl, Geometric topGeom) {
        RTNode<QCBound> newRootFixp;
        RTNode<QCBound> rootFixp;
        QCBound qcb = null;
        GeometryTree bTree = cl.tree;
        ArrayList<Object> removeThese = null;
        Iterator<QCBound> sea = bTree.search(bounds);
        while (sea.hasNext()) {
            QCBound sBound = sea.next();
            if (sBound instanceof QCPoly) continue;
            ERectangle eRectangle = sBound.getBounds();
            if (eRectangle.getMinX() <= bounds.getMinX() && eRectangle.getMaxX() >= bounds.getMaxX() && eRectangle.getMinY() <= bounds.getMinY() && eRectangle.getMaxY() >= bounds.getMaxY()) {
                return null;
            }
            if (!(bounds.getMinX() <= eRectangle.getMinX()) || !(bounds.getMaxX() >= eRectangle.getMaxX()) || !(bounds.getMinY() <= eRectangle.getMinY()) || !(bounds.getMaxY() >= eRectangle.getMaxY())) continue;
            if (removeThese == null) {
                removeThese = new ArrayList<Object>();
            }
            removeThese.add(sBound);
        }
        if (removeThese != null) {
            rootFixp = bTree.getRoot();
            for (QCBound qCBound : removeThese) {
                RTNode<QCBound> newRootFixp2 = RTNode.unLinkGeom(null, rootFixp, qCBound);
                if (newRootFixp2 == rootFixp) continue;
                rootFixp = newRootFixp2;
                bTree.setRoot(rootFixp);
            }
        }
        qcb = new QCBound(ERectangle.fromLambda(bounds), null, topGeom);
        rootFixp = bTree.getRoot();
        if (rootFixp == null) {
            rootFixp = RTNode.makeTopLevel();
            bTree.setRoot(rootFixp);
        }
        if ((newRootFixp = RTNode.linkGeom(null, rootFixp, qcb)) != rootFixp) {
            bTree.setRoot(newRootFixp);
        }
        return qcb;
    }

    private void addPolygon(PolyBase poly, ConnectingLayer cl, Geometric topGeom) {
        RTNode<QCBound> newRootFixp;
        GeometryTree bTree = cl.tree;
        QCPoly qcb = new QCPoly(ERectangle.fromLambda(poly.getBounds2D()), null, poly, topGeom);
        RTNode<QCBound> rootFixp = bTree.getRoot();
        if (rootFixp == null) {
            rootFixp = RTNode.makeTopLevel();
            bTree.setRoot(rootFixp);
        }
        if ((newRootFixp = RTNode.linkGeom(null, rootFixp, qcb)) != rootFixp) {
            bTree.setRoot(newRootFixp);
        }
    }

    private void addVia(ERectangle rect, ConnectingVia cv) {
        RTNode<QCBound> newRootFixp;
        GeometryTree bTree = cv.tree;
        Iterator<QCBound> it = bTree.search(rect);
        while (it.hasNext()) {
            QCBound qcb = it.next();
            if (qcb.getBounds().getCenterX() != rect.getCenterX() || qcb.getBounds().getCenterY() != rect.getCenterY()) continue;
            return;
        }
        QCVia qcb = new QCVia(rect, null);
        RTNode<QCBound> rootFixp = bTree.getRoot();
        if (rootFixp == null) {
            rootFixp = RTNode.makeTopLevel();
            bTree.setRoot(rootFixp);
        }
        if ((newRootFixp = RTNode.linkGeom(null, rootFixp, qcb)) != rootFixp) {
            bTree.setRoot(newRootFixp);
        }
    }

    private void extractRTrees() {
        int netID = 1;
        for (ConnectingLayer cl : this.allConnectingLayers) {
            Iterator<QCBound> sea = cl.tree.search(this.cell.getBounds());
            while (sea.hasNext()) {
                QCBound sBound = sea.next();
                if (sBound.getNetID() != null) continue;
                MutableInteger mi = new MutableInteger(netID++);
                sBound.setNetID(mi);
                this.growArea(sBound, cl, sBound.getNetID());
            }
        }
    }

    private void growArea(QCBound sBound, ConnectingLayer cl, MutableInteger idNumber) {
        GeometryTree metalTree = cl.tree;
        ERectangle bound = sBound.getBounds();
        Iterator<QCBound> sea = metalTree.search(bound);
        while (sea.hasNext()) {
            QCBound subBound = sea.next();
            if (subBound == sBound || (sBound instanceof QCPoly || subBound instanceof QCPoly) && !this.doesIntersect(sBound, subBound)) continue;
            if (subBound.getNetID() == null) {
                subBound.setNetID(idNumber);
                this.growArea(subBound, cl, idNumber);
                continue;
            }
            subBound.updateNetID(idNumber, this.netIDsByValue);
        }
        for (ConnectingVia cv : this.allConnectingVias) {
            ConnectingLayer otherLayer;
            if (cl != cv.layer1 && cl != cv.layer2) continue;
            ConnectingLayer connectingLayer = otherLayer = cl == cv.layer1 ? cv.layer2 : cv.layer1;
            GeometryTree viaTree = cv.tree;
            if (viaTree.isEmpty()) continue;
            Iterator<QCBound> sea2 = viaTree.search(bound);
            while (sea2.hasNext()) {
                QCVia subBound = (QCVia)sea2.next();
                if (sBound instanceof QCPoly && !this.doesIntersect(sBound, subBound)) continue;
                if (subBound.getNetID() == null) {
                    subBound.setNetID(idNumber);
                    this.growPoint(subBound.getBounds().getCenterX(), subBound.getBounds().getCenterY(), otherLayer, idNumber);
                    continue;
                }
                subBound.updateNetID(idNumber, this.netIDsByValue);
            }
        }
    }

    private boolean growPoint(double x, double y, ConnectingLayer layer, MutableInteger idNumber) {
        Rectangle2D.Double search = new Rectangle2D.Double(x, y, 0.0, 0.0);
        GeometryTree bTree = layer.tree;
        if (bTree.isEmpty()) {
            return false;
        }
        boolean foundNet = false;
        Iterator<QCBound> sea = bTree.search(search);
        while (sea.hasNext()) {
            QCBound subBound = sea.next();
            if (!subBound.containsPoint(x, y)) continue;
            if (subBound.getNetID() == null) {
                subBound.setNetID(idNumber);
                this.growArea(subBound, layer, idNumber);
                continue;
            }
            if (subBound.isSameBasicNet(idNumber)) continue;
            subBound.updateNetID(idNumber, this.netIDsByValue);
        }
        return foundNet;
    }

    private boolean doesIntersect(QCBound bound1, QCBound bound2) {
        EPoint[] points2;
        EPoint[] points1;
        if (!bound1.isManhattan() || !bound2.isManhattan()) {
            return true;
        }
        if (bound1 instanceof QCPoly) {
            QCPoly p = (QCPoly)bound1;
            PolyBase.Point[] po = p.poly.getPoints();
            points1 = new EPoint[po.length];
            for (int i = 0; i < po.length; ++i) {
                points1[i] = EPoint.fromLambda(po[i].getX(), po[i].getY());
            }
        } else {
            points1 = new EPoint[5];
            ERectangle r = bound1.getBounds();
            points1[0] = EPoint.fromLambda(r.getMinX(), r.getMinY());
            points1[1] = EPoint.fromLambda(r.getMinX(), r.getMaxY());
            points1[2] = EPoint.fromLambda(r.getMaxX(), r.getMaxY());
            points1[3] = EPoint.fromLambda(r.getMaxX(), r.getMinY());
            points1[4] = EPoint.fromLambda(r.getMinX(), r.getMinY());
        }
        if (bound2 instanceof QCPoly) {
            QCPoly p = (QCPoly)bound2;
            PolyBase.Point[] po = p.poly.getPoints();
            points2 = new EPoint[po.length];
            for (int i = 0; i < po.length; ++i) {
                points2[i] = EPoint.fromLambda(po[i].getX(), po[i].getY());
            }
        } else {
            points2 = new EPoint[5];
            ERectangle r = bound2.getBounds();
            points2[0] = EPoint.fromLambda(r.getMinX(), r.getMinY());
            points2[1] = EPoint.fromLambda(r.getMinX(), r.getMaxY());
            points2[2] = EPoint.fromLambda(r.getMaxX(), r.getMaxY());
            points2[3] = EPoint.fromLambda(r.getMaxX(), r.getMinY());
            points2[4] = EPoint.fromLambda(r.getMinX(), r.getMinY());
        }
        for (int i = 1; i < points1.length; ++i) {
            EPoint p1a = points1[i - 1];
            EPoint p1b = points1[i];
            if (p1a.getX() == p1b.getX() && p1a.getY() == p1b.getY()) continue;
            double l1X = Math.min(p1a.getX(), p1b.getX());
            double h1X = Math.max(p1a.getX(), p1b.getX());
            double l1Y = Math.min(p1a.getY(), p1b.getY());
            double h1Y = Math.max(p1a.getY(), p1b.getY());
            for (int j = 1; j < points2.length; ++j) {
                EPoint p2a = points2[j - 1];
                EPoint p2b = points2[j];
                if (p2a.getX() == p2b.getX() && p2a.getY() == p2b.getY()) continue;
                double l2X = Math.min(p2a.getX(), p2b.getX());
                double h2X = Math.max(p2a.getX(), p2b.getX());
                double l2Y = Math.min(p2a.getY(), p2b.getY());
                double h2Y = Math.max(p2a.getY(), p2b.getY());
                if (!(l1X == h1X ? (l2X == h2X ? l1X == l2X && h1Y > l2Y && h2Y > l1Y : l1X > l2X && l1X < h2X && l2Y > l1Y && l2Y < h1Y) : (l2Y == h2Y ? l1Y == l2Y && h1X > l2X && h2X > l1X : l1Y > l2Y && l1Y < h2Y && l2X > l1X && l2X < h1X))) continue;
                return true;
            }
        }
        Poly p1 = new Poly(points1);
        if (p1.contains(points2[0])) {
            return true;
        }
        Poly p2 = new Poly(points2);
        return p2.contains(points1[0]);
    }

    private boolean initializeDesignRules() {
        Layer lay;
        Technology tech = this.cell.getTechnology();
        this.allConnectingLayers = new ArrayList<ConnectingLayer>();
        this.allConnectingVias = new ArrayList<ConnectingVia>();
        Iterator<Object> it = tech.getLayers();
        while (it.hasNext()) {
            lay = it.next();
            if (!lay.getFunction().isMetal() || (lay.getFunctionExtras() & 0x4000000) != 0) continue;
            int metNum = lay.getFunction().getLevel() - 1;
            boolean found = false;
            for (ConnectingLayer cl : this.allConnectingLayers) {
                for (Layer otherLayer : cl.layers) {
                    if (!otherLayer.getFunction().isMetal() || otherLayer.getFunction().getLevel() - 1 != metNum) continue;
                    cl.layers.add(lay);
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
            if (found) continue;
            ConnectingLayer cl = new ConnectingLayer();
            cl.layers.add(lay);
            this.allConnectingLayers.add(cl);
        }
        for (ConnectingLayer cl : this.allConnectingLayers) {
            for (Layer lay2 : cl.layers) {
                int colorNum = lay2.getFunction().getMaskColor();
                if (colorNum != 0) continue;
                cl.primaryLayer = lay2;
            }
            if (cl.primaryLayer != null) continue;
            cl.primaryLayer = cl.layers.get(0);
        }
        it = tech.getLayers();
        while (it.hasNext()) {
            lay = (Layer)it.next();
            if (!lay.getFunction().isPoly() || (lay.getFunctionExtras() & 0x4000000) != 0) continue;
            ConnectingLayer cl = new ConnectingLayer();
            cl.layers.add(lay);
            cl.primaryLayer = lay;
            this.allConnectingLayers.add(cl);
        }
        for (ConnectingLayer cl : this.allConnectingLayers) {
            for (Layer lay3 : cl.layers) {
                Iterator<ArcProto> it2 = tech.getArcs();
                block8: while (it2.hasNext()) {
                    ArcProto ap = it2.next();
                    Technology.ArcLayer[] arcLayers = ap.getArcLayers();
                    for (int i = 0; i < arcLayers.length; ++i) {
                        Technology.ArcLayer al = arcLayers[i];
                        if (al.getLayer() != lay3) continue;
                        cl.arcs.add(ap);
                        continue block8;
                    }
                }
            }
        }
        it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = (PrimitiveNode)it.next();
            if (!np.getFunction().isContact()) continue;
            Technology.NodeLayer[] nodeLayers = np.getNodeLayers();
            Layer viaLayer = null;
            for (int i = 0; i < nodeLayers.length; ++i) {
                Technology.NodeLayer nl = nodeLayers[i];
                if (!nl.getLayer().getFunction().isContact()) continue;
                viaLayer = nl.getLayer();
                break;
            }
            if (viaLayer == null) {
                System.out.println("WARNING: Contact " + np.describe(false) + " has no via layer in it");
                continue;
            }
            ConnectingVia thisCV = null;
            for (ConnectingVia cv : this.allConnectingVias) {
                if (cv.viaLayer != viaLayer) continue;
                thisCV = cv;
                break;
            }
            if (thisCV == null) {
                thisCV = new ConnectingVia();
                thisCV.viaLayer = viaLayer;
                this.allConnectingVias.add(thisCV);
            }
            ArcProto[] conns = np.getPort(0).getConnections();
            ArrayList<ArcProto> validArcs = new ArrayList<ArcProto>();
            for (int i = 0; i < conns.length; ++i) {
                ArcProto ap = conns[i];
                if (ap.getTechnology() != tech) continue;
                validArcs.add(ap);
            }
            if (validArcs.size() != 2) {
                System.out.println("WARNING: Node " + np.describe(false) + " connects to " + validArcs.size() + " arcs (should be 2)");
                continue;
            }
            ConnectingLayer lay1 = null;
            ConnectingLayer lay2 = null;
            block14: for (ArcProto ap : validArcs) {
                for (ConnectingLayer cl : this.allConnectingLayers) {
                    if (!cl.arcs.contains(ap)) continue;
                    if (lay1 == null) {
                        lay1 = cl;
                        continue block14;
                    }
                    lay2 = cl;
                    continue block14;
                }
            }
            if (lay1 == null || lay2 == null) {
                System.out.println("WARNING: Could not find layers for arcs " + ((ArcProto)validArcs.get(0)).describe() + " and " + ((ArcProto)validArcs.get(1)).describe());
                continue;
            }
            if (thisCV.layer1 != null) {
                if (thisCV.layer1 == lay1 && thisCV.layer2 == lay2 || thisCV.layer1 == lay2 && thisCV.layer2 == lay1) continue;
                System.out.println("WARNING: Via " + thisCV.viaLayer.getName() + " connects layers " + thisCV.layer1.primaryLayer.getName() + " and " + thisCV.layer2.primaryLayer.getName() + " but contact " + np.describe(false) + " joins layers " + lay1.primaryLayer.getName() + " and " + lay2.primaryLayer.getName());
                continue;
            }
            thisCV.layer1 = lay1;
            thisCV.layer2 = lay2;
        }
        this.removeLayers = new HashMap<Layer, Layer>();
        it = tech.getLayers();
        block16: while (it.hasNext()) {
            boolean found;
            lay = (Layer)it.next();
            int extra = lay.getFunctionExtras();
            if ((extra & 0x4000000) == 0) continue;
            if (lay.getFunction().isMetal()) {
                int metNum = lay.getFunction().getLevel() - 1;
                found = false;
                for (ConnectingLayer cl : this.allConnectingLayers) {
                    for (Layer otherLayer : cl.layers) {
                        if (!otherLayer.getFunction().isMetal() || otherLayer.getFunction().getLevel() - 1 != metNum) continue;
                        this.removeLayers.put(lay, cl.primaryLayer);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    continue block16;
                }
                continue;
            }
            if (!lay.getFunction().isPoly()) continue;
            int polyNum = lay.getFunction().getLevel() - 1;
            found = false;
            for (ConnectingLayer cl : this.allConnectingLayers) {
                for (Layer otherLayer : cl.layers) {
                    if (!otherLayer.getFunction().isPoly() || otherLayer.getFunction().getLevel() - 1 != polyNum) continue;
                    this.removeLayers.put(lay, cl.primaryLayer);
                    found = true;
                    break;
                }
                if (!found) continue;
                continue block16;
            }
        }
        return false;
    }

    class ConnectingLayer {
        private Layer primaryLayer;
        private List<Layer> layers = new ArrayList<Layer>();
        private List<ArcProto> arcs = new ArrayList<ArcProto>();
        private GeometryTree tree = new GeometryTree(null);

        ConnectingLayer() {
        }
    }

    private static class GeometryTree {
        private RTNode<QCBound> root;

        private GeometryTree(RTNode<QCBound> root) {
            this.root = root;
        }

        private RTNode<QCBound> getRoot() {
            return this.root;
        }

        private void setRoot(RTNode<QCBound> root) {
            this.root = root;
        }

        private boolean isEmpty() {
            return this.root == null;
        }

        private Iterator<QCBound> search(Rectangle2D searchArea) {
            if (this.root == null) {
                return Collections.emptyList().iterator();
            }
            RTNode.Search<QCBound> it = new RTNode.Search<QCBound>(searchArea, this.root, true);
            return it;
        }
    }

    public static class QCBound
    extends QCNetID
    implements RTBounds {
        private ERectangle bound;

        QCBound(ERectangle bound, MutableInteger netID, Geometric topGeom) {
            super(netID, topGeom);
            this.bound = bound;
        }

        @Override
        public ERectangle getBounds() {
            return this.bound;
        }

        public boolean containsPoint(double x, double y) {
            return x >= this.bound.getMinX() && x <= this.bound.getMaxX() && y >= this.bound.getMinY() && y <= this.bound.getMaxY();
        }

        public boolean isManhattan() {
            return true;
        }

        public String toString() {
            return "Geometry on net " + this.getNetID();
        }
    }

    public static class StoreTopology
    extends Job {
        private Cell cell;
        private String[] topology;

        public StoreTopology(Cell cell, String[] topology) {
            super("Store quick topology", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.topology = topology;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Date revDate = this.cell.getRevisionDate();
            Date nowDate = new Date();
            this.cell.newVar(TOPOLOGY_QUICK_DATE, (Object)nowDate.getTime(), this.getEditingPreferences());
            this.cell.newVar(TOPOLOGY_QUICK_DATA, (Object)this.topology, this.getEditingPreferences());
            this.cell.lowLevelSetRevisionDate(revDate);
            return true;
        }
    }

    class ConnectingVia {
        private Layer viaLayer;
        private ConnectingLayer layer1;
        private ConnectingLayer layer2;
        private GeometryTree tree = new GeometryTree(null);

        ConnectingVia() {
        }
    }

    public static class QCPoly
    extends QCBound {
        private PolyBase poly;

        QCPoly(ERectangle bound, MutableInteger netID, PolyBase poly, Geometric topGeom) {
            super(bound, netID, topGeom);
            this.poly = poly;
        }

        @Override
        public boolean containsPoint(double x, double y) {
            return this.poly.isInside(new Point2D.Double(x, y));
        }

        @Override
        public boolean isManhattan() {
            PolyBase.Point[] pts = this.poly.getPoints();
            for (int i = 1; i < pts.length; ++i) {
                if (pts[i].getX() == pts[i - 1].getX() || pts[i].getY() == pts[i - 1].getY()) continue;
                return false;
            }
            return true;
        }

        public PolyBase getPoly() {
            return this.poly;
        }
    }

    public static class QCVia
    extends QCBound {
        QCVia(ERectangle rect, MutableInteger netID) {
            super(rect, netID, null);
        }

        @Override
        public String toString() {
            return "Via on net " + this.getNetID();
        }
    }

    public static class QCNetID {
        private MutableInteger netID;
        private Geometric topGeom;

        QCNetID(MutableInteger netID, Geometric topGeom) {
            this.netID = netID;
            this.topGeom = topGeom;
        }

        public MutableInteger getNetID() {
            return this.netID;
        }

        public Geometric getTopGeom() {
            return this.topGeom;
        }

        public void setNetID(MutableInteger n) {
            this.netID = n;
        }

        public void updateNetID(MutableInteger n, Map<Integer, List<MutableInteger>> netIDsByValue) {
            if (this.isSameBasicNet(n)) {
                return;
            }
            List<MutableInteger> oldNetIDs = netIDsByValue.get(this.netID.intValue());
            if (oldNetIDs == null) {
                return;
            }
            Integer netIDI = n.intValue();
            List<MutableInteger> newNetIDs = netIDsByValue.get(netIDI);
            if (newNetIDs == null) {
                newNetIDs = new ArrayList<MutableInteger>();
                netIDsByValue.put(netIDI, newNetIDs);
            }
            for (MutableInteger mi : oldNetIDs) {
                mi.setValue(n.intValue());
                newNetIDs.add(mi);
            }
            oldNetIDs.clear();
        }

        public boolean isSameBasicNet(MutableInteger otherNetID) {
            int netValue = 0;
            if (this.netID != null) {
                netValue = this.netID.intValue();
            }
            return netValue == otherNetID.intValue();
        }
    }
}

