/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Name
implements Comparable {
    private final String ons;
    private final String ns;
    private final Name lowerCase;
    private Name[] subnames;
    private final Name basename;
    private final int numSuffix;
    private int flags;
    private static Map allNames = new HashMap();
    private static final int ERROR = 1;
    private static final int LIST = 2;
    private static final int BUS = 4;
    private static final int SIMPLE = 8;
    private static final int TEMP = 16;
    private static final int DUPLICATES = 32;
    private static final int HAS_EMPTIES = 64;

    public static final synchronized Name findName(String ns) {
        return Name.findTrimmedName(Name.trim(ns));
    }

    public static String checkName(String ns) {
        try {
            Name.checkNameThrow(ns);
            return null;
        }
        catch (NumberFormatException e) {
            return e.getMessage();
        }
    }

    public final String toString() {
        return this.ons;
    }

    public final Name lowerCase() {
        return this.lowerCase;
    }

    public int compareTo(Name name) {
        if (this.lowerCase == name.lowerCase) {
            return 0;
        }
        return this.lowerCase.ns.compareTo(name.lowerCase.ns);
    }

    public int compareTo(Object o) {
        return this.compareTo((Name)o);
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof Name) {
            Name anotherName = (Name)anObject;
            return this.lowerCase == anotherName.lowerCase;
        }
        return false;
    }

    public int hashCode() {
        return this.lowerCase == this ? super.hashCode() : this.lowerCase.hashCode();
    }

    public final boolean isValid() {
        return (this.flags & 1) == 0;
    }

    public final boolean isTempname() {
        return (this.flags & 0x10) != 0;
    }

    public final boolean hasDuplicates() {
        return (this.flags & 0x20) != 0;
    }

    public final boolean hasEmptySubnames() {
        return (this.flags & 0x40) != 0;
    }

    public final boolean isList() {
        return (this.flags & 2) != 0;
    }

    public final boolean isBus() {
        return this.subnames != null;
    }

    public final Name subname(int i) {
        return this.subnames == null ? this : this.subnames[i];
    }

    public final int busWidth() {
        return this.subnames == null ? 1 : this.subnames.length;
    }

    public final Name getBasename() {
        return this.basename;
    }

    public final int getNumSuffix() {
        return this.numSuffix;
    }

    public final Name findSuffixed(int i) {
        if (i < 0 || this.basename == null) {
            return null;
        }
        return Name.findName(this.basename.toString() + i);
    }

    private static Name findTrimmedName(String ns) {
        Name name = (Name)allNames.get(ns);
        if (name == null && ns != null) {
            name = new Name(ns);
            allNames.put(name.ons, name);
        }
        return name;
    }

    private static String trim(String ns) {
        if (ns == null) {
            return null;
        }
        int len = ns.length();
        int newLen = 0;
        for (int i = 0; i < len; ++i) {
            if (ns.charAt(i) <= ' ') continue;
            ++newLen;
        }
        if (newLen == len) {
            return ns;
        }
        StringBuffer buf = new StringBuffer(newLen);
        for (int i = 0; i < len; ++i) {
            if (ns.charAt(i) <= ' ') continue;
            buf.append(ns.charAt(i));
        }
        return buf.toString();
    }

    private static String trimPlusMinus(String ns) {
        int len = ns.length();
        int newLen = 0;
        for (int i = 0; i < len; ++i) {
            char ch = ns.charAt(i);
            if (ch == '+' || ch == '-') continue;
            ++newLen;
        }
        if (newLen == len) {
            return ns;
        }
        StringBuffer buf = new StringBuffer(newLen);
        for (int i = 0; i < len; ++i) {
            char ch = ns.charAt(i);
            if (ch == '+' || ch == '-') continue;
            buf.append(ns.charAt(i));
        }
        return buf.toString();
    }

    private Name(String ons) {
        this.ons = ons;
        this.ns = Name.trimPlusMinus(ons);
        int suffix = 0;
        Name base = this;
        String lower = this.ns.toLowerCase();
        this.lowerCase = this.ns.equals(lower) ? this : Name.findTrimmedName(lower);
        try {
            this.flags = Name.checkNameThrow(this.ns);
        }
        catch (NumberFormatException e) {
            this.flags = 1;
        }
        if ((this.flags & 8) != 0) {
            int l;
            for (l = this.ns.length(); l > 0 && TextUtils.isDigit(this.ns.charAt(l - 1)); --l) {
            }
            if (l == this.ns.length()) {
                base = this;
            } else {
                base = Name.findTrimmedName(this.ns.substring(0, l));
                suffix = TextUtils.atoi(this.ns.substring(l));
            }
        }
        this.numSuffix = suffix;
        this.basename = base;
        if (this.flags == 1) {
            return;
        }
        if ((this.flags & 4) == 0) {
            return;
        }
        if (this.isList()) {
            this.makeListSubNames();
            return;
        }
        int split = this.ns.indexOf(91);
        if (split == 0) {
            split = this.ns.lastIndexOf(91);
        }
        if (split == 0) {
            this.makeBracketSubNames();
        } else {
            this.makeSplitSubNames(split);
        }
    }

    private void makeListSubNames() {
        ArrayList<Name> subs = new ArrayList<Name>();
        int beg = 0;
        while (beg <= this.ns.length()) {
            int end;
            for (end = beg; end < this.ns.length() && this.ns.charAt(end) != ','; ++end) {
                if (this.ns.charAt(end) != '[') continue;
                while (this.ns.charAt(end) != ']') {
                    ++end;
                }
            }
            Name nm = Name.findTrimmedName(this.ns.substring(beg, end));
            for (int j = 0; j < nm.busWidth(); ++j) {
                subs.add(nm.subname(j));
            }
            beg = end + 1;
        }
        this.setSubnames(subs);
    }

    private void makeBracketSubNames() {
        ArrayList<Name> subs = new ArrayList<Name>();
        int beg = 1;
        while (beg < this.ns.length()) {
            int colon;
            int end = this.ns.indexOf(44, beg);
            if (end < 0) {
                end = this.ns.length() - 1;
            }
            if ((colon = this.ns.indexOf(58, beg)) < 0 || colon >= end) {
                Name nm = Name.findTrimmedName("[" + this.ns.substring(beg, end) + "]");
                subs.add(nm);
            } else {
                int ind2;
                int ind1 = Integer.parseInt(this.ns.substring(beg, colon));
                if (ind1 < (ind2 = Integer.parseInt(this.ns.substring(colon + 1, end)))) {
                    for (i = ind1; i <= ind2; ++i) {
                        subs.add(Name.findTrimmedName("[" + i + "]"));
                    }
                } else {
                    for (i = ind1; i >= ind2; --i) {
                        subs.add(Name.findTrimmedName("[" + i + "]"));
                    }
                }
            }
            beg = end + 1;
        }
        this.setSubnames(subs);
    }

    private void setSubnames(List subs) {
        this.subnames = new Name[subs.size()];
        subs.toArray(this.subnames);
        Object[] sorted = new Name[subs.size()];
        subs.toArray(sorted);
        Arrays.sort(sorted);
        for (int i = 1; i < sorted.length; ++i) {
            if (!((Name)sorted[i]).equals(sorted[i - 1])) continue;
            this.flags |= 0x20;
            break;
        }
    }

    private void makeSplitSubNames(int split) {
        if (split < 0 || split >= this.ns.length()) {
            System.out.println("HEY! string is '" + this.ns + "' but want index " + split);
            return;
        }
        Name baseName = Name.findTrimmedName(this.ns.substring(0, split));
        Name indexList = Name.findTrimmedName(this.ns.substring(split));
        this.subnames = new Name[baseName.busWidth() * indexList.busWidth()];
        for (int i = 0; i < baseName.busWidth(); ++i) {
            String bs = baseName.subname(i).toString();
            for (int j = 0; j < indexList.busWidth(); ++j) {
                String is = indexList.subname(j).toString();
                this.subnames[i * indexList.busWidth() + j] = Name.findTrimmedName(bs + is);
            }
        }
        if (baseName.hasDuplicates() || indexList.hasDuplicates()) {
            this.flags |= 0x20;
        }
    }

    private static int checkNameThrow(String ns) throws NumberFormatException {
        int flags = 8;
        int bracket = -1;
        boolean wasBrackets = false;
        int colon = -1;
        if (ns.length() == 0) {
            flags |= 0x40;
        }
        for (int i = 0; i < ns.length(); ++i) {
            int j;
            char c = ns.charAt(i);
            if (bracket < 0) {
                colon = -1;
                if (c == ']') {
                    throw new NumberFormatException("unmatched ']' in name");
                }
                if (c == ':') {
                    throw new NumberFormatException("':' out of brackets");
                }
                if (c == '[') {
                    bracket = i;
                    flags &= 0xFFFFFFF7;
                    if (i == 0 || ns.charAt(i - 1) == ',') {
                        flags |= 0x40;
                    }
                    wasBrackets = true;
                } else if (c == ',') {
                    flags |= 6;
                    flags &= 0xFFFFFFF7;
                    if (i == 0 || ns.charAt(i - 1) == ',') {
                        flags |= 0x40;
                    }
                    wasBrackets = false;
                } else if (wasBrackets) {
                    throw new NumberFormatException("Wrong character after brackets");
                }
                if (c != '@') continue;
                flags |= 0x10;
                continue;
            }
            if (c == '[') {
                throw new NumberFormatException("nested bracket '[' in name");
            }
            if (c == ':') {
                if (colon >= 0) {
                    throw new NumberFormatException("too many ':' inside brackets");
                }
                if (i == bracket + 1) {
                    throw new NumberFormatException("has missing start of index range");
                }
                if (ns.charAt(bracket + 1) == '-') {
                    throw new NumberFormatException("has negative start of index range");
                }
                for (j = bracket + 1; j < i; ++j) {
                    if (TextUtils.isDigit(ns.charAt(j))) continue;
                    throw new NumberFormatException("has nonnumeric start of index range");
                }
                colon = i;
                flags |= 4;
            }
            if (colon >= 0 && (c == ']' || c == ',')) {
                if (i == colon + 1) {
                    throw new NumberFormatException("has missing end of index range");
                }
                if (ns.charAt(colon + 1) == '-') {
                    throw new NumberFormatException("has negative end of index range");
                }
                for (j = colon + 1; j < i; ++j) {
                    if (TextUtils.isDigit(ns.charAt(j))) continue;
                    throw new NumberFormatException("has nonnumeric end of index range");
                }
                if (Integer.parseInt(ns.substring(bracket + 1, colon)) == Integer.parseInt(ns.substring(colon + 1, i))) {
                    throw new NumberFormatException("has equal start and end indices");
                }
                colon = -1;
            }
            if (c == ']') {
                bracket = -1;
            }
            if (c == ',') {
                bracket = i;
                flags |= 4;
            }
            if (c != '@') continue;
            throw new NumberFormatException("'@' in brackets");
        }
        if ((flags & 0x10) != 0 && (flags & 2) != 0) {
            throw new NumberFormatException("list of temporary names");
        }
        if (bracket != -1) {
            throw new NumberFormatException("Unclosed bracket");
        }
        return flags;
    }
}

