/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.patterns;

import com.sun.electric.tool.util.concurrent.patterns.PForTask;
import com.sun.electric.tool.util.concurrent.patterns.PJob;
import com.sun.electric.tool.util.concurrent.patterns.PTask;
import com.sun.electric.tool.util.concurrent.runtime.taskParallel.IThreadPool;
import com.sun.electric.tool.util.concurrent.utils.BlockedRange;
import java.util.List;

public class PForJob<T extends BlockedRange<T>>
extends PJob {
    public PForJob(T range2, PForTask<T> task) {
        this.add(new SplitIntoTasks<T>(this, range2, task), -1);
    }

    public PForJob(T range2, PForTask<T> task, IThreadPool pool) {
        super(pool);
        this.add(new SplitIntoTasks<T>(this, range2, task), -1);
    }

    public static final class SplitterTask<T extends BlockedRange<T>>
    extends PTask {
        private T range;
        private PForTask<T> task;

        public SplitterTask(PJob job, T range2, PForTask<T> task, int number, int total) {
            super(job);
            this.range = ((BlockedRange)range2).createInstance(number, total);
            this.task = task;
        }

        @Override
        public void execute() {
            List tmpRange;
            int step = this.job.getThreadPool().getPoolSize();
            while ((tmpRange = ((BlockedRange)this.range).splitBlockedRange(step)) != null) {
                for (BlockedRange tr : tmpRange) {
                    try {
                        PForTask taskObj = (PForTask)this.task.clone();
                        taskObj.setRange(tr);
                        taskObj.setPJob(this.job);
                        this.job.add(taskObj, -1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static final class SplitIntoTasks<T extends BlockedRange<T>>
    extends PTask {
        private T range;
        private PForTask<T> task;

        public SplitIntoTasks(PJob job, T range2, PForTask<T> task) {
            super(job);
            this.range = range2;
            this.task = task;
        }

        @Override
        public void execute() {
            int threadNum = this.job.getThreadPool().getPoolSize();
            for (int i = 0; i < threadNum; ++i) {
                this.job.add(new SplitterTask<T>(this.job, this.range, this.task, i, threadNum));
            }
        }
    }
}

