/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import java.io.PrintStream;

public class ImmutableNet {
    private static boolean DEBUG = false;
    final CellTree cellTree;
    final TechPool techPool;
    final Schematics schemTech;
    final PrimitivePortId busPinPortId;
    final ArcProto busArc;
    final CellBackup cellBackup;
    final CellRevision cellRevision;
    final CellId cellId;
    final ImmutableExport.Iterable exports;
    final ImmutableNodeInst.Iterable nodes;
    final ImmutableArcInst.Iterable arcs;
    final int numExports;
    final int numNodes;
    final int numArcs;
    final int[] ni_pi;
    final int arcsOffset;
    final int[] drawns;
    public final int numDrawns;
    public final int numExportedDrawns;
    public final int numConnectedDrawns;

    public ImmutableNet(CellTree cellTree) {
        ImmutableNodeInst n;
        int nodeIndex;
        this.cellTree = cellTree;
        this.techPool = cellTree.techPool;
        Generic genericTech = this.techPool.getGeneric();
        Artwork artworkTech = this.techPool.getArtwork();
        this.schemTech = this.techPool.getSchematics();
        PrimitiveNode invisiblePinNode = genericTech != null ? genericTech.invisiblePinNode : null;
        PrimitiveNode simProbeNode = genericTech != null ? genericTech.simProbeNode : null;
        PrimitiveNode pinNode = artworkTech != null ? artworkTech.pinNode : null;
        this.busPinPortId = this.schemTech != null ? this.schemTech.busPinNode.getPort(0).getId() : null;
        this.busArc = this.schemTech != null ? this.schemTech.bus_arc : null;
        this.cellBackup = cellTree.top;
        this.cellRevision = this.cellBackup.cellRevision;
        this.exports = this.cellRevision.exports;
        this.nodes = this.cellRevision.nodes;
        this.arcs = this.cellRevision.arcs;
        this.numExports = this.cellRevision.exports.size();
        this.numNodes = this.cellRevision.nodes.size();
        this.numArcs = this.cellRevision.arcs.size();
        this.cellId = this.cellRevision.d.cellId;
        this.ni_pi = new int[this.numNodes];
        int offset = this.numExports;
        for (nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            n = this.nodes.get(nodeIndex);
            this.ni_pi[nodeIndex] = offset;
            offset += this.getNumPorts(n.protoId);
        }
        this.arcsOffset = offset;
        this.drawns = ImmutableNet.initMap(this.arcsOffset + this.numArcs);
        for (int exportIndex = 0; exportIndex < this.cellRevision.exports.size(); ++exportIndex) {
            ImmutableExport e = this.cellRevision.exports.get(exportIndex);
            if (this.isIsolated(e.originalPortId)) continue;
            ImmutableNet.connectMap(this.drawns, exportIndex, this.mapIndex(e.originalNodeId, e.originalPortId));
            if (!DEBUG) continue;
            System.err.println("Connect export " + exportIndex + " " + this.mapIndex(e.originalNodeId, e.originalPortId));
        }
        for (int arcIndex = 0; arcIndex < this.numArcs; ++arcIndex) {
            ImmutableArcInst a = this.cellRevision.arcs.get(arcIndex);
            ArcProto ap = this.techPool.getArcProto(a.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC) continue;
            if (!(this.isIsolated(a.tailPortId) || a.tailPortId == this.busPinPortId && ap != this.busArc)) {
                ImmutableNet.connectMap(this.drawns, this.arcsOffset + arcIndex, this.mapIndex(a.tailNodeId, a.tailPortId));
                if (DEBUG) {
                    System.err.println("Connect tail " + (this.arcsOffset + arcIndex) + " " + this.mapIndex(a.tailNodeId, a.tailPortId));
                }
            }
            if (this.isIsolated(a.headPortId) || a.headPortId == this.busPinPortId && ap != this.busArc) continue;
            ImmutableNet.connectMap(this.drawns, this.arcsOffset + arcIndex, this.mapIndex(a.headNodeId, a.headPortId));
            if (!DEBUG) continue;
            System.err.println("Connect head " + (this.arcsOffset + arcIndex) + " " + this.mapIndex(a.headNodeId, a.headPortId));
        }
        for (nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            PrimitiveNode pn;
            n = this.cellRevision.nodes.get(nodeIndex);
            if (!(n.protoId instanceof PrimitiveNodeId) || (pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n.protoId)).getNumPorts() <= 1) continue;
            int mapOffset = this.ni_pi[nodeIndex];
            for (int i = 1; i < pn.getNumPorts(); ++i) {
                PrimitivePort ppi = pn.getPort(i);
                for (int j = 0; j < i; ++j) {
                    PrimitivePort ppj = pn.getPort(j);
                    if (ppi.getTopology() != ppj.getTopology()) continue;
                    assert (!ppi.isIsolated() && !ppj.isIsolated());
                    ImmutableNet.connectMap(this.drawns, mapOffset + i, mapOffset + j);
                    if (!DEBUG) continue;
                    System.err.println("Connect topology " + (mapOffset + i) + " " + (mapOffset + j));
                }
            }
        }
        if (DEBUG) {
            this.printDrawns(System.err, "before closure");
        }
        ImmutableNet.closureMap(this.drawns);
        if (DEBUG) {
            this.printDrawns(System.err, "after closure");
        }
        int curDrawn = 0;
        for (int exportIndex = 0; exportIndex < this.cellRevision.exports.size(); ++exportIndex) {
            if (!this.addDrawn(exportIndex, curDrawn)) continue;
            ++curDrawn;
        }
        this.numExportedDrawns = curDrawn;
        for (int arcIndex = 0; arcIndex < this.numArcs; ++arcIndex) {
            ImmutableArcInst a = this.cellRevision.arcs.get(arcIndex);
            ArcProto ap = this.techPool.getArcProto(a.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC) {
                this.nullDrawn(this.arcsOffset + arcIndex);
                continue;
            }
            if (!this.addDrawn(this.arcsOffset + arcIndex, curDrawn)) continue;
            ++curDrawn;
        }
        this.numConnectedDrawns = curDrawn;
        for (int nodeIndex2 = 0; nodeIndex2 < this.numNodes; ++nodeIndex2) {
            int numPortInsts;
            int mapOffset;
            ImmutableNodeInst n2;
            block26: {
                n2 = this.cellRevision.nodes.get(nodeIndex2);
                mapOffset = this.ni_pi[nodeIndex2];
                if (n2.protoId instanceof CellId) {
                    if (!this.isIconOfParent(n2)) {
                        numPortInsts = this.getNumPorts(n2.protoId);
                        for (int portIndex = 0; portIndex < numPortInsts; ++portIndex) {
                            if (!this.addDrawn(mapOffset + portIndex, curDrawn)) continue;
                            ++curDrawn;
                        }
                        continue;
                    }
                } else {
                    PrimitiveNode pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n2.protoId);
                    if ((pn.getFunction() != PrimitiveNode.Function.ART || pn == simProbeNode) && pn != pinNode && pn != invisiblePinNode) {
                        int numPortInsts2 = this.getNumPorts(n2.protoId);
                        for (int portIndex = 0; portIndex < numPortInsts2; ++portIndex) {
                            if (pn.getPort(portIndex).isIsolated()) {
                                this.nullDrawn(mapOffset + portIndex);
                                continue;
                            }
                            if (!this.addDrawn(mapOffset + portIndex, curDrawn)) continue;
                            ++curDrawn;
                        }
                    }
                }
                break block26;
                continue;
            }
            numPortInsts = this.getNumPorts(n2.protoId);
            for (int portIndex = 0; portIndex < numPortInsts; ++portIndex) {
                this.addDrawn(mapOffset + portIndex, -1);
            }
        }
        this.numDrawns = curDrawn;
        for (int i = 0; i < this.drawns.length; ++i) {
            int d = this.drawns[i];
            assert (d < 0);
            this.drawns[i] = -2 - d;
        }
        if (DEBUG) {
            this.printDrawns(System.err, "at the end");
        }
    }

    public void printDrawns(PrintStream out, String msg) {
        out.println("Drawns of " + this.cellId + " " + msg);
        for (int exportIndex = 0; exportIndex < this.numExports; ++exportIndex) {
            ImmutableExport e = this.exports.get(exportIndex);
            out.println("Export " + e.name + " " + this.getDrawn(e.exportId) + " " + this.drawns[exportIndex]);
        }
        for (int nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            ImmutableNodeInst n = this.nodes.get(nodeIndex);
            int mapOffset = this.ni_pi[nodeIndex];
            int numPortInsts = this.getNumPorts(n.protoId);
            for (int portIndex = 0; portIndex < numPortInsts; ++portIndex) {
                if (n.protoId instanceof CellId) {
                    ImmutableExport e = this.getSubTree((CellId)((CellId)n.protoId)).top.cellRevision.exports.get(portIndex);
                    out.println("PortInst " + n.name + " " + e.exportId.parentId + ":" + e.name + " " + this.getDrawn(n, e.exportId) + " " + this.drawns[mapOffset + portIndex]);
                    continue;
                }
                PrimitivePort p = this.techPool.getPrimitiveNode((PrimitiveNodeId)n.protoId).getPort(portIndex);
                out.println("PortInst " + n.name + " " + n.protoId + ":" + p.getName() + " " + this.getDrawn(n, p.getId()) + " " + this.drawns[mapOffset + portIndex]);
            }
        }
        for (int arcIndex = 0; arcIndex < this.numArcs; ++arcIndex) {
            ImmutableArcInst a = this.arcs.get(arcIndex);
            out.println("Arc " + a.name + " " + this.getDrawn(a) + " " + this.drawns[this.arcsOffset + arcIndex]);
        }
    }

    public int getDrawn(ExportId exportId) {
        assert (exportId.parentId == this.cellId);
        int exportIndex = this.cellRevision.getExportIndexByExportId(exportId);
        assert (this.exports.get((int)exportIndex).exportId == exportId);
        return this.drawns[exportIndex];
    }

    public int getDrawn(ImmutableNodeInst n, PortProtoId portId) {
        int nodeIndex = this.nodeIndexByNodeId(n.nodeId);
        assert (this.nodes.get(nodeIndex) == n);
        return this.drawns[this.mapIndex(n.nodeId, portId)];
    }

    public int getDrawn(ImmutableArcInst a) {
        int arcIndex = this.arcIndexByArcId(a.arcId);
        assert (this.arcs.get(arcIndex) == a);
        return this.drawns[this.arcsOffset + arcIndex];
    }

    private void nullDrawn(int mapIndex) {
        assert (this.drawns[mapIndex] == mapIndex);
        this.drawns[mapIndex] = -1;
    }

    private boolean addDrawn(int mapIndex, int drawn) {
        if (this.drawns[mapIndex] < 0) {
            return false;
        }
        int baseIndex = this.drawns[mapIndex];
        int baseDrawn = this.drawns[baseIndex];
        if (baseDrawn < 0) {
            this.drawns[mapIndex] = baseDrawn;
            return false;
        }
        this.drawns[mapIndex] = this.drawns[baseIndex] = -2 - drawn;
        return true;
    }

    private int mapIndex(int nodeId, PortProtoId portId) {
        return this.ni_pi[this.nodeIndexByNodeId(nodeId)] + this.getPortIndex(portId);
    }

    int nodeIndexByNodeId(int nodeId) {
        return this.cellRevision.getNodeIndexByNodeId(nodeId);
    }

    int arcIndexByArcId(int arcId) {
        return this.cellRevision.getArcIndexByArcId(arcId);
    }

    int getNumPorts(NodeProtoId nodeProtoId) {
        if (nodeProtoId instanceof CellId) {
            return this.getSubTree((CellId)((CellId)nodeProtoId)).top.cellRevision.exports.size();
        }
        return this.techPool.getPrimitiveNode((PrimitiveNodeId)nodeProtoId).getNumPorts();
    }

    int getPortIndex(PortProtoId portId) {
        if (portId instanceof ExportId) {
            return this.getSubTree((CellId)((CellId)portId.parentId)).top.cellRevision.getExportIndexByExportId((ExportId)portId);
        }
        return this.techPool.getPrimitivePort((PrimitivePortId)portId).getPortIndex();
    }

    boolean isIconOfParent(ImmutableNodeInst n) {
        if (!(n.protoId instanceof CellId)) {
            return false;
        }
        CellBackup subCell = this.getSubTree((CellId)((CellId)n.protoId)).top;
        CellId subCellId = subCell.cellRevision.d.cellId;
        return subCellId.isIcon() && this.cellId.isSchematic() && subCellId.libId == this.cellId.libId && subCell.cellRevision.d.groupName.equals(this.cellRevision.d.groupName);
    }

    private CellTree getSubTree(CellId cellId) {
        CellUsage cu = this.cellTree.top.cellRevision.d.cellId.getUsageIn(cellId);
        return this.cellTree.subTrees[cu.indexInParent];
    }

    private boolean isIsolated(PortProtoId portId) {
        return portId instanceof PrimitivePortId && this.techPool.getPrimitivePort((PrimitivePortId)portId).isIsolated();
    }

    static int[] initMap(int size2) {
        int[] map2 = new int[size2];
        for (int i = 0; i < map2.length; ++i) {
            map2[i] = i;
        }
        return map2;
    }

    static boolean connectMap(int[] map2, int a1, int a2) {
        int k;
        int m1 = a1;
        while (map2[m1] != m1) {
            m1 = map2[m1];
        }
        int m2 = a2;
        while (map2[m2] != m2) {
            m2 = map2[m2];
        }
        boolean changed = m1 != m2;
        int m = m1 < m2 ? m1 : m2;
        while (true) {
            k = map2[a1];
            map2[a1] = m;
            if (a1 == k) break;
            a1 = k;
        }
        while (true) {
            k = map2[a2];
            map2[a2] = m;
            if (a2 == k) break;
            a2 = k;
        }
        return changed;
    }

    static void closureMap(int[] map2) {
        for (int i = 0; i < map2.length; ++i) {
            map2[i] = map2[map2[i]];
        }
    }
}

